/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.database.builder.MeetInfoEntityBuilder;
import com.xdja.im.common.database.dao.AbstractDao;
import com.xdja.im.common.database.helper.UpdateArgs;
import com.xdja.im.core.model.message.MeetInfo;
import java.util.ArrayList;
import java.util.List;

public class MeetInfoEntityDao
extends AbstractDao<MeetInfo> {
    private MeetInfoEntityDao() {
    }

    public static MeetInfoEntityDao getInstance() {
        return SingletonInstance.mInstance;
    }

    public long insert(MeetInfo meetInfo) {
        SQLiteDatabase db = this.getDatabase();
        if (db != null) {
            return this.insert(db, meetInfo, MeetInfoEntityBuilder.insertSql());
        }
        return -1L;
    }

    @Override
    public int delete(String sessionFlag) {
        if (TextUtils.isEmpty((CharSequence)sessionFlag)) {
            return -1;
        }
        return super.delete(MeetInfoEntityBuilder.delSql(sessionFlag));
    }

    public int deleteAll() {
        return super.delete(MeetInfoEntityBuilder.delAllSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeetInfo get(String sessionFlag) {
        MeetInfo msgEntryDb = null;
        Cursor cursor = null;
        try {
            cursor = this.query(MeetInfoEntityBuilder.querySql(sessionFlag));
            if (cursor != null && cursor.moveToNext()) {
                msgEntryDb = this.readEntry(cursor, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return msgEntryDb;
    }

    public void update(MeetInfo meetInfo) {
        UpdateArgs args = new UpdateArgs("t_meetinfo");
        ContentValues values = new ContentValues();
        values.put("_id", meetInfo.getId());
        values.put("isShow", Integer.valueOf(meetInfo.getIsShow()));
        values.put("taklFlag", meetInfo.getTaklFlag());
        values.put("tips", meetInfo.getTips());
        String[] whereClause = new String[]{"taklFlag"};
        String[] whereArgs = new String[]{meetInfo.getTaklFlag()};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        this.update(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeetInfo> getAll() {
        ArrayList<MeetInfo> meetInfoList = new ArrayList<MeetInfo>();
        Cursor cursor = null;
        try {
            cursor = this.query(MeetInfoEntityBuilder.queryAll());
            while (cursor != null && cursor.moveToNext()) {
                meetInfoList.add(this.readEntry(cursor, 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return meetInfoList;
    }

    @Override
    protected MeetInfo readEntry(Cursor cursor, int offset) {
        MeetInfo entity = new MeetInfo(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Integer.valueOf(cursor.getInt(offset + 1)), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, MeetInfo entity) {
        String tips;
        String talkFlag;
        Integer isShow;
        stmt.clearBindings();
        Long id2 = entity.getId();
        if (id2 != null) {
            stmt.bindLong(1, id2.longValue());
        }
        if ((isShow = Integer.valueOf(entity.getIsShow())) != null) {
            stmt.bindLong(2, (long)isShow.intValue());
        }
        if ((talkFlag = entity.getTaklFlag()) != null) {
            stmt.bindString(3, talkFlag);
        }
        if ((tips = entity.getTips()) != null) {
            stmt.bindString(4, tips);
        }
    }

    private SQLiteDatabase getDatabase() {
        SQLiteDatabase db = DatabaseManager.getInstance().getDatabase();
        if (db == null) {
            throw new IllegalAccessError("open database failed.");
        }
        return db;
    }

    private static class SingletonInstance {
        private static final MeetInfoEntityDao mInstance = new MeetInfoEntityDao();

        private SingletonInstance() {
        }
    }
}

