/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.proxy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.base.executor.ThreadExecutor;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.CustomComponentCallBack;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnImInitStateCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.OnUserCanAccessToOptionCallBack;
import com.xdja.im.core.callback.SessionDeleteCallBack;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.callback.UpDateSessionConfigCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountType;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.event.IMProxyUpdateSession;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.notify.NotificationBean;
import com.xdja.im.core.proxy.IMUiKitProxy;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.AtAccountNickMap;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;

public class IMUiKitProxyImpl
implements IMUiKitProxy {
    private AccountCallback accountCallback;
    private NotificationCallback notificationCallback;
    private UnReadMessageCallback unReadMessageCallback;
    private OnChatSettingCallback onChatSettingCallback;
    private OnChatUserInfoCallback onChatUserInfoCallback;
    private CommonCallback commonCallback;
    private OnChatMeetCallBack onChatMeetCallBack;
    private ShareSelectCallback shareSelectCallback;
    private OnChatAt2GroupCallBack onChatAt2GroupCallBack;
    private OnShareOverCallback onShareOverCallback;
    private UpDateSessionConfigCallback upDateSessionConfigCallback;
    private CustomComponentCallBack mCustomComponentCallBack;
    private SessionDeleteCallBack mSessionDeleteCallBack;
    private OnUserCanAccessToOptionCallBack mOnUserCanAccessToOptionCallBack;
    private OnImInitStateCallback mOnImInitStateCallback;
    private ThreadExecutor threadExecutor = new ThreadExecutor();

    private IMUiKitProxyImpl() {
    }

    public static IMUiKitProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    public void releaseProxy() {
        this.accountCallback = null;
        this.notificationCallback = null;
        this.unReadMessageCallback = null;
        this.onChatSettingCallback = null;
        this.commonCallback = null;
        this.onChatAt2GroupCallBack = null;
    }

    @Override
    public void setAccountCallback(AccountCallback callback) {
        this.accountCallback = callback;
    }

    @Override
    public void setNotificationCallback(NotificationCallback callback) {
        this.notificationCallback = callback;
    }

    @Override
    public void setUnReadMessageCallback(UnReadMessageCallback callback) {
        this.unReadMessageCallback = callback;
    }

    @Override
    public void setOpenChatSettingCallback(OnChatSettingCallback callback) {
        this.onChatSettingCallback = callback;
    }

    @Override
    public void setOpenChatUserInfoCallback(OnChatUserInfoCallback callback) {
        this.onChatUserInfoCallback = callback;
    }

    @Override
    public void setOnChatMeetCallBack(OnChatMeetCallBack callback) {
        this.onChatMeetCallBack = callback;
    }

    @Override
    public void setShareSelectCallback(ShareSelectCallback callback) {
        this.shareSelectCallback = callback;
    }

    @Override
    public void setCommonCallback(CommonCallback callback) {
        this.commonCallback = callback;
    }

    @Override
    public void registerOnShareOverCallback(OnShareOverCallback callback) {
        this.onShareOverCallback = callback;
    }

    @Override
    public void setUpDateSessionConfig(UpDateSessionConfigCallback upDateSessionConfig) {
        this.upDateSessionConfigCallback = upDateSessionConfig;
    }

    @Override
    public void setAt2GroupMembersCallback(OnChatAt2GroupCallBack callBack) {
        this.onChatAt2GroupCallBack = callBack;
    }

    @Override
    public void go2AtGroupMembersList(String groupId, String account) {
        if (this.onChatAt2GroupCallBack != null) {
            this.onChatAt2GroupCallBack.go2GroupMembersList(groupId, account);
        }
    }

    @Override
    public void notifyGroupMembsItemClick(String mGroupId, String account, String nickName) {
        IMContactEvent.AtGroupEvent event = new IMContactEvent.AtGroupEvent();
        event.setAccount(nickName);
        AtAccountNickMap.putAccountNick(mGroupId, account, nickName);
        BusProvider.getInstance().post(event);
    }

    @Override
    public void upDateConfigUi(@NonNull String type, @NonNull boolean setting, @NonNull String talkFlag) {
        if (this.upDateSessionConfigCallback != null) {
            this.upDateSessionConfigCallback.upDate(type, setting, talkFlag);
        }
    }

    @Override
    public void setCustomComponentCallBack(CustomComponentCallBack callBack) {
        this.mCustomComponentCallBack = callBack;
    }

    @Override
    public void setOnImInitStateCallback(OnImInitStateCallback callback) {
        this.mOnImInitStateCallback = callback;
    }

    @Override
    public void onInitFinished() {
        if (this.mOnImInitStateCallback != null) {
            this.mOnImInitStateCallback.onInitFinished();
        }
    }

    @Override
    public void onInitFailed() {
        if (this.mOnImInitStateCallback != null) {
            this.mOnImInitStateCallback.onInitFailed();
        }
    }

    @Override
    public void onCustomComponentCallBack(Context context, String talkId, int talkType, OptionBean optionBean) {
        if (this.mCustomComponentCallBack != null) {
            this.mCustomComponentCallBack.onComponentCallBack(context, talkId, talkType, optionBean);
        }
    }

    @Override
    public String onCustomMsgSessionShowTip(boolean isMine, String jsonContent) {
        if (this.mCustomComponentCallBack != null) {
            return this.mCustomComponentCallBack.onCustomMsgSessionShowTip(isMine, jsonContent);
        }
        return jsonContent;
    }

    @Override
    public void setSessionDeleteCallBack(SessionDeleteCallBack sessionDeleteCallBack) {
        this.mSessionDeleteCallBack = sessionDeleteCallBack;
    }

    @Override
    public void onSessionDelete(TalkSessionBean sessionBean) {
        if (this.mSessionDeleteCallBack != null) {
            this.mSessionDeleteCallBack.onSessionDelete(sessionBean);
        }
    }

    @Override
    public void cancelNotification(String anto, int type) {
        if (this.commonCallback != null) {
            this.commonCallback.cancelNotification(anto, type);
        }
    }

    @Override
    public void setUserAccessToOption(OnUserCanAccessToOptionCallBack onUserCanAccessToOptionCallBack) {
        this.mOnUserCanAccessToOptionCallBack = onUserCanAccessToOptionCallBack;
    }

    @Override
    public boolean isAccessToOption(OptionBean optionBean) {
        if (this.mOnUserCanAccessToOptionCallBack != null) {
            return this.mOnUserCanAccessToOptionCallBack.isAccessToOption(optionBean);
        }
        return true;
    }

    @Override
    public void clearSessionCache() {
        DataCache.getInstance().clearAll();
        IMProxyUpdateSession updateSession = new IMProxyUpdateSession();
        BusProvider.getInstance().post(updateSession);
    }

    @Override
    public void getAccount(String account, final int type, Subscriber<AccountBean> subscriber) {
        Observable.just((Object)account).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<AccountBean>>(){

            public Observable<AccountBean> call(String account) {
                AccountBean accountBean = null;
                String sessionFlag = ToolUtils.getSessionTag(account, type);
                accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
                if (accountBean != null) {
                    return Observable.just((Object)accountBean);
                }
                if (IMUiKitProxyImpl.this.accountCallback == null) {
                    return Observable.error((Throwable)new IllegalArgumentException("Not register callback."));
                }
                AccountType accountType = AccountType.TYPE_P2P;
                if (type == 1) {
                    accountType = AccountType.TYPE_P2P;
                } else if (type == 2) {
                    accountType = AccountType.TYPE_P2G;
                } else if (type == 201) {
                    accountType = AccountType.TYPE_SYS;
                }
                accountBean = IMUiKitProxyImpl.this.accountCallback.getAccount(account, accountType);
                if (accountBean == null) {
                    return Observable.error((Throwable)new IllegalArgumentException("Get account failed."));
                }
                DataCache.getInstance().put(sessionFlag, accountBean);
                return Observable.just((Object)accountBean);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public AccountBean getAccount(String account, int type) {
        if (null == account) {
            return null;
        }
        String sessionFlag = ToolUtils.getSessionTag(account, type);
        AccountBean accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
        if (accountBean != null) {
            return accountBean;
        }
        if (this.accountCallback == null) {
            LogUtil.e(this.getClass().getName(), "can't get account info, accountCallback is null");
            return null;
        }
        AccountType accountType = AccountType.TYPE_P2P;
        if (type == 1) {
            accountType = AccountType.TYPE_P2P;
        } else if (type == 2) {
            accountType = AccountType.TYPE_P2G;
        } else if (type == 201) {
            accountType = AccountType.TYPE_SYS;
        }
        accountBean = this.accountCallback.getAccount(account, accountType);
        if (accountBean == null) {
            LogUtil.e(this.getClass().getName(), "account info is null, from accountCallback");
            return null;
        }
        DataCache.getInstance().put(sessionFlag, accountBean);
        return accountBean;
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("ERROR: notify account changed, but account is empty.");
            return;
        }
        LogUtil.d("Notify account Changed account " + account + "(" + (Object)((Object)action) + ")");
        String sFlag = ToolUtils.getSessionTag(account, 1);
        switch (action) {
            case ACTION_UPDATE: {
                DataCache.getInstance().remove(sFlag);
                BusProvider.getInstance().post(new IMProxySessionEvent.RefreshSessionListEvent());
                break;
            }
            case ACTION_DELETE: {
                DataCache.getInstance().remove(sFlag);
                IMProxySessionEvent.DeleteSessionEvent deleteSessionEvent = new IMProxySessionEvent.DeleteSessionEvent();
                TalkSessionBean talkSessionBean = new TalkSessionBean();
                talkSessionBean.setTalkerAccount(account);
                talkSessionBean.setTalkType(1);
                deleteSessionEvent.setSessionBean(talkSessionBean);
                BusProvider.getInstance().post(deleteSessionEvent);
            }
        }
    }

    @Override
    public boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb) {
        if (this.notificationCallback == null) {
            LogUtil.d("Notify callback is null.");
            return false;
        }
        NotificationBean notificationBean = new NotificationBean();
        notificationBean.setAccount(sessionBean.getTalkerAccount());
        notificationBean.setTalkId(sessionBean.getTalkFlag());
        notificationBean.setTalkType(sessionBean.getTalkType());
        notificationBean.setMsgCount(newMsgCnt);
        TalkMessageBean talkMessageBean = sessionBean.getLastMsg();
        if (talkMessageBean == null || talkMessageBean.isMine()) {
            LogUtil.w("This notify come form myself, so return!!");
            return true;
        }
        String content = talkMessageBean.getContent();
        switch (talkMessageBean.getMessageType()) {
            case 1: {
                content = CommonTool.getString(R.string.im_uikit_voice);
                break;
            }
            case 3: {
                content = CommonTool.getString(R.string.im_uikit_image);
                break;
            }
            case 2: {
                content = CommonTool.getString(R.string.im_uikit_video);
                break;
            }
            case 4: {
                content = CommonTool.getString(R.string.im_uikit_file);
            }
        }
        notificationBean.setContent(content);
        notificationBean.setDisturb(isDisturb);
        notificationBean.setShowTime(sessionBean.getLastTime());
        LogUtil.d("Start to notify..." + notificationBean.toString());
        this.notificationCallback.notify(notificationBean);
        return true;
    }

    @Override
    public void updateUnReadMessageCount(int count) {
        if (this.unReadMessageCallback == null) {
            LogUtil.d("UnReadMessage callback is null.");
            return;
        }
        LogUtil.d("Update unRead message " + count);
        this.unReadMessageCallback.onRefresh(count);
    }

    @Override
    public boolean openChatSettingCallback(String sessionId, int sessionType) {
        if (this.onChatSettingCallback == null) {
            LogUtil.d("open chat setting callback is null.");
            return false;
        }
        this.onChatSettingCallback.openSetting(sessionId, sessionType);
        return true;
    }

    @Override
    public boolean openChatUserInfoCallback(String account) {
        if (this.onChatUserInfoCallback == null) {
            LogUtil.d("open chat setting callback is null.");
            return false;
        }
        this.onChatUserInfoCallback.openUserInfo(account);
        return true;
    }

    @Override
    public boolean isShowGroupSetting(String groupId) {
        if (this.onChatSettingCallback != null) {
            return this.onChatSettingCallback.isGroupMember(groupId);
        }
        return false;
    }

    @Override
    public void startCallback(String atNo) {
        if (this.commonCallback != null) {
            this.commonCallback.startCallback(atNo);
        }
    }

    @Override
    public void startVoice(String atNo, int type) {
        if (this.commonCallback != null) {
            this.commonCallback.startVoice(atNo, type);
        }
    }

    @Override
    public void addMeetting(String account, String groupId) {
        if (this.onChatMeetCallBack != null) {
            this.onChatMeetCallBack.addMeeting(account, groupId);
        }
    }

    @Override
    public void callSessionContact(Context context, int type, String action) {
        if (this.shareSelectCallback != null) {
            this.shareSelectCallback.callSessionContact(context, type, action);
        }
    }

    @Override
    public void callSessionSearch(Context context, String key, int type, String action) {
        if (this.shareSelectCallback != null) {
            this.shareSelectCallback.callSessionSearch(context, key, type, action);
        }
    }

    @Override
    public void shareOverCallback(Context context) {
        if (this.onShareOverCallback != null) {
            this.onShareOverCallback.shareOverCallback(context);
        }
    }

    @Override
    public void startLocation(String atNo) {
        if (this.commonCallback != null) {
            this.commonCallback.startLocation(atNo);
        }
    }

    private static class SingletonInstance {
        private static final IMUiKitProxyImpl mInstance = new IMUiKitProxyImpl();

        private SingletonInstance() {
        }
    }
}

