/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.utils;

import android.util.LruCache;

public class DataCache {
    private LruCache<String, Object> mCache = new LruCache((int)(Runtime.getRuntime().maxMemory() / 8L));

    private DataCache() {
    }

    public static DataCache getInstance() {
        return SingletonInstance.mInstance;
    }

    public Object put(String key, Object value) {
        return this.mCache.put((Object)key, value);
    }

    public Object get(String key) {
        return this.mCache.get((Object)key);
    }

    public void remove(String key) {
        if (this.mCache != null) {
            try {
                this.mCache.remove((Object)key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearAll() {
        if (this.mCache != null) {
            try {
                this.mCache.evictAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class SingletonInstance {
        private static final DataCache mInstance = new DataCache();

        private SingletonInstance() {
        }
    }
}

