/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.action.adapter.ChatActionAdapter;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.action.recycler.HorizontalPageLayoutManager;
import com.xdja.im.lib.action.recycler.PageScrollHelper;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.lib.emoji.widget.EmotionGridView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatActionView
extends LinearLayout {
    public static final int EMOJI_UNIT_LENGTH = 11;
    private RecyclerView mActionRv;
    private ChatActionAdapter mAdapter;
    private PageScrollHelper mPageScrollHelper;
    private EmotionGridView mEmotionGv;
    private EditText mInputEdt;
    private List<OptionBean> mOptions = new ArrayList<OptionBean>();
    private List<String> mEmojis = new ArrayList<String>();
    private IChatActionItemClickListener mListener;
    private ChatActionAdapter.Callback mCallback = new ChatActionAdapter.Callback(){

        @Override
        public void onItemClickListener(int position) {
            if (ChatActionView.this.mListener == null) {
                LogUtil.e("You should set listener first!");
                return;
            }
            ChatActionView.this.mListener.onItemClick(position, (OptionBean)ChatActionView.this.mOptions.get(position));
        }
    };

    public void setChatActionItemClickListener(IChatActionItemClickListener listener) {
        this.mListener = listener;
    }

    public ChatActionView(Context context) {
        this(context, null);
    }

    public ChatActionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatActionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setOptionsData(List<OptionBean> options) {
        this.mOptions.clear();
        this.mOptions.addAll(options);
        this.mAdapter.notifyDataSetChanged();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.im_uikit_layout_chat_action, (ViewGroup)this);
        this.mActionRv = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.mEmotionGv = (EmotionGridView)this.findViewById(R.id.layout_emotion);
        this.mAdapter = new ChatActionAdapter(this.getContext(), this.mOptions, this.mCallback);
        this.mActionRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mPageScrollHelper = new PageScrollHelper();
        this.mPageScrollHelper.setUpRecycleView(this.mActionRv);
        Math.floor(this.mOptions.size() / 4);
        this.mActionRv.setLayoutManager((RecyclerView.LayoutManager)new HorizontalPageLayoutManager(2, 4));
        this.mPageScrollHelper.updateLayoutManger();
        this.setListener();
    }

    private void setListener() {
        this.mEmotionGv.setOnFaceGridViewItemClick(new EmotionGridView.OnFaceGridViewItemClick(){

            @Override
            public void onItemClick(int facesPos) {
                if (ChatActionView.this.mInputEdt == null) {
                    return;
                }
                if (ChatActionView.this.mInputEdt.getVisibility() == 0) {
                    if (ChatActionView.this.mInputEdt.getText().length() + 11 > 2048) {
                        CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                        return;
                    }
                    Editable editable = ChatActionView.this.mInputEdt.getEditableText();
                    SpannableString text = EmotionUtils.formatSpanByIndex(ChatActionView.this.getContext(), facesPos, EmotionConfig.FACE_ITEM_NORMAL_VALUE);
                    ChatActionView.this.mEmojis.add(text.toString());
                    editable.insert(ChatActionView.this.mInputEdt.getSelectionStart(), (CharSequence)text);
                }
            }

            @Override
            public void onClear() {
                if (ChatActionView.this.mInputEdt == null) {
                    return;
                }
                ChatActionView.this.deleteSpannableStr();
            }
        });
        this.mEmotionGv.setAdapter();
    }

    public void setAcceptInput(EditText edit) {
        this.mInputEdt = edit;
    }

    public void setActionViewVisible(boolean visible) {
        if (visible) {
            if (!this.isShown()) {
                this.setVisibility(0);
            }
            this.mActionRv.setVisibility(0);
            if (this.mEmotionGv.isShown()) {
                this.mEmotionGv.setVisibility(8);
            }
        } else {
            this.mActionRv.setVisibility(8);
        }
    }

    public void setEmojiVisible(boolean visible) {
        if (visible) {
            if (!this.isShown()) {
                this.setVisibility(0);
            }
            this.mEmotionGv.setVisibility(0);
            if (this.mActionRv.isShown()) {
                this.mActionRv.setVisibility(8);
            }
        } else {
            this.mEmotionGv.setVisibility(8);
        }
    }

    public boolean isActionViewVisible() {
        return this.mActionRv.isShown();
    }

    public boolean isEmojiVisible() {
        return this.mEmotionGv.isShown();
    }

    private void deleteSpannableStr() {
        String temp;
        int leftIndex;
        int cursorIndex = this.mInputEdt.getSelectionStart();
        if (cursorIndex <= 0) {
            return;
        }
        String content = this.mInputEdt.getText().toString();
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        int rightIndex = (content = content.substring(0, cursorIndex)).lastIndexOf("]");
        if (rightIndex != -1 && rightIndex == content.length() - 1 && (leftIndex = content.lastIndexOf("[")) != -1 && this.mEmojis.contains(temp = content.substring(leftIndex, rightIndex + 1)) && EmotionUtils.mathEmotion(temp)) {
            this.mInputEdt.getEditableText().delete(leftIndex, cursorIndex);
            this.mEmojis.remove(temp);
            return;
        }
        leftIndex = cursorIndex - 1;
        this.mInputEdt.getEditableText().delete(leftIndex, cursorIndex);
    }

    public void formatSpanContent(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");
            Matcher matcher = pattern.matcher(s);
            while (matcher.find()) {
                String emoStr = matcher.group(1);
                this.mEmojis.add(emoStr.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

