/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.player;

import android.media.MediaPlayer;
import android.text.TextUtils;
import com.xdja.im.lib.audio.manager.VoicePlayState;
import com.xdja.im.lib.audio.player.AudioListenerManager;
import com.xdja.im.lib.video.utils.AudioFunctions;
import com.xdja.im.uikit.action.media.MediaManger;
import com.xdja.im.uikit.utils.IoUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.FileInputStream;

public class AudioPlayerManager {
    private MediaPlayer mMediaPlayer;
    private String mCurPlayPath;
    private Object[] mArgs;
    private MediaPlayer.OnErrorListener errorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            AudioPlayerManager.this.stopToPlay(VoicePlayState.ERROR, AudioPlayerManager.this.mArgs);
            return false;
        }
    };
    private MediaPlayer.OnCompletionListener completionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            AudioPlayerManager.this.stopToPlay(VoicePlayState.COMPLETION, AudioPlayerManager.this.mArgs);
            MediaManger.getInstance().restoreAudioMode();
        }
    };

    public static AudioPlayerManager getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private AudioPlayerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startToPlay(String filePath, Object ... args) {
        AudioPlayerManager audioPlayerManager = this;
        synchronized (audioPlayerManager) {
            LogUtil.d("Start play voice " + filePath);
            if (!this.checkNullForPath(filePath)) {
                return;
            }
            if (this.mMediaPlayer != null) {
                try {
                    if (this.mMediaPlayer.isPlaying()) {
                        this.stopToPlay(VoicePlayState.STOP, this.mArgs);
                    } else {
                        this.mMediaPlayer.release();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.mMediaPlayer = null;
            }
            this.mMediaPlayer = new MediaPlayer();
            if (MediaManger.getInstance().isWakeAcquire()) {
                MediaManger.getInstance().setReceiverMode(true);
            }
            if (MediaManger.getInstance().isReceiverMode()) {
                MediaManger.getInstance().setReceiverModeOn();
                this.mMediaPlayer.setAudioStreamType(0);
            } else {
                MediaManger.getInstance().setReceiverModeOff();
                this.mMediaPlayer.setAudioStreamType(3);
            }
            this.mMediaPlayer.setOnCompletionListener(this.completionListener);
            this.mMediaPlayer.setOnErrorListener(this.errorListener);
            if (TextUtils.equals((CharSequence)this.mCurPlayPath, (CharSequence)filePath)) {
                this.stopToPlay(VoicePlayState.STOP, args);
                AudioFunctions.muteAudioFocus(false);
                return;
            }
            AudioFunctions.muteAudioFocus(true);
            FileInputStream fis = null;
            try {
                File file = new File(filePath);
                fis = new FileInputStream(file);
                this.mMediaPlayer.setDataSource(fis.getFD());
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
                this.mCurPlayPath = filePath;
                this.mArgs = args;
                AudioListenerManager.getInstance().playStateChange(this.mCurPlayPath, VoicePlayState.PLAYING, args);
            }
            catch (Exception e) {
                try {
                    LogUtil.e("ERROR:Play voice failed. " + e.getMessage());
                    this.stopToPlay(VoicePlayState.ERROR, args);
                }
                catch (Throwable throwable) {
                    IoUtils.closeIO(fis);
                    throw throwable;
                }
                IoUtils.closeIO(fis);
            }
            IoUtils.closeIO(fis);
        }
    }

    public void startToRePlay() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            int duration = this.mMediaPlayer.getCurrentPosition();
            this.startToPlay(this.mCurPlayPath, duration, this.mArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startToPlay(String filePath, int duration, Object ... args) {
        if (this.mMediaPlayer != null) {
            try {
                if (this.mMediaPlayer.isPlaying()) {
                    if (duration > 0) {
                        this.stopToPlay(VoicePlayState.ERROR, args);
                    } else {
                        this.stopToPlay(VoicePlayState.STOP, args);
                    }
                } else {
                    this.mMediaPlayer.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mMediaPlayer = null;
        }
        this.mMediaPlayer = new MediaPlayer();
        if (MediaManger.getInstance().isWakeAcquire()) {
            MediaManger.getInstance().setReceiverMode(true);
        }
        if (MediaManger.getInstance().isReceiverMode()) {
            MediaManger.getInstance().setReceiverModeOn();
            this.mMediaPlayer.setAudioStreamType(0);
        } else {
            MediaManger.getInstance().setReceiverModeOff();
            this.mMediaPlayer.setAudioStreamType(3);
        }
        this.mMediaPlayer.setOnCompletionListener(this.completionListener);
        this.mMediaPlayer.setOnErrorListener(this.errorListener);
        if (TextUtils.equals((CharSequence)this.mCurPlayPath, (CharSequence)filePath)) {
            this.stopPlay();
            AudioFunctions.muteAudioFocus(false);
            MediaManger.getInstance().restoreAudioMode();
            return;
        }
        AudioFunctions.muteAudioFocus(true);
        FileInputStream fileInputStream = null;
        try {
            File file = new File(filePath);
            fileInputStream = new FileInputStream(file);
            this.mMediaPlayer.setDataSource(fileInputStream.getFD());
            this.mMediaPlayer.prepare();
            if (duration > 0) {
                this.mMediaPlayer.seekTo(duration);
            }
            this.mMediaPlayer.start();
            this.mCurPlayPath = filePath;
            this.mArgs = args;
            AudioListenerManager.getInstance().playStateChange(this.mCurPlayPath, VoicePlayState.PLAYING, args);
            if (fileInputStream == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.stopToPlay(VoicePlayState.ERROR, args);
                MediaManger.getInstance().restoreAudioMode();
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                IoUtils.closeIO(fileInputStream);
                throw throwable;
            }
            IoUtils.closeIO(fileInputStream);
            return;
        }
        IoUtils.closeIO(fileInputStream);
        return;
    }

    private boolean checkNullForPath(String filePath) {
        if (filePath == null || TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    private synchronized void stopToPlay(VoicePlayState state, Object ... args) {
        LogUtil.d("Stop play voice " + this.mCurPlayPath);
        if (this.mMediaPlayer != null) {
            try {
                if (this.mMediaPlayer.isPlaying()) {
                    this.mMediaPlayer.stop();
                }
                this.mMediaPlayer.release();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.mMediaPlayer = null;
            AudioFunctions.muteAudioFocus(false);
        }
        this.mCurPlayPath = "";
        this.mArgs = null;
        AudioListenerManager.getInstance().playStateChange(this.mCurPlayPath, state, args);
    }

    public void stopPlay() {
        this.stopToPlay(VoicePlayState.STOP, this.mArgs);
    }

    public void releasePlayer() {
        this.stopToPlay(VoicePlayState.STOP, this.mArgs);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public String getCurrentPlayPath() {
        return this.mCurPlayPath;
    }

    public Object[] getArgs() {
        return this.mArgs;
    }

    public boolean isPlaying() {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying() && !TextUtils.isEmpty((CharSequence)this.mCurPlayPath) && this.mArgs != null && this.mArgs.length > 0;
    }

    private static class SingletonInstance {
        private static final AudioPlayerManager INSTANCE = new AudioPlayerManager();

        private SingletonInstance() {
        }
    }
}

