/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;
import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.lib.file.FileExplorerConfig;
import com.xdja.im.lib.file.FileExplorerManager;
import com.xdja.im.lib.file.bean.FileCollections;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.file.ui.adapter.FileExplorerFragmentAdapter;
import com.xdja.im.lib.file.ui.fragment.FileListFragment;
import com.xdja.im.lib.file.ui.presenter.FileExplorerPresenter;
import com.xdja.im.lib.file.ui.view.ViewFileExplorer;
import com.xdja.im.lib.file.ui.view.vu.FileExplorerVu;
import com.xdja.im.lib.file.utils.FileConstant;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class FileExplorerActivity
extends ImBaseActivity<FileExplorerPresenter, FileExplorerVu>
implements FileExplorerPresenter {
    private Integer[] parentTabTitles = new Integer[]{R.string.im_uikit_lately_file, R.string.im_uikit_local_file};
    private FileExplorerConfig config;
    private FileExplorerFragmentAdapter adapter;

    @Override
    @NonNull
    protected Class<? extends FileExplorerVu> getVuClass() {
        return ViewFileExplorer.class;
    }

    @Override
    @NonNull
    protected FileExplorerPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        BusProvider.getInstance().register(this);
        this.config = FileExplorerManager.getInstance().getConfig();
        FileCollections.getInstance().clearCache();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        Bundle bundleRec = new Bundle();
        bundleRec.putInt("tab_type", FileListType.RECENT.getType());
        fragments.add(FileListFragment.newInstance(bundleRec));
        Bundle bundleLocal = new Bundle();
        bundleLocal.putInt("tab_type", FileListType.LOCAL.getType());
        fragments.add(FileListFragment.newInstance(bundleLocal));
        this.adapter = this.buildAdapter(this.parentTabTitles, fragments);
        ((FileExplorerVu)this.getVu()).setAdapter(this.adapter);
        ((FileExplorerVu)this.getVu()).setCurrentSelectedFileSize((Context)this, 0L);
    }

    protected void onResume() {
        super.onResume();
        this.requestPermission();
    }

    private void requestPermission() {
        if (!PermissionUtils.hasSelfPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            PermissionUtils.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.adapter.notifyDataSetChanged();
            } else {
                this.showToast(R.string.im_uikit_storage_deny);
            }
        }
    }

    private FileExplorerFragmentAdapter buildAdapter(final Integer[] titles, List<Fragment> fragments) {
        return new FileExplorerFragmentAdapter<Integer>(this.getSupportFragmentManager(), (Context)this, titles, fragments){

            public CharSequence getPageTitle(int position) {
                return this.context.getString(titles[position].intValue());
            }
        };
    }

    @Override
    public void onSendBtnClick(View view) {
        ((FileExplorerVu)this.getVu()).setProgressBarVisibility(0);
        Observable.from(FileCollections.getInstance().getAllSelectFiles()).subscribeOn(Schedulers.immediate()).flatMap((Func1)new Func1<FileItem, Observable<FileItem>>(){

            public Observable<FileItem> call(FileItem localFileInfo) {
                long fileSize = localFileInfo.getFileSize();
                if (fileSize < 0L) {
                    CommonTool.showToast(R.string.im_uikit_file_error);
                    return Observable.error((Throwable)new IllegalArgumentException("file error! fileSize " + fileSize));
                }
                if (fileSize > FileConstant.MAX_FILE_SIZE) {
                    CommonTool.showToast(String.format(FileExplorerActivity.this.getString(R.string.im_uikit_selec_file_too_large), FileSizeUtils.formatFileSize(FileConstant.MAX_FILE_SIZE, 3)));
                    return Observable.error((Throwable)new Exception("File is too larger!"));
                }
                return Observable.just((Object)localFileInfo);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<FileItem>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ((FileExplorerVu)FileExplorerActivity.this.getVu()).setProgressBarVisibility(8);
            }

            public void onNext(FileItem localFileInfo) {
                ((FileExplorerVu)FileExplorerActivity.this.getVu()).setProgressBarVisibility(8);
                FileExplorerActivity.this.checkNetStatue();
            }
        });
    }

    private void checkNetStatue() {
        this.checkNetType(new ImBaseActivity.OnNetCheckCallback(){

            @Override
            public void onResult(boolean isCanceled) {
                if (isCanceled) {
                    LogUtil.d("Has canceled send files.");
                    return;
                }
                FileExplorerActivity.this.setResult();
            }

            @Override
            protected String getContent() {
                return String.format(FileExplorerActivity.this.getString(R.string.im_uikit_mobile_data_hint_contnet), FileExplorerActivity.this.getString(R.string.im_uikit_send));
            }
        });
    }

    private void setResult() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        ArrayList<FileItem> bundleList = new ArrayList<FileItem>();
        bundleList.addAll(FileCollections.getInstance().getAllSelectFiles());
        bundle.putParcelableArrayList("file_select", bundleList);
        intent.putExtras(bundle);
        this.setResult(6, intent);
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileCollections.getInstance().clearCache();
        Glide.get((Context)this).clearMemory();
    }

    @Subscribe
    public void onRefreashFileSelectStatus(IMProxyEvent.FileSelectedEvent event) {
        ((FileExplorerVu)this.getVu()).setCurrentSelectedFileSize((Context)this, FileCollections.getInstance().getSelectedFileSize());
        ((FileExplorerVu)this.getVu()).setCurrentSelectedFileCount((Context)this, FileCollections.getInstance().getSelectedFileCount());
    }
}

