/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.BaseFileListAdapter;
import com.xdja.im.lib.filemanage.adapter.FileListViewHolder;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.List;

public class FileListAdapter
extends BaseFileListAdapter<FileListViewHolder> {
    private Context mContext;
    private List<List<FileItem>> mLocalFiles = new ArrayList<List<FileItem>>();

    public FileListAdapter(Context context, List<String> groupTitles) {
        super(groupTitles);
        this.mContext = context;
    }

    public void addLocalFiles(List<List<FileItem>> localFiles) {
        this.mLocalFiles = localFiles;
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        return this.mLocalFiles == null ? 0 : this.mLocalFiles.get(groupPosition).size();
    }

    @Override
    public Object getChild(int groupPosition, int childPosition) {
        List<FileItem> fileInfos = this.mLocalFiles.get(groupPosition);
        if (fileInfos != null) {
            return fileInfos.get(childPosition);
        }
        return null;
    }

    @Override
    public FileListViewHolder onCreateChildViewHolder(ViewGroup parent, int viewType) {
        View convertView = viewType == 0 ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_uikit_filelist_item_vertical, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_uikit_filelist_item_grid, parent, false);
        return new FileListViewHolder(this.mContext, convertView);
    }

    @Override
    public void onBindChildViewHolder(FileListViewHolder holder, int groupPosition, int childPosition) {
        FileItem fileInfo = (FileItem)this.getChild(groupPosition, childPosition);
        if (fileInfo != null) {
            holder.bindData(fileInfo);
        }
    }
}

