/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.error;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.lib.filemanage.error.OkException;
import com.xdja.im.lib.filemanage.error.OkNetMatcher;
import com.xdja.im.lib.filemanage.model.RespErrorBean;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.R;

public class OkNetException
extends OkException {
    public static final String UNKNOW_HTTP_CODE = "unknowCode";
    public static final String UNKNOW_HTTP_MSG = ActomaController.getAppConfigContext().getString(R.string.im_uikit_im_unknow_http_error);
    public static final int HTTP_400_ERROR_CODE = 400;
    public static final int HTTP_401_ERROR_CODE = 401;
    public static final int HTTP_500_ERROR_CODE = 500;
    private int statueCode;

    @Nullable
    public static <R> OkNetException buildException(@Nullable R source) {
        if (source == null) {
            return null;
        }
        if (source instanceof RespErrorBean) {
            OkNetException exception;
            RespErrorBean respErrorBean = (RespErrorBean)source;
            if (TextUtils.isEmpty((CharSequence)respErrorBean.getErrCode())) {
                exception = OkNetException.buildDefaultException();
            } else {
                exception = new OkNetException();
                exception.setOkCode(respErrorBean.getErrCode());
                exception.setOkMessage(respErrorBean.getMessage());
                exception.setStatueCode(respErrorBean.getStatueCode());
            }
            return exception;
        }
        return null;
    }

    public static OkNetException buildDefaultException() {
        OkNetException exception = new OkNetException();
        exception.setOkCode(UNKNOW_HTTP_CODE);
        exception.setOkMessage(UNKNOW_HTTP_MSG);
        return exception;
    }

    public int getStatueCode() {
        return this.statueCode;
    }

    public void setStatueCode(int statueCode) {
        this.statueCode = statueCode;
    }

    public OkNetException() {
        super(new OkNetMatcher());
    }

    public OkNetException(String okCode, String okMessage) {
        super(new OkNetMatcher(), okCode, okMessage);
    }
}

