/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private static String serverTime;
    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap;
    private static final String YMDHM = "yyyy-MM-dd HH:mm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SimpleDateFormat getFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread != null) return formatThread.get();
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            formatThread = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(pattern);
                }
            };
            sdfMap.put(pattern, formatThread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return formatThread.get();
        }
    }

    @SuppressLint(value={"ConstantConditions"})
    public static String displayTime(Context context, long timestamp) {
        SimpleDateFormat yh = DateUtils.getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_year_month_day));
        SimpleDateFormat mh = DateUtils.getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_day));
        SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
        long currentSeconds = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentSeconds);
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int currentDay = cal.get(5);
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(1);
        int lastMonth = cal.get(2);
        int lastDay = cal.get(5);
        String timeStr = currentYear == lastYear ? (currentMonth == lastMonth && currentDay == lastDay ? context.getResources().getString(R.string.im_uikit_today) + "   " + hm.format(timestamp) : (currentMonth == lastMonth && currentDay - lastDay == 1 ? context.getResources().getString(R.string.im_uikit_yesterday) + "   " + hm.format(timestamp) : mh.format(timestamp) + "   " + hm.format(timestamp))) : yh.format(timestamp) + "   " + hm.format(timestamp);
        return timeStr;
    }

    public static String chatListDisplayTime(Context context, long timestamp) {
        SimpleDateFormat yh = new SimpleDateFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_year_month_day));
        SimpleDateFormat mh = new SimpleDateFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_day));
        SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
        long currentSeconds = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentSeconds);
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int currentDay = cal.get(5);
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(1);
        int lastMonth = cal.get(2);
        int lastDay = cal.get(5);
        String timeStr = currentYear == lastYear ? (currentMonth == lastMonth && currentDay == lastDay ? hm.format(timestamp) : (currentMonth == lastMonth && currentDay - lastDay == 1 ? context.getResources().getString(R.string.im_uikit_yesterday) : mh.format(timestamp))) : yh.format(timestamp);
        return timeStr;
    }

    public static String convertFileModifyDate(long timestamp) {
        if (timestamp == 0L) {
            return "";
        }
        return DateUtils.getFormat(YMDHM).format(timestamp);
    }

    public static String displayShowTime(Context context, long timestamp) {
        SimpleDateFormat yh = DateUtils.getFormat(context.getString(R.string.im_uikit_file_show_time));
        SimpleDateFormat hm = DateUtils.getFormat("HH:mm");
        return yh.format(timestamp) + "   " + hm.format(timestamp);
    }

    public static boolean isOverdue(long time) {
        long currTime = DateUtils.obtainCurrentTime();
        long result = currTime - time;
        if (result < 0L) {
            return true;
        }
        return result > 604800000L;
    }

    public static void setServerTime(String time) {
        serverTime = time;
    }

    public static long obtainCurrentTime() {
        long mServerTime;
        try {
            mServerTime = Long.parseLong(serverTime);
        }
        catch (Exception e) {
            mServerTime = 0L;
        }
        if (mServerTime != 0L) {
            return (SystemClock.elapsedRealtimeNanos() + mServerTime) / 1000000L;
        }
        return System.currentTimeMillis();
    }

    public static String stringOfOverdue(Context context, long time) {
        SimpleDateFormat yh = DateUtils.getFormat(context.getString(R.string.im_uikit_file_show_time));
        if (!DateUtils.isOverdue(time)) {
            long overdueTime = time + 604800000L;
            return yh.format(overdueTime);
        }
        return "";
    }

    public static String getCategoryIdWithTime(long time) {
        SimpleDateFormat format = DateUtils.getFormat("yyyyMM");
        return format.format(time);
    }

    static {
        sdfMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    }
}

