/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.view;

import android.app.Activity;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.commend.ILastPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ViewLastBaseItem;
import com.xdja.im.uikit.R;

public class ViewLastPhotoItem
extends ViewLastBaseItem {
    private ImageView imageView;
    private CheckBox isSelected;
    private int style;
    private SharedPreferences sp;
    private SharedPreferences.Editor edit;
    private static String PHOTO_ITEM_SELECT_SP = "view_last_photo_item";

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.style = UniversalUtil.getThemeStyle(this.getContext());
        if (view != null) {
            this.imageView = (ImageView)view.findViewById(R.id.image_file_image);
            this.isSelected = (CheckBox)view.findViewById(R.id.chx_img_file_select);
        }
        this.sp = this.getActivity().getSharedPreferences(PHOTO_ITEM_SELECT_SP, 0);
        this.edit = this.sp.edit();
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean)dataSource.getValue();
        final FileInfo fileInfo = dataTalk.getFileInfo();
        this.isSelected.setVisibility(0);
        this.isSelected.setChecked(dataTalk.isChecked());
        this.isSelected.setClickable(false);
        this.isSelected.setButtonDrawable(dataTalk.isChecked() ? (this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
        this.isSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ViewLastPhotoItem.this.sp == null) {
                    return;
                }
                boolean isCurSelected = ViewLastPhotoItem.this.sp.getBoolean(String.valueOf(dataTalk.getId()), false);
                isCurSelected = !isCurSelected;
                dataTalk.setChecked(isCurSelected);
                ViewLastPhotoItem.this.edit.putBoolean(String.valueOf(dataTalk.getId()), isCurSelected);
                ViewLastPhotoItem.this.edit.commit();
                ViewLastPhotoItem.this.isSelected.setButtonDrawable(isCurSelected ? (ViewLastPhotoItem.this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
                String fileName = fileInfo.getFileName();
                if (TextUtils.isEmpty((CharSequence)ToolUtil.getLastString(fileName, "."))) {
                    fileName = fileName + "." + fileInfo.getSuffix();
                }
                String filePath = fileInfo.getFilePath();
                long fileSize = fileInfo.getFileSize();
                FileItem localFileInfo = new FileItem(fileName, filePath, fileSize, 0L, fileInfo.getFileType());
                if (isCurSelected) {
                    FileInfoCollection.getInstance().putFileToSelectedCache(filePath + dataTalk.getId(), localFileInfo);
                } else {
                    FileInfoCollection.getInstance().removeToSelectedCache(filePath + dataTalk.getId());
                }
                ((ILastPhotoAndVideoAdapterCommand)ViewLastPhotoItem.this.getCommand()).toRefreshSelectHint(localFileInfo);
            }
        });
        Glide.with((Activity)this.getActivity()).load(fileInfo.getFilePath()).error(R.drawable.im_uikit_ic_jpg).centerCrop().override(240, 240).into(this.imageView);
    }
}

