/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ExpandableListView;
import android.widget.ProgressBar;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.BaseFileItemAdapterPresenter;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewHistoryFileTitle;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.ViewHistoryFileContent;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Subscriber;

public class HistoryFileAdapterPresenter
extends BaseFileItemAdapterPresenter<IHistoryFileListAdapterCommand, TalkMessageBean>
implements IHistoryFileListAdapterCommand {
    private ExpandableListView listView;
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    BusProvider busProvider;
    private Activity mActivity;
    private final UserCache userCache;
    private int mCurrentOperate;
    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> mGroupVuClass = null;
    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> mVuClass = null;
    private ItemLongClickListener mItemLongClickListener;

    public HistoryFileAdapterPresenter(Context context, BusProvider busProvider, Map<HistoryFileCategory, List<TalkMessageBean>> datas, UserCache userCache) {
        this.mContext = context;
        this.mDatas = datas;
        this.busProvider = busProvider;
        this.userCache = userCache;
        this.busProvider.register(this);
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> getVuClasses() {
        if (this.mVuClass == null) {
            this.mVuClass = new ArrayList<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>>();
            this.mVuClass.add(ViewHistoryFileContent.class);
        }
        return this.mVuClass;
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> getGroupVuClasses() {
        if (this.mGroupVuClass == null) {
            this.mGroupVuClass = new ArrayList<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>>();
            this.mGroupVuClass.add(ViewHistoryFileTitle.class);
        }
        return this.mGroupVuClass;
    }

    @Override
    public IHistoryFileListAdapterCommand getCommand() {
        return this;
    }

    public void notifyDataSetChanged() {
        this.mTitles = new ArrayList(this.mDatas.keySet());
        super.notifyDataSetChanged();
    }

    @Override
    public void sendReadReceipt(final TalkMessageBean talkMessageBean) {
        ((ProxyRepository)this.proxyRepository.get()).changeMessageState(talkMessageBean, 4, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "\u6d88\u606f\u5df2\u8bfb\u72b6\u6001\u66f4\u6539\u6210\u529f");
                    for (Map.Entry entry : HistoryFileAdapterPresenter.this.mDatas.entrySet()) {
                        for (TalkMessageBean bean : (List)entry.getValue()) {
                            if (bean.getId() != talkMessageBean.getId()) continue;
                            bean.setMessageState(4);
                            HistoryFileAdapterPresenter.this.notifyDataSetChanged();
                        }
                    }
                } else {
                    LogUtil.d("", "\u6d88\u606f\u5df2\u8bfb\u72b6\u6001\u66f4\u6539\u5931\u8d25");
                }
            }
        });
    }

    public void updateMode(int operateAction) {
        this.mCurrentOperate = operateAction;
        Iterator iterator = this.mDatas.keySet().iterator();
        while (iterator.hasNext()) {
            HistoryFileCategory historyFileCategory = (HistoryFileCategory)iterator.next();
            List talkMessageBeanList = (List)this.mDatas.get(historyFileCategory);
            Iterator it = talkMessageBeanList.iterator();
            while (it.hasNext()) {
                TalkMessageBean bean = (TalkMessageBean)it.next();
                if (this.mCurrentOperate == 2) {
                    if (bean.getFileInfo().getFileState() == 5 || bean.getFileInfo().getFileState() == 1 || bean.getFileInfo().getFileState() == 4 || bean.getFileInfo().getFileState() == 3) {
                        it.remove();
                        continue;
                    }
                } else if (this.mCurrentOperate == 1 && (bean.getFileInfo().getFileState() != 5 && bean.getFileInfo().getFileState() != 1 && bean.getFileInfo().getFileState() != 4 && bean.getFileInfo().getFileState() != 3 || DateUtils.isOverdue(bean.getShowTime()))) {
                    it.remove();
                    continue;
                }
                bean.setFileOperate(this.mCurrentOperate);
                if (this.mCurrentOperate == 0) continue;
                bean.setChecked(false);
            }
            if (!talkMessageBeanList.isEmpty()) continue;
            iterator.remove();
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void clickToDownloadOfOpen(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();
        boolean isExist = HistoryFileUtils.isFileExist(bean);
        if (!isExist && DateUtils.isOverdue(bean.getShowTime())) {
            new XToast((Context)this.getActivity()).display(this.getActivity().getString(R.string.im_uikit_history_select_all_overdue));
            return;
        }
        int state = fileInfo.getFileState();
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        fileInfos.add(fileInfo);
        if (state == 4) {
            ((ProxyRepository)this.proxyRepository.get()).pauseFileReceiving(fileInfo, new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("", "zhu->\u6682\u505c\u4e0b\u8f7d\u6587\u4ef6");
                    }
                }
            });
        } else if (state == 3 || state == 5) {
            this.showDialog(fileInfos);
        } else if (isExist) {
            HistoryFileUtils.intentBuilder(this.getActivity(), bean.getFileInfo().getFilePath(), bean.getFileInfo().getSuffix());
        } else {
            new XToast((Context)this.getActivity()).display(this.getActivity().getString(R.string.im_uikit_history_send_file_not_exist));
        }
    }

    public void showDialog(final List<FileInfo> fileInfos) {
        int networkType = NetworkUtils.obtainCurrentNetworkState((Context)this.mActivity);
        if (networkType == NetworkUtils.WIFI) {
            this.resumeOrDownloadFiles(fileInfos);
        } else if (networkType == NetworkUtils.MOBILE_NETWORK) {
            CustomDialog dialog = new CustomDialog((Context)this.mActivity, new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    if (confirm) {
                        HistoryFileAdapterPresenter.this.resumeOrDownloadFiles(fileInfos);
                    } else if (fileInfos.size() == 1) {
                        FileInfo fileInfo = (FileInfo)fileInfos.get(0);
                        long msgId = fileInfo.getTalkMessageId();
                        if (fileInfo.getTranslatePercent() > 0) {
                            fileInfo.setFileState(4);
                        } else {
                            fileInfo.setFileState(1);
                        }
                        HistoryFileAdapterPresenter.this.updateOneItem(msgId);
                    }
                }
            });
            dialog.setDialogTitle(R.string.im_uikit_download_file_title).setDialogContent(R.string.im_uikit_download_file_net_type).setPositiveButton(this.mActivity.getString(R.string.im_uikit_download_file_btn_continue)).setNegativeButton(this.mActivity.getString(R.string.im_uikit_download_file_btn_cancel)).show();
        }
    }

    private void resumeOrDownloadFiles(List<FileInfo> fileInfos) {
        if (fileInfos.get(0).getTranslatePercent() == 0) {
            ((ProxyRepository)this.proxyRepository.get()).downloadFile(fileInfos, new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("", "zhu->\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
                    }
                }
            });
        } else {
            ((ProxyRepository)this.proxyRepository.get()).resumeFileReceive(fileInfos.get(0), new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("", "zhu->\u6062\u590d\u4e0b\u8f7d\u6587\u4ef6");
                    }
                }
            });
        }
    }

    public void refreshItem(long msgId) {
        this.updateItem(this.getCategoryPosition(msgId), msgId);
    }

    private int getCategoryPosition(long msgId) {
        TalkMessageBean msgBean = this.getTalkMessageBean(msgId);
        int groupPosition = -1;
        if (msgBean != null) {
            String categoryId = msgBean.getCategoryId();
            HistoryFileCategory category = new HistoryFileCategory();
            category.setCategoryId(categoryId);
            groupPosition = this.mTitles.indexOf(category);
        }
        return groupPosition;
    }

    private TalkMessageBean getTalkMessageBean(long msgId) {
        TalkMessageBean msgBean = null;
        for (Map.Entry entry : this.mDatas.entrySet()) {
            for (TalkMessageBean bean : (List)entry.getValue()) {
                if (msgId != bean.getId()) continue;
                msgBean = bean;
            }
        }
        return msgBean;
    }

    public void updateOneItem(long msgId) {
        int position = this.getCategoryPosition(msgId);
        HistoryFileCategory cate = (HistoryFileCategory)this.mTitles.get(position);
        List beans = (List)this.mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);
        int childPosition = beans.indexOf(tBean);
        if (childPosition > -1 && position == 0 && this.listView.isGroupExpanded(0)) {
            int firstVisiblePos = this.listView.getFirstVisiblePosition();
            if (childPosition + 1 < firstVisiblePos) {
                return;
            }
            int aPos = childPosition - firstVisiblePos + 1;
            LogUtil.d("", "zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos);
            View childView = this.listView.getChildAt(aPos);
            if (childView != null) {
                AdapterVu tag = (AdapterVu)childView.getTag();
                tag.bindDataSource(position, beans.get(childPosition));
            }
        }
    }

    @Override
    public void updateItem(int position, long msgId) {
        if (position < 0) {
            return;
        }
        HistoryFileCategory cate = (HistoryFileCategory)this.mTitles.get(position);
        List beans = (List)this.mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);
        int childPosition = beans.indexOf(tBean);
        if (childPosition > -1) {
            int childCount = this.listView.getChildCount();
            if (position == 0 && this.listView.isGroupExpanded(0)) {
                int firstVisiblePos = this.listView.getFirstVisiblePosition();
                if (childPosition + 1 < firstVisiblePos) {
                    return;
                }
                int aPos = childPosition - firstVisiblePos + 1;
                LogUtil.d("", "zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos);
                View childView = this.listView.getChildAt(aPos);
                if (childView != null) {
                    ProgressBar pb = (ProgressBar)childView.findViewById(R.id.pb_file_download);
                    View mFileDateLayout = childView.findViewById(R.id.layout_history_date_from);
                    pb.setVisibility(0);
                    mFileDateLayout.setVisibility(8);
                    pb.setProgress(((TalkMessageBean)beans.get(childPosition)).getFileInfo().getTranslatePercent());
                }
            }
        }
    }

    @Override
    public void toRefreshSelectHint() {
        IMProxyMessageEvent.HistoryRefreshSelectHintEvent event = new IMProxyMessageEvent.HistoryRefreshSelectHintEvent();
        this.busProvider.post(event);
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {
    }

    @Override
    public void onClickItem(View v, int groupPosition, TalkMessageBean bean) {
        if (bean.hasFileOperate()) {
            CheckBox checkBox = (CheckBox)v.getTag(R.id.history_file_select);
            if (checkBox == null) {
                return;
            }
            if (HistoryModeUtils.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked() && this.mCurrentOperate != 3) {
                new XToast(this.mContext).display(String.format(this.mContext.getString(R.string.im_uikit_select_file_hint), 9));
                return;
            }
            checkBox.setChecked(!checkBox.isChecked());
        } else {
            this.clickToDownloadOfOpen(bean);
        }
    }

    @Override
    public void longClickOnItem(int groupPosition, TalkMessageBean bean) {
        if (this.mItemLongClickListener != null) {
            this.mItemLongClickListener.itemLongClick(groupPosition, bean);
        }
    }

    public void setListView(ExpandableListView listView) {
        this.listView = listView;
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public Activity getActivity() {
        return this.mActivity;
    }

    public void setItemLongClickListener(ItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public void onDestroy() {
        if (null != this.busProvider) {
            this.busProvider.unregister(this);
        }
        HistoryModeUtils.getInstance().clearCache();
    }

    public static interface ItemLongClickListener {
        public void itemLongClick(int var1, TalkMessageBean var2);
    }
}

