/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.filemanage.commend.IPhotoAndVideoCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.IPhotoAndVideoFragmentVu;
import com.xdja.im.lib.filemanage.view.ViewPhotoAndVideo;
import com.xdja.im.lib.historyfile.adapter.HistoryPhotoAndVideoAdapter;
import com.xdja.im.lib.historyfile.util.DataSourceFilter;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class HistoryPhotoAndVideoFragment
extends IMFragmentPresenter<IPhotoAndVideoCommand, IPhotoAndVideoFragmentVu>
implements IPhotoAndVideoCommand {
    private String flag;
    BusProvider busProvider;
    private HistoryPhotoAndVideoAdapter adapter;
    private List<GridItemBean> dataSource;

    public void setDatas(List<GridItemBean> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.useCaseComponent) {
            LogUtil.e("HistoryPhotoAndVideoFragment", "useCaseComponent is null");
            return;
        }
        this.useCaseComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.flag = bundle.getString("talkId");
        }
        this.adapter = new HistoryPhotoAndVideoAdapter(this.flag, this.busProvider, this.dataSource);
        this.useCaseComponent.inject(this.adapter);
        this.adapter.setActivity((Activity)this.getActivity());
        this.adapter.setRecyclerView(((IPhotoAndVideoFragmentVu)this.getVu()).getRecyclerView());
        this.adapter.setLayoutManager(4);
        ((IPhotoAndVideoFragmentVu)this.getVu()).setRecyclerViewAdapter(this.adapter);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
    }

    public void notifyDataChange() {
        ((IPhotoAndVideoFragmentVu)this.getVu()).showEmpty(this.dataSource.size() == 0);
        this.adapter.notifyDataSetChanged();
    }

    public void updateUIAfterDeleteFiles(List<TalkMessageBean> deleteBeans) {
        for (TalkMessageBean bean : deleteBeans) {
            this.adapter.randomRemoveLeafItem(bean.getId());
        }
        ((IPhotoAndVideoFragmentVu)this.getVu()).showEmpty(this.dataSource.size() == 0);
    }

    @Subscribe
    public void receiveFilePaused(IMProxyFileEvent.ReceiveFilePausedEvent event) {
        TalkMessageBean bean = DataSourceFilter.getTalkMessageBeanWithId(this.dataSource, event.getAttachedMsgId());
        FileInfo fileInfo = event.getFileInfo();
        LogUtil.d("", "HistoryFile paused:" + fileInfo.getTranslatePercent());
        if (bean != null) {
            bean.getFileInfo().setFileState(4);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void receiveFileFinishedEvent(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        TalkMessageBean bean = DataSourceFilter.getTalkMessageBeanWithId(this.dataSource, event.getAttachedMsgId());
        if (bean != null && event.getFileInfo() != null) {
            FileInfo fileInfo = bean.getFileInfo();
            fileInfo.setFileState(2);
            if (fileInfo instanceof VideoFileInfo) {
                ((VideoFileInfo)fileInfo).getRawFileInfo().setFileState(2);
            } else if (fileInfo instanceof ImageFileInfo) {
                int type = ((ImageFileInfo)event.getFileInfo()).getType();
                if (type == 3) {
                    ((ImageFileInfo)fileInfo).getRawFileInfo().setFileState(2);
                } else if (type == 1) {
                    ((ImageFileInfo)fileInfo).getGifFileInfo().setFileState(2);
                }
            }
            int leafPosition = this.adapter.getLeafPosition(bean.getId());
            if (leafPosition > -1) {
                this.adapter.notifyItemRangeChanged(leafPosition, 1);
            }
            this.userCache.removeProgress(bean.getId());
        }
    }

    @Subscribe
    public void onRefreshSingleMessage(IMProxyMessageEvent.RefreshMessageEvent event) {
        LogUtil.d("historyFileList", "Receiver:RefreshSingleMessageEvent");
        if (event == null) {
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean.getMessageState() == 5 || bean.getMessageState() == 6) {
            ArrayList<TalkMessageBean> msgBeans = new ArrayList<TalkMessageBean>();
            msgBeans.add(bean);
            this.updateUIAfterDeleteFiles(msgBeans);
        }
    }

    @Subscribe
    public void onRefreshRecallMessage(IMProxyMessageEvent.RecallMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean.getMessageState() == 7) {
            ArrayList<TalkMessageBean> msgBeans = new ArrayList<TalkMessageBean>();
            msgBeans.add(bean);
            this.updateUIAfterDeleteFiles(msgBeans);
        }
    }

    @Subscribe
    public void onDeleteMessage(IMProxyMessageEvent.DeleteMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            LogUtil.e("", "event is null.");
            return;
        }
        TalkMessageBean delBean = event.getTalkMessageBean();
        ArrayList<TalkMessageBean> deleteBeans = new ArrayList<TalkMessageBean>();
        deleteBeans.add(delBean);
        this.updateUIAfterDeleteFiles(deleteBeans);
    }

    @Override
    @NonNull
    protected Class<? extends IPhotoAndVideoFragmentVu> getVuClass() {
        return ViewPhotoAndVideo.class;
    }

    @Override
    @NonNull
    protected IPhotoAndVideoCommand getCommand() {
        return this;
    }

    public void updateMode(int operateAction) {
        this.adapter.updateMode(operateAction);
        ((IPhotoAndVideoFragmentVu)this.getVu()).showEmpty(this.dataSource.size() == 0);
    }
}

