/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.util;

import android.support.annotation.Nullable;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.util.HmacSHA1Util;
import java.io.File;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public final class FilesController {
    private static final int MAX_FILE_NAME_LENGTH = 128;

    private FilesController() {
    }

    public static final synchronized FilesController getInstance() {
        return FilesControllerHolder.sInstance;
    }

    @Nullable
    public static String getSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index);
    }

    public String[] requestSign(UserCache userCache, String type, String fileId) throws JSONException, IOException {
        String url = userCache.get().getFastDfsAddr();
        if (!url.endsWith("/")) {
            url = url + File.separator;
        }
        Request request = new Request.Builder().url(url + "time").build();
        Response response = ImUiKit.getInstance().getComponent().okHttpsClient().newCall(request).execute();
        String[] signResults = null;
        if (response.isSuccessful()) {
            signResults = new String[3];
            try {
                String sign;
                long timestramp = 0L;
                String result = response.body().string();
                LogUtil.d("result:  " + result);
                JSONObject jsonObject = new JSONObject(result);
                if (jsonObject.has("timestamp")) {
                    timestramp = jsonObject.getLong("timestamp");
                }
                timestramp += 1200000L;
                String data = "";
                if (type.equals("4")) {
                    data = userCache.get().getFastUserId() + timestramp;
                } else if (type.equals("5")) {
                    data = "/info/" + fileId + timestramp;
                } else if (type.equals("6")) {
                    data = fileId + timestramp;
                } else if (type.equals("9")) {
                    data = "/delete/" + fileId + timestramp;
                }
                signResults[0] = sign = HmacSHA1Util.hamcsha1((String)data, (String)userCache.get().getFastUserSecret());
                signResults[1] = String.valueOf(timestramp);
                signResults[2] = userCache.get().getFastUserId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return signResults;
    }

    private static class FilesControllerHolder {
        private static FilesController sInstance = new FilesController();

        private FilesControllerHolder() {
        }
    }
}

