/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.vu;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.historyfile.command.IHistoryPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.ViewHistoryBaseItem;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewHistoryVideoItem
extends ViewHistoryBaseItem {
    private CheckBox isSelect;
    private ImageView imgView;
    private TextView videoTime;
    private ImageView playerBtn;
    private CircleProgressBar circleProgressBar;
    private TextView videoShade;
    private int style = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.style = UniversalUtil.getThemeStyle(this.getContext());
        if (view != null) {
            this.isSelect = (CheckBox)view.findViewById(R.id.chx_video_file_select);
            this.imgView = (ImageView)view.findViewById(R.id.history_file_video_img);
            this.videoTime = (TextView)view.findViewById(R.id.history_file_video_time);
            this.playerBtn = (ImageView)view.findViewById(R.id.history_file_video_btn_player);
            this.circleProgressBar = (CircleProgressBar)view.findViewById(R.id.video_down_cpb);
            this.videoShade = (TextView)view.findViewById(R.id.video_file_shade);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean)dataSource.getValue();
        this.circleProgressBar.setMax(100);
        if (dataTalk.getFileInfo().getFileState() == 3) {
            this.playerBtn.setVisibility(8);
            this.circleProgressBar.setVisibility(0);
        } else {
            this.playerBtn.setVisibility(0);
            this.circleProgressBar.setVisibility(8);
        }
        if (!HistoryFileUtils.isFileExist(dataTalk) && DateUtils.isOverdue(dataTalk.getShowTime())) {
            this.videoShade.setVisibility(0);
        } else {
            this.videoShade.setVisibility(8);
        }
        if (HistoryFileUtils.isSendReadReceipt(dataTalk)) {
            ((IHistoryPhotoAndVideoAdapterCommand)this.getCommand()).sendReadReceipt(dataTalk);
        }
        this.isSelect.setVisibility(dataTalk.hasFileOperate() ? 0 : 8);
        this.isSelect.setClickable(false);
        this.isSelect.setButtonDrawable(dataTalk.isChecked() ? (this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
        this.isSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);
                ViewHistoryVideoItem.this.isSelect.setButtonDrawable(isChecked ? (ViewHistoryVideoItem.this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
                if (isChecked) {
                    HistoryModeUtils.getInstance().putFileToSelectedCache(dataTalk.getId(), dataTalk);
                } else {
                    HistoryModeUtils.getInstance().removeToSelectedCache(dataTalk.getId());
                }
                ((IHistoryPhotoAndVideoAdapterCommand)ViewHistoryVideoItem.this.getCommand()).toRefreshSelectHint();
            }
        });
        this.isSelect.setChecked(dataTalk.isChecked());
        FileInfo videoFileInfo = dataTalk.getFileInfo();
        if (videoFileInfo != null) {
            if (HistoryFileUtils.isFileExist(videoFileInfo.getFilePath())) {
                this.loadImage(videoFileInfo.getFilePath());
            }
            this.videoTime.setText((CharSequence)UnitUtil.getVideoDuration(IMFileUtils.getVideoDuration(videoFileInfo.getFilePath()) / 1000));
        }
    }

    private void loadImage(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            this.imgView.setImageResource(R.drawable.im_uikit_pic_failed);
        } else if (IMFileUtils.isVideoFileType(filePath)) {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(filePath);
            Bitmap bitmap = mmr.getFrameAtTime();
            this.imgView.setImageBitmap(BitmapUtils.getZoomedBitMap(bitmap, 1));
            mmr.release();
        } else {
            this.imgView.setImageBitmap(BitmapUtils.getZoomedDrawable(filePath, 1));
        }
    }
}

