/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.ShareInfo;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.share.ShareSessionListActivity;
import com.xdja.im.lib.share.model.HyperLinkBean;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.util.HyperLinkUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ShareUtils {
    public static ShareInfo getShareInfo(Intent intent) {
        String mText = ShareUtils.getText(intent);
        String mUrl = ShareUtils.getLegalWebUrl(intent);
        String mUri = ShareUtils.getLegalFileUri(intent);
        String mTitle = ShareUtils.getTitle(intent);
        String mSource = ShareUtils.getSource(intent);
        boolean isText = false;
        String model = Build.MODEL;
        if (TextUtils.equals((CharSequence)"ACTOMA ACE", (CharSequence)model)) {
            isText = intent.getBooleanExtra("isText", false) || TextUtils.isEmpty((CharSequence)mUri) && "Contact".equalsIgnoreCase(intent.getStringExtra("android.intent.extra.SUBJECT"));
        } else {
            String mType = intent.getType();
            isText = intent.getBooleanExtra("isText", false) || TextUtils.isEmpty((CharSequence)mUri) && TextUtils.equals((CharSequence)mType, (CharSequence)"text/plain");
        }
        return new ShareInfo(mTitle, mText, mUrl, mUri, mSource, isText);
    }

    private static String getSource(Intent intent) {
        String isUCM = intent.getStringExtra("isUCM");
        if (TextUtils.equals((CharSequence)isUCM, (CharSequence)"true")) {
            return ShareUtils.transformSource("isUCM");
        }
        return null;
    }

    private static String getText(Intent intent) {
        if (intent == null) {
            return null;
        }
        String text = intent.getStringExtra("android.intent.extra.TEXT");
        if (!TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        String sms_body = intent.getStringExtra("sms_body");
        if (!TextUtils.isEmpty((CharSequence)sms_body)) {
            return sms_body;
        }
        String weixin_text = intent.getStringExtra("weixin_text");
        if (!TextUtils.isEmpty((CharSequence)weixin_text)) {
            return weixin_text;
        }
        return null;
    }

    private static String getTitle(Intent intent) {
        if (intent == null) {
            return null;
        }
        String weixin_title = intent.getStringExtra("weixin_title");
        if (!TextUtils.isEmpty((CharSequence)weixin_title)) {
            return weixin_title;
        }
        String subject = intent.getStringExtra("android.intent.extra.SUBJECT");
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            return subject;
        }
        String title = ShareUtils.getText(intent);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            return title;
        }
        return null;
    }

    private static String getLegalWebUrl(Intent intent) {
        return ShareUtils.checkWebUrl(ShareUtils.getWebUrl(intent));
    }

    private static String checkWebUrl(String url) {
        if (url == null) {
            return null;
        }
        List<HyperLinkBean> hyperLinkBeans = HyperLinkUtil.parseContent(url, 1);
        if (hyperLinkBeans.isEmpty()) {
            return null;
        }
        return url;
    }

    private static String getWebUrl(Intent intent) {
        String url = intent.getStringExtra("url");
        if (url != null) {
            return url;
        }
        String web_url = intent.getStringExtra("web_url");
        if (web_url != null) {
            return web_url;
        }
        String pageUrl = intent.getStringExtra("pageUrl");
        if (pageUrl != null) {
            return pageUrl;
        }
        String text = ShareUtils.getText(intent);
        if (text != null) {
            if (ShareUtils.isUri(text)) {
                return null;
            }
            List<HyperLinkBean> linkBeanList = HyperLinkUtil.parseContent(text, 1);
            if (!linkBeanList.isEmpty()) {
                return linkBeanList.get(0).getHyperlink();
            }
        }
        return null;
    }

    private static boolean isUri(String content) {
        Uri uri = Uri.parse((String)content);
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return false;
        }
        return TextUtils.equals((CharSequence)scheme, (CharSequence)"content") || TextUtils.equals((CharSequence)scheme, (CharSequence)"file");
    }

    private static String getLegalFileUri(Intent intent) {
        return ShareUtils.checkUri(ShareUtils.getFileUri(intent));
    }

    @RequiresApi(api=16)
    private static String getFileUri(Intent intent) {
        Uri extraUri = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
        if (extraUri != null) {
            return extraUri.toString();
        }
        Uri dataUri = intent.getData();
        if (dataUri != null) {
            return dataUri.toString();
        }
        String ucFileUri = intent.getStringExtra("file");
        if (ucFileUri != null) {
            return ucFileUri;
        }
        ClipData shareClip = intent.getClipData();
        if (shareClip == null) {
            return null;
        }
        ClipData.Item item = shareClip.getItemAt(0);
        if (item == null) {
            return null;
        }
        Uri itemUri = item.getUri();
        if (itemUri != null) {
            return itemUri.toString();
        }
        return null;
    }

    private static String checkUri(String uri) {
        if (TextUtils.isEmpty((CharSequence)uri)) {
            return null;
        }
        if (!uri.startsWith("file") && !uri.startsWith("content")) {
            uri = "file://" + uri;
        }
        return uri;
    }

    public static WebPageInfo getShareWebInfo(Context context, Intent intent, IntentBean intentBean) {
        ShareInfo shareInfo = ShareUtils.getShareInfo(intent);
        WebPageInfo webPageInfo = new WebPageInfo();
        webPageInfo.setDescription(shareInfo.getContent());
        webPageInfo.setWebUri(shareInfo.getWebUrl());
        webPageInfo.setTitle(shareInfo.getTitle());
        webPageInfo.setAction(intentBean.getAction());
        webPageInfo.setType(intentBean.getType());
        if (shareInfo.getFileUri() == null) {
            return webPageInfo;
        }
        FileItem info = IMFileUtils.queryLocalFiles(context, Uri.parse((String)shareInfo.getFileUri()));
        if (info == null) {
            return webPageInfo;
        }
        webPageInfo.setFileName(info.getFileName());
        webPageInfo.setFilePath(info.getFilePath());
        webPageInfo.setFileSize(info.getFileSize());
        webPageInfo.setFileType(info.getFileType());
        String name = info.getFileName();
        String suffix = ToolUtil.getLastString(name, ".");
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            webPageInfo.setSuffix(suffix);
        }
        webPageInfo.setSuffix(suffix);
        webPageInfo.setFileType(info.getFileType());
        return webPageInfo;
    }

    private static String dealText(String str1, String str2) {
        String text = null;
        if (!TextUtils.isEmpty((CharSequence)str1)) {
            text = str1;
        } else if (!TextUtils.isEmpty((CharSequence)str2)) {
            text = str2;
        }
        return text;
    }

    private static String transformSource(String source) {
        if (TextUtils.equals((CharSequence)source, (CharSequence)"isUCM")) {
            return "UC";
        }
        return null;
    }

    public static boolean hasPhotoForWeb(FileInfo fileInfo) {
        String fileName = fileInfo.getFileName();
        String filePath = fileInfo.getFilePath();
        return !TextUtils.isEmpty((CharSequence)fileName) && !TextUtils.isEmpty((CharSequence)filePath);
    }

    public static boolean isPhotoDownloadedForWeb(FileInfo fileInfo) {
        int fileState = fileInfo.getFileState();
        String path = fileInfo.getFilePath();
        File file = new File(path);
        return fileState == 2 && file.exists();
    }

    @SuppressLint(value={"NewApi"})
    public static IntentBean getIntentBean(Intent intent) {
        String curType;
        IntentBean intentBean = new IntentBean();
        if (intent != null && !TextUtils.isEmpty((CharSequence)(curType = IMFileUtils.filterFileType(intent)))) {
            if (curType.startsWith("image/")) {
                curType = "image/";
            }
            if (curType.startsWith("text/") || curType.startsWith("web/")) {
                curType = "text/";
            }
            if (curType.startsWith("video/")) {
                curType = "video/";
            }
            if (curType.startsWith("file/")) {
                curType = "file/";
            }
            if (curType.startsWith("web/")) {
                curType = "web/";
            }
            intentBean = ShareUtils.dealForAction(curType, intent, intentBean);
        }
        return intentBean;
    }

    @SuppressLint(value={"NewApi"})
    private static IntentBean dealForAction(String curType, Intent intent, IntentBean intentBean) {
        ArrayList<String> dataList = new ArrayList<String>();
        String action = intent.getAction();
        String type = intent.getType();
        intentBean.setAction(action);
        intentBean.setType(type);
        if (intent.getExtras() != null) {
            intentBean.setSubject(intent.getExtras().getString("android.intent.extra.SUBJECT"));
            intentBean.setContent(intent.getExtras().getString("android.intent.extra.TEXT"));
        }
        Uri imageUri = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
        switch (action) {
            case "android.intent.action.SEND": 
            case "android.intent.action.FORWARD": {
                Uri uri = intent.getData();
                imageUri = imageUri == null ? uri : imageUri;
                dataList.clear();
                if (imageUri == null || IMFileUtils.filterFileType(intent) == "web/") break;
                dataList.add(imageUri.toString());
                break;
            }
            case "android.intent.action.SEND_MULTIPLE": {
                ArrayList uris = intent.getParcelableArrayListExtra("android.intent.extra.STREAM");
                dataList.clear();
                for (Uri uriList : uris) {
                    if (uriList == null) continue;
                    dataList.add(uriList.toString());
                }
                break;
            }
        }
        switch (curType) {
            case "image/": {
                break;
            }
            case "text/": {
                break;
            }
            case "file/": {
                break;
            }
            case "video/": {
                break;
            }
            case "web/": {
                break;
            }
        }
        intentBean.setUriArrayList(dataList);
        return intentBean;
    }

    public static Intent buildForwardIntent(Activity activity, TalkMessageBean talkMessageBean) {
        Intent intent = new Intent((Context)activity, ShareSessionListActivity.class);
        intent.setAction("android.intent.action.FORWARD");
        intent.setType("android.intent.action.type.FORWARD");
        intent.putExtra("FORWARD_MSG_TYPE", talkMessageBean.getMessageType());
        Bundle bundle = new Bundle();
        boolean ifDownLoad = false;
        switch (talkMessageBean.getMessageType()) {
            case 0: {
                ifDownLoad = true;
                bundle.putString("android.intent.extra.TEXT", talkMessageBean.getContent());
                break;
            }
            case 14: {
                ifDownLoad = true;
                bundle.putString("android.intent.extra.TEXT", talkMessageBean.getContent());
                break;
            }
            case 201: {
                ifDownLoad = true;
                bundle.putString("android.intent.extra.TEXT", talkMessageBean.getContent());
                break;
            }
            case 2: {
                VideoFileInfo videoFileInfo = (VideoFileInfo)talkMessageBean.getFileInfo();
                if (videoFileInfo != null && videoFileInfo.getRawFileInfo() != null) {
                    String path = videoFileInfo.getRawFileInfo().getFilePath();
                    Uri uri = Uri.fromFile((File)new File(path));
                    ifDownLoad = ShareUtils.checkFile(path, videoFileInfo.getRawFileInfo().getFileState());
                    bundle.putSerializable("FORWARD_FILE", (Serializable)videoFileInfo);
                    break;
                }
                ifDownLoad = false;
                break;
            }
            case 3: {
                FileInfo fileInfo;
                ImageFileInfo imageFileInfo = (ImageFileInfo)talkMessageBean.getFileInfo();
                ifDownLoad = false;
                if (imageFileInfo == null) break;
                Object path = null;
                if (!TextUtils.isEmpty((CharSequence)imageFileInfo.getSuffix()) && imageFileInfo.getSuffix().equals("gif")) {
                    FileInfo fileInfo2 = imageFileInfo.getRawFileInfo();
                    if (ShareUtils.checkFile(fileInfo2.getFilePath(), fileInfo2.getFileState())) {
                        ifDownLoad = true;
                    }
                } else if (imageFileInfo.getRawFileInfo() != null) {
                    FileInfo fileInfo3 = imageFileInfo.getRawFileInfo();
                    if (ShareUtils.checkFile(fileInfo3.getFilePath(), fileInfo3.getFileState())) {
                        ifDownLoad = true;
                    }
                } else if (imageFileInfo.getHdFileInfo() != null && ShareUtils.checkFile((fileInfo = imageFileInfo.getHdFileInfo()).getFilePath(), fileInfo.getFileState())) {
                    ifDownLoad = true;
                }
                bundle.putSerializable("FORWARD_FILE", (Serializable)imageFileInfo);
                break;
            }
            case 4: {
                FileInfo fileInfo = talkMessageBean.getFileInfo();
                if (fileInfo != null) {
                    String path = fileInfo.getFilePath();
                    Uri uri = Uri.fromFile((File)new File(path));
                    ifDownLoad = ShareUtils.checkFile(path, fileInfo.getFileState());
                    bundle.putSerializable("FORWARD_FILE", (Serializable)fileInfo);
                    break;
                }
                ifDownLoad = false;
                break;
            }
            case 5: {
                ifDownLoad = true;
                WebPageInfo webPageInfo = talkMessageBean.getWebPageInfo();
                if (webPageInfo != null) {
                    bundle.putSerializable("FORWARD_WEB", (Serializable)webPageInfo);
                    break;
                }
                ifDownLoad = false;
            }
        }
        intent.putExtras(bundle);
        if (ifDownLoad) {
            return intent;
        }
        return null;
    }

    public static Intent getForwardListIntent(Context activity, @NonNull ArrayList<FileInfo> infos, @NonNull int talkType, @NonNull String talkAccount) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putSerializable("selectFile", infos);
        intent.putExtras(bundle);
        intent.setAction("android.intent.action.FORWARD");
        intent.setType("android.intent.action.type.FORWARD");
        intent.putExtra("talkerId", talkAccount);
        intent.putExtra("talkType", talkType);
        intent.setClass(activity, ShareSessionListActivity.class);
        return intent;
    }

    public static Intent getForwardListIntent(Context activity, @NonNull ArrayList<FileInfo> infos, @NonNull int talkType, @NonNull String talkAccount, @NonNull ArrayList<TalkMessageBean> transmitBeans) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putSerializable("selectFile", infos);
        bundle.putSerializable("FORWARD_MSG_TYPE", transmitBeans);
        intent.putExtras(bundle);
        intent.setAction("android.intent.action.FORWARD");
        intent.setType("android.intent.action.type.FORWARD");
        intent.putExtra("talkerId", talkAccount);
        intent.putExtra("talkType", talkType);
        intent.setClass(activity, ShareSessionListActivity.class);
        return intent;
    }

    private static boolean checkFile(String path, int fileState) {
        return new File(path).canRead() && (fileState == 2 || fileState == 6 || fileState == 7 || fileState == 8 || fileState == 9 || fileState == 10);
    }
}

