/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.support.annotation.DrawableRes;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.video.utils.DisplayUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.view.KeyboardLayout;
import com.xdja.im.uikit.view.PromptPictureView;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ViewChatList
extends ImFragmentSuperView<ChatListPresenter>
implements ChatListVu {
    private static final String TAG = "ViewChatList";
    private KeyboardLayout mRootLayout;
    private RelativeLayout mContentLayout;
    private RelativeLayout scrollLayout;
    private TextView button;
    private float upY = 0.0f;
    private float downY = 0.0f;
    private ListView mChatListView;
    private ChatInputView mChatInputView;
    private ChatActionView mChatActionView;
    private SwipeRefreshLayout swipeRefreshLayout;
    private InputMethodManager inputMethodManager;
    private RelativeLayout im_uikit_meeting_tips_layout;
    private TextView im_uikit_meeting_tips_txt;
    private PromptPictureView promptPictureView;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_chat_list;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mRootLayout = (KeyboardLayout)this.findViewById(R.id.root_layout);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.content_layout);
        this.mChatListView = (ListView)this.findViewById(R.id.lv_message_list);
        this.mChatInputView = (ChatInputView)this.findViewById(R.id.layout_chat_operate);
        this.mChatActionView = (ChatActionView)this.findViewById(R.id.layout_chat_action);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_container);
        this.im_uikit_meeting_tips_layout = (RelativeLayout)this.findViewById(R.id.im_uikit_meeting_tips_layout);
        this.im_uikit_meeting_tips_txt = (TextView)this.findViewById(R.id.im_uikit_meeting_tips_txt);
        this.promptPictureView = (PromptPictureView)this.findViewById(R.id.prompt_picture_view);
        this.im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).addMeeting();
            }
        });
        if (((ChatListPresenter)this.getPresenter()).getTalkType() == 201) {
            this.mChatInputView.setVisibility(8);
            this.mChatActionView.setVisibility(8);
        }
        this.createBtnView();
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).downRefreshList();
            }
        });
        if (((ChatListPresenter)this.getPresenter()).getTalkType() != 201) {
            this.registerInputCallback();
            this.mRootLayout.setActivity(this.getActivity());
            this.mChatActionView.setAcceptInput(this.mChatInputView.getInputEdt());
        }
        this.initChatListListView();
        this.setNavigateCallback(new ImFragmentSuperView.onNavigateCallback(){

            @Override
            public void onBackClick() {
                ViewChatList.this.hideSoftInputView();
            }

            @Override
            public void onAddClick() {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).startSetting();
            }
        });
        this.promptPictureView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)ViewChatList.this.promptPictureView.getPath())) {
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).clickPromptPicture(ViewChatList.this.promptPictureView.getPath());
                }
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        this.supportActionBar(visibility == 0);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        this.setToolBarAddVisible(visibility == 0);
    }

    @Override
    public void setToolBarAddImageId(@DrawableRes int id2) {
        this.setToolBarAddImage(id2);
    }

    @Override
    public void setTitle(String title) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatListAdapter adapter) {
        this.mChatListView.setAdapter((ListAdapter)adapter);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (this.mChatActionView != null) {
            this.mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public ListView getListView() {
        return this.mChatListView;
    }

    @Override
    public void setDividerHeight(int height) {
        this.mChatListView.setDividerHeight(height);
    }

    @Override
    public String getInputContent() {
        return this.mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            this.mChatInputView.setIsDraft(true);
            this.mChatActionView.formatSpanContent(content);
        }
        this.mChatInputView.setInputText(content);
    }

    @Override
    public boolean isRefreshing() {
        return this.swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        this.swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        if (this.mChatListView != null) {
            this.mChatListView.setSelection(selection);
        }
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.mChatActionView != null) {
            this.mChatListView.scrollTo(x, y);
        }
    }

    private void registerInputCallback() {
        this.mChatInputView.registerActionViewCallBack(new IChatActionCallback(){

            @Override
            public void onVirtualViewCallBack() {
            }

            @Override
            public void onMoreCheckChanged() {
                if (ViewChatList.this.mChatActionView.isActionViewVisible()) {
                    ViewChatList.this.hideActionView(false);
                    ViewChatList.this.restoreActionState();
                } else {
                    String path = PromptPictureUtils.getInstance().getLatestPhotoPath();
                    if (!TextUtils.isEmpty((CharSequence)path) && !path.contains(Environment.getExternalStorageDirectory() + "/DCIM/camera/")) {
                        ViewChatList.this.promptPictureView.setVisibility(0);
                        ViewChatList.this.promptPictureView.loadImage(path);
                    } else {
                        ViewChatList.this.promptPictureView.setVisibility(8);
                    }
                    ViewChatList.this.showActionView();
                    ViewChatList.this.mChatInputView.setMoreState(true);
                    ViewChatList.this.mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {
                if (ViewChatList.this.mChatActionView.isEmojiVisible()) {
                    ViewChatList.this.hideActionView(true);
                    ViewChatList.this.restoreActionState();
                    ViewChatList.this.setEditTextFocus(true);
                } else {
                    ViewChatList.this.showActionView();
                    ViewChatList.this.mChatInputView.setShanState(true);
                    ViewChatList.this.mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {
                if (isChecked) {
                    if (ViewChatList.this.mChatActionView.isShown()) {
                        ViewChatList.this.hideActionView(true);
                    }
                } else {
                    if (ViewChatList.this.mRootLayout.isSoftInputShown()) {
                        ViewChatList.this.hideSoftInputView();
                    }
                    if (ViewChatList.this.mChatActionView.isShown()) {
                        ViewChatList.this.hideActionView(false);
                    }
                    ViewChatList.this.restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = ViewChatList.this.mChatInputView.getInputText();
                if (TextUtils.isEmpty((CharSequence)content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }
                if (((ChatListPresenter)ViewChatList.this.getPresenter()).sendTextMessage(content)) {
                    ViewChatList.this.mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {
                if (ViewChatList.this.mChatActionView.isShown()) {
                    ViewChatList.this.restoreActionState();
                }
                if (ViewChatList.this.mChatListView.getTranscriptMode() != 2) {
                    ViewChatList.this.mChatListView.setTranscriptMode(2);
                }
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).sendVoiceMessage(filePath, seconds);
            }
        });
        this.mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener(){

            @Override
            public void onItemClick(int position, OptionBean optionBean) {
                if (IMUiKitProxyImpl.getInstance().isAccessToOption(optionBean)) {
                    if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                        ((ChatListPresenter)ViewChatList.this.getPresenter()).startVoice(position, optionBean);
                    } else if (optionBean.getId() == 8) {
                        ((ChatListPresenter)ViewChatList.this.getPresenter()).startLocation(position, optionBean);
                    } else if (optionBean.getId() == 7) {
                        ((ChatListPresenter)ViewChatList.this.getPresenter()).startCallback(position, optionBean);
                    } else if (optionBean.getId() > 8) {
                        ((ChatListPresenter)ViewChatList.this.getPresenter()).startCustomCallback(optionBean);
                    } else {
                        ((ChatListPresenter)ViewChatList.this.getPresenter()).startToOptionView(position, optionBean);
                    }
                }
            }
        });
    }

    private void initChatListListView() {
        this.mChatListView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (ViewChatList.this.mChatActionView.isShown()) {
                        ViewChatList.this.restoreActionState();
                        return true;
                    }
                    ViewChatList.this.mChatListView.setFocusable(true);
                    ViewChatList.this.displayInputKeyBoard(false);
                    ViewChatList.this.downY = event.getY();
                }
                if (event.getAction() == 2) {
                    ViewChatList.this.upY = event.getY();
                }
                if (ViewChatList.this.scrollLayout != null && event.getAction() == 1 && ViewChatList.this.upY - ViewChatList.this.downY > 0.0f && Math.abs(ViewChatList.this.upY - ViewChatList.this.downY) > 20.0f) {
                    ViewChatList.this.removeButtonView();
                }
                return false;
            }
        });
        this.mChatListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0) {
                    int firstVisibleItem = ViewChatList.this.mChatListView.getFirstVisiblePosition();
                    int endVisibleItem = ViewChatList.this.mChatListView.getLastVisiblePosition();
                    ((ChatListPresenter)ViewChatList.this.getPresenter()).listScroll(firstVisibleItem, endVisibleItem);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                ViewChatList.this.mChatListView.setFocusable(true);
            }
        });
    }

    public void displayInputKeyBoard(boolean isShow) {
        this.setEditTextFocus(isShow);
        if (!isShow) {
            this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
            if (this.mChatListView.getTranscriptMode() == 2) {
                this.mChatListView.setTranscriptMode(1);
            }
        } else {
            this.inputMethodManager.toggleSoftInput(0, 2);
        }
    }

    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            this.mChatInputView.getInputEdt().setFocusable(true);
            this.mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            this.mChatInputView.getInputEdt().requestFocus();
        } else {
            this.mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    @Override
    public void restoreActionState() {
        this.mChatActionView.setVisibility(8);
        this.mChatInputView.setShanState(false);
        this.mChatInputView.setMoreState(false);
        if (this.mChatListView.getTranscriptMode() == 2) {
            this.mChatListView.setTranscriptMode(1);
        }
    }

    private void showInputBoardAndHideAction() {
        this.mChatActionView.setVisibility(8);
        this.mChatListView.setTranscriptMode(1);
        this.setEditTextFocus(true);
    }

    @Override
    public void setTalkType(int talkType) {
        if (this.mToolbarAdd != null) {
            if (talkType == 1) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                this.mChatInputView.setChatType(talkType);
            } else if (talkType == 2) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                this.mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setGroupId(String groupId) {
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            this.mChatInputView.setGroupId(groupId);
        }
    }

    @Override
    public void setAccount(String account) {
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.mChatInputView.setAccount(account);
        }
    }

    @Override
    public void showAtActionView() {
        if (!this.mChatActionView.isActionViewVisible()) {
            this.showActionView();
        }
        if (!this.inputMethodManager.isActive()) {
            this.displayInputKeyBoard(true);
        }
    }

    @Override
    public void setAtText(String s, int type) {
        if (this.mChatInputView.getInputEdt().length() + s.length() > 2048) {
            new XToast((Context)this.getActivity()).display(R.string.im_uikit_input_length_warnning);
            return;
        }
        if (type == 0) {
            this.showInputBoardAndHideAction();
            if (this.mChatInputView.getInputEdt().getText().toString().contains(s)) {
                return;
            }
        }
        int index = this.mChatInputView.getInputEdt().getSelectionStart();
        Editable editable = this.mChatInputView.getInputEdt().getEditableText();
        if (index < 0 || index >= editable.length()) {
            editable.append((CharSequence)s);
        } else {
            editable.insert(index, (CharSequence)s);
        }
    }

    public void showSoftInputFromWindow(Activity activity, EditText editText) {
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        this.playInputKeyBoard(editText);
    }

    public void playInputKeyBoard(EditText inputEare) {
        this.inputMethodManager.showSoftInput((View)inputEare, 0);
    }

    @Override
    public void setChatMeet(String talkFlag) {
        Observable.just((Object)talkFlag).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, MeetInfo>(){

            public MeetInfo call(String s) {
                MeetInfo meetInfo = MeetInfoEntityDao.getInstance().get(s);
                return meetInfo;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<MeetInfo>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                ViewChatList.this.im_uikit_meeting_tips_layout.setVisibility(8);
            }

            public void onNext(MeetInfo meetInfo) {
                if (meetInfo != null) {
                    if (meetInfo.getIsShow() == 1 && meetInfo.getTaklFlag().equals(((ChatListPresenter)ViewChatList.this.getPresenter()).getTalkFlag())) {
                        ViewChatList.this.im_uikit_meeting_tips_layout.setVisibility(0);
                    } else {
                        ViewChatList.this.im_uikit_meeting_tips_layout.setVisibility(8);
                    }
                    if (!TextUtils.isEmpty((CharSequence)meetInfo.getTips())) {
                        ViewChatList.this.im_uikit_meeting_tips_txt.setText((CharSequence)meetInfo.getTips());
                    }
                } else {
                    ViewChatList.this.im_uikit_meeting_tips_layout.setVisibility(8);
                }
            }
        });
    }

    @Override
    public void setChatMeetTips(String tips) {
        if (!TextUtils.isEmpty((CharSequence)tips) && this.im_uikit_meeting_tips_txt != null) {
            this.im_uikit_meeting_tips_txt.setText((CharSequence)tips);
        }
    }

    public void showActionView() {
        if (this.mRootLayout.isSoftInputShown()) {
            this.lockContentViewHeight();
            this.hideSoftInputView();
            this.restoreActionState();
            this.unlockContentViewHeightDelayed();
        }
        if (this.mChatListView.getTranscriptMode() != 2) {
            this.mChatListView.setTranscriptMode(2);
        }
        this.mChatActionView.setVisibility(0);
        this.mChatInputView.switchToInputEdt(true);
    }

    public void hideActionView(boolean isShowSoftInputView) {
        if (this.mChatActionView.isShown()) {
            this.mChatActionView.setVisibility(8);
            this.promptPictureView.setVisibility(8);
            if (this.mChatListView.getTranscriptMode() == 2) {
                this.mChatListView.setTranscriptMode(1);
            }
            if (isShowSoftInputView) {
                this.showSoftInputView();
            }
        }
    }

    public void lockContentViewHeight() {
        LinearLayout.LayoutParams params = this.getLayoutParamsForContent();
        params.height = this.mContentLayout.getHeight() + 200;
        params.weight = 0.0f;
    }

    public void unlockContentViewHeightDelayed() {
        this.mChatInputView.getInputEdt().postDelayed(new Runnable(){

            @Override
            public void run() {
                LinearLayout.LayoutParams params = ViewChatList.this.getLayoutParamsForContent();
                params.weight = 1.0f;
                ViewChatList.this.mContentLayout.invalidate();
            }
        }, 200L);
    }

    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams)this.mContentLayout.getLayoutParams();
    }

    private void showSoftInputView() {
        final EditText et = this.mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable(){

            @Override
            public void run() {
                ViewChatList.this.inputMethodManager.showSoftInput((View)et, 0);
            }
        });
    }

    private void hideSoftInputView() {
        this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    @Override
    public void changeViewSate(int state) {
        if (!NetworkHelper.getHelper().isFirstNotice() && FunctionUtils.isAppOnForeground((Context)this.getActivity())) {
            if (state == 2) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Network unavailable", (int)1).show();
            } else if (state == 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unable to access the server", (int)1).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == 2) {
            this.im_uikit_meeting_tips_layout.setVisibility(0);
        } else {
            this.im_uikit_meeting_tips_layout.setVisibility(8);
        }
    }

    @Override
    public synchronized void addButtonView(int number) {
        if (this.scrollLayout == null) {
            this.createBtnView();
        }
        String title = number < 99 ? number + this.getActivity().getString(R.string.im_uikit_new_message_title) : Html.fromHtml((String)"<b>...</b>") + this.getActivity().getString(R.string.im_uikit_new_message_title);
        this.button.setText((CharSequence)title);
        this.scrollLayout.setVisibility(0);
        this.scrollLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((ChatListPresenter)ViewChatList.this.getPresenter()).setNoReadNumber();
                ViewChatList.this.removeButtonView();
            }
        });
    }

    @Override
    public synchronized void removeButtonView() {
        if (this.scrollLayout != null) {
            this.mContentLayout.removeView((View)this.scrollLayout);
            this.scrollLayout = null;
        }
    }

    @Override
    public void setSelection(int length, int position) {
        int lastVisiblePosition;
        if (this.mChatListView != null && (lastVisiblePosition = this.mChatListView.getLastVisiblePosition()) == position) {
            this.mChatListView.setSelection(position);
        }
    }

    private void createBtnView() {
        Bitmap bitmap = UniversalUtil.getLanguageType((Context)this.getActivity()) == 2 ? BitmapFactory.decodeResource((Resources)this.getActivity().getResources(), (int)R.drawable.im_uikit_new_message_bg_p) : BitmapFactory.decodeResource((Resources)this.getActivity().getResources(), (int)R.drawable.im_uikit_messages_bg_p);
        int w = -2;
        int h = -2;
        if (bitmap != null) {
            w = bitmap.getWidth();
            h = bitmap.getHeight();
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(w, h);
        layoutParams.setMargins(0, 200, 0, 0);
        layoutParams.addRule(11, -1);
        this.scrollLayout = new RelativeLayout((Context)this.getActivity());
        this.scrollLayout.setClickable(true);
        this.mContentLayout.addView((View)this.scrollLayout, (ViewGroup.LayoutParams)layoutParams);
        this.scrollLayout.setBackgroundResource(R.drawable.im_uikit_messages_bg_p);
        this.button = new TextView((Context)this.getActivity());
        this.button.setPadding(5, 0, 10, 10);
        RelativeLayout.LayoutParams buttonParams = new RelativeLayout.LayoutParams(-2, -2);
        buttonParams.addRule(11);
        buttonParams.addRule(15);
        this.button.setTextColor(this.getResources().getColor(R.color.im_uikit_message_tips_color));
        this.button.setTextSize((float)DisplayUtils.px2dp(this.getContext(), this.getResources().getDimension(R.dimen.im_uikit_message_tips_size)));
        this.scrollLayout.addView((View)this.button, (ViewGroup.LayoutParams)buttonParams);
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        this.scrollLayout.setVisibility(8);
    }
}

