/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.FilePreviewAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;
import com.xdja.im.uikit.view.PhotoView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ViewPreviewImage
extends BaseFilePreview {
    private PhotoView mPhotoView;
    private Button mOriginalBtn;
    private ProgressBar mLoadingPbar;
    private ScreenInfo mScreenInfo;
    private BaseListDialog mDialog;
    private static final int MAX_LENGTH = 1500;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_preview_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mPhotoView = (PhotoView)this.findViewById(R.id.view_photo);
        this.mOriginalBtn = (Button)this.findViewById(R.id.btn_original);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mScreenInfo = ScreenUtil.getScreenInfo(this.getActivity());
        this.mDialog = new BaseListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return ViewPreviewImage.this.buildImOption();
            }
        };
        this.mOriginalBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DateUtils.isOverdue(ViewPreviewImage.this.dataSource.getShowTime())) {
                    new XToast((Context)ViewPreviewImage.this.getActivity()).display(R.string.im_uikit_history_select_all_overdue);
                    return;
                }
                ViewPreviewImage.this.mOriginalBtn.setVisibility(8);
                ViewPreviewImage.this.mLoadingPbar.setVisibility(0);
                ImageFileInfo imageFileInfo = (ImageFileInfo)ViewPreviewImage.this.dataSource.getFileInfo();
                FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
                if (rawFileInfo == null) {
                    LogUtil.w("ERROR: raw file info is null.");
                }
                imageFileInfo.setType(3);
                imageFileInfo.setFileState(3);
                ViewPreviewImage.this.dataSource.setFileInfo(imageFileInfo);
                ((FilePreviewAdapterPresenter)ViewPreviewImage.this.getPresenter()).download(imageFileInfo);
            }
        });
        this.mPhotoView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ViewPreviewImage.this.mDialog.show();
                return false;
            }
        });
        this.mDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                switch (option.getOptionType()) {
                    case 0: {
                        ViewPreviewImage.this.savePhoto();
                        break;
                    }
                    case 1: {
                        ViewPreviewImage.this.deletePhoto();
                    }
                }
            }
        });
        this.mPhotoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewPreviewImage.this.getActivity().finish();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo imageFileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (imageFileInfo == null) {
            this.loadError();
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        this.mLoadingPbar.setVisibility(0);
        if (imageFileInfo.isOriginal()) {
            if (this.loadOriginalImage(imageFileInfo)) {
                return;
            }
            if (this.isFileDownload(imageFileInfo.getFilePath()) && this.imageLoadDependState(imageFileInfo)) {
                this.loadImage(imageFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
            } else if (!this.isFileDownload(imageFileInfo.getFilePath()) && imageFileInfo.getFileState() == 2 || imageFileInfo.getFileState() == 5 || imageFileInfo.getFileState() == 4) {
                this.loadError();
            } else {
                this.mLoadingPbar.setVisibility(0);
                this.loadThumbImage(imageFileInfo.getFilePath());
                imageFileInfo.setType(3);
                ((FilePreviewAdapterPresenter)this.getPresenter()).download(imageFileInfo);
            }
        } else if (hdFileInfo != null) {
            if (this.isFileDownload(hdFileInfo.getFilePath()) && this.imageLoadDependState(hdFileInfo)) {
                this.loadImage(hdFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
            } else if (!this.isFileDownload(imageFileInfo.getFilePath()) && imageFileInfo.getFileState() == 2 || imageFileInfo.getFileState() == 5 || imageFileInfo.getFileState() == 4) {
                this.loadError();
            } else {
                this.mLoadingPbar.setVisibility(0);
                this.loadThumbImage(imageFileInfo.getFilePath());
                imageFileInfo.setType(2);
                ((FilePreviewAdapterPresenter)this.getPresenter()).download(imageFileInfo);
            }
        }
    }

    private List<ImOption> buildImOption() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        data.add(new ImOption(0, this.getStringRes(R.string.im_uikit_preview_option_save)));
        data.add(new ImOption(1, this.getStringRes(R.string.im_uikit_preview_option_delete)));
        return data;
    }

    private boolean loadOriginalImage(ImageFileInfo imageFileInfo) {
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo == null) {
            LogUtil.e("ERROR: Has original image, but raw entity is null.");
            return false;
        }
        if (this.isFileDownload(rawFileInfo.getFilePath())) {
            if (this.imageLoadDependState(rawFileInfo)) {
                this.loadImage(rawFileInfo.getFilePath(), true, imageFileInfo.getFilePath());
                return true;
            }
        } else if (!this.isFileDownload(rawFileInfo.getFilePath()) && rawFileInfo.getFileState() == 2) {
            this.loadError();
            return true;
        }
        this.mOriginalBtn.setVisibility(0);
        this.mOriginalBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_download_original), FileSizeUtils.formatFileSize(rawFileInfo.getFileSize())));
        return false;
    }

    private boolean imageLoadDependState(FileInfo fileInfo) {
        return fileInfo.getFileState() == 7 || fileInfo.getFileState() == 10 || fileInfo.getFileState() == 6 || fileInfo.getFileState() == 8 || fileInfo.getFileState() == 9 || fileInfo.getFileState() == 2;
    }

    private void loadError() {
        this.mPhotoView.disenable();
        ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
        params.width = -2;
        params.width = -2;
        this.mPhotoView.setScaleType(ImageView.ScaleType.CENTER);
        this.mPhotoView.setImageResource(R.mipmap.im_uikit_pic_default);
        this.mLoadingPbar.setVisibility(8);
        this.mOriginalBtn.setVisibility(8);
    }

    private void loadThumbImage(String filePath) {
        this.mPhotoView.disenable();
        this.mPhotoView.setAdjustViewBounds(false);
        ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
        params.width = this.mScreenInfo.getWidth() / 4;
        params.width = this.mScreenInfo.getHeight() / 4;
        ((FilePreviewAdapterPresenter)this.getPresenter()).loadImage((ImageView)this.mPhotoView, filePath, ImageView.ScaleType.FIT_CENTER, this.mScreenInfo.getWidth() / 4, this.mScreenInfo.getWidth() / 4);
    }

    private void loadImage(String filePath, boolean isOriginal, String thFilePath) {
        if (this.isFileDownload(filePath)) {
            this.mPhotoView.enable();
            this.mPhotoView.setAdjustViewBounds(true);
            ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
            params.width = -1;
            params.width = -1;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            if (options.outWidth > 1500 || options.outHeight > 1500) {
                this.mPhotoView.setLayerType(1, null);
            } else {
                this.mPhotoView.setLayerType(2, null);
            }
            Drawable thDrawable = this.getDrawableRes(R.drawable.im_uikit_pic_default);
            if (options.outWidth > 0 && options.outHeight > 0) {
                try {
                    if (options.outHeight / options.outWidth >= 3) {
                        int reqWidth = this.mScreenInfo.getHeight() * options.outWidth / options.outHeight;
                        this.mPhotoView.setMaxScale(((float)this.mScreenInfo.getWidth() - 100.0f) / (float)reqWidth);
                        if (isOriginal) {
                            Glide.with((Activity)this.getActivity()).load(filePath).override(options.outWidth, options.outHeight).error(thDrawable).dontAnimate().into((ImageView)this.mPhotoView);
                        } else {
                            Glide.with((Activity)this.getActivity()).load(filePath).error(thDrawable).dontAnimate().into((ImageView)this.mPhotoView);
                        }
                    } else {
                        Glide.with((Activity)this.getActivity()).load(filePath).dontAnimate().fitCenter().error(thDrawable).into((ImageView)this.mPhotoView);
                    }
                }
                catch (OutOfMemoryError error) {
                    Glide.with((Activity)this.getActivity()).load(filePath).error(R.drawable.im_uikit_pic_default).into((ImageView)this.mPhotoView);
                }
                this.mLoadingPbar.setVisibility(8);
            } else {
                this.loadError();
            }
        } else {
            this.loadError();
        }
    }

    private void savePhoto() {
        ImageFileInfo imageFileInfo = (ImageFileInfo)this.dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("ERROR: Save image, but image file info is null.");
            return;
        }
        String suffix = ToolUtil.getLastString(imageFileInfo.getFileName(), ".");
        String fileName = suffix.equals("gif") ? "imageexport" + System.currentTimeMillis() + ".gif" : "imageexport" + System.currentTimeMillis() + ".jpeg";
        File srcFile = null;
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (rawFileInfo != null && this.isFileDownload(rawFileInfo.getFilePath())) {
            srcFile = new File(rawFileInfo.getFilePath());
        } else if (hdFileInfo != null && this.isFileDownload(hdFileInfo.getFilePath())) {
            srcFile = new File(hdFileInfo.getFilePath());
        } else if (!TextUtils.isEmpty((CharSequence)imageFileInfo.getFilePath()) && this.isFileDownload(imageFileInfo.getFilePath())) {
            srcFile = new File(imageFileInfo.getFilePath());
        }
        if (srcFile != null) {
            ((FilePreviewAdapterPresenter)this.getPresenter()).saveFile(srcFile, FilePathUtils.getImageRecPath(), fileName);
        } else {
            CommonTool.showToast(R.string.im_uikit_hint_save_image_failed);
        }
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    private void deletePhoto() {
        ((FilePreviewAdapterPresenter)this.getPresenter()).deleteMsg(this.dataSource);
        this.mDialog.dismiss();
    }

    public boolean isFileDownload(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    @Override
    public void onFileDownloadFinish() {
        ImageFileInfo imageFileInfo = (ImageFileInfo)this.dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("onFileDownloadFinish imageFileInfo is null.");
        }
        this.preLoadImage(imageFileInfo);
    }

    private void preLoadImage(ImageFileInfo imageFileInfo) {
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo != null && FileUtils.isFileExists(rawFileInfo.getFilePath()) && rawFileInfo.getFileState() == 2) {
            this.mLoadingPbar.setVisibility(8);
            this.loadImage(rawFileInfo.getFilePath(), true, imageFileInfo.getFilePath());
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (hdFileInfo != null && this.isFileDownload(hdFileInfo.getFilePath()) && hdFileInfo.getFileState() == 2) {
            this.mLoadingPbar.setVisibility(8);
            this.loadImage(hdFileInfo.getFilePath(), false, imageFileInfo.getFilePath());
        } else {
            this.loadError();
        }
    }
}

