/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseReceiveItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewRecvVideoItem
extends BaseReceiveItem {
    private ChatImageView mChatImage;
    private ImageView mPlayFlagImg;
    private CircleProgressBar mLoadingPBar;
    private ProgressBar mLoadingPbar;
    private TextView mVideoTimeTv;
    private TextView mVideoSizeTv;
    private ImageButton mRetryBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_send_image);
        this.mPlayFlagImg = (ImageView)this.findViewById(R.id.img_play_flag);
        this.mLoadingPBar = (CircleProgressBar)this.findViewById(R.id.pbar_video_loading);
        this.mVideoTimeTv = (TextView)this.findViewById(R.id.tv_video_duration);
        this.mVideoSizeTv = (TextView)this.findViewById(R.id.tv_video_size);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mRetryBtn = (ImageButton)this.findViewById(R.id.img_retry_download);
        this.mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return ViewRecvVideoItem.this.showPopDialog();
            }
        });
        this.mPlayFlagImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewRecvVideoItem.this.getPresenter()).previewVideo((TalkMessageBean)ViewRecvVideoItem.this.dataSource);
            }
        });
        this.mRetryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewRecvVideoItem.this.mLoadingPbar.setVisibility(0);
                ViewRecvVideoItem.this.mRetryBtn.setVisibility(8);
                ((ChatListAdapterPresenter)ViewRecvVideoItem.this.getPresenter()).downLoadFile((TalkMessageBean)ViewRecvVideoItem.this.dataSource, ((TalkMessageBean)ViewRecvVideoItem.this.dataSource).getFileInfo());
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        this.mChatImage.setImageBitmap(null);
        this.mContentLayout.setBackgroundResource(0);
        this.mLoadingPbar.setVisibility(8);
        this.mRetryBtn.setVisibility(8);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        VideoFileInfo videoFileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("ERROR: video file info is null error");
            return;
        }
        this.mPlayFlagImg.setVisibility(0);
        this.mVideoTimeTv.setVisibility(0);
        this.mVideoSizeTv.setVisibility(0);
        if (dataSource.getMessageState() == 5) {
            this.mPlayFlagImg.setVisibility(8);
            this.mChatImage.setImageResource(R.mipmap.im_uikit_bg_shanxin_image);
        } else {
            if (TextUtils.isEmpty((CharSequence)videoFileInfo.getFilePath())) {
                this.setReDownloadVisible();
                return;
            }
            this.mVideoTimeTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_video_duration), videoFileInfo.getAmountOfTime() / 60, videoFileInfo.getAmountOfTime() % 60));
            this.mVideoSizeTv.setText((CharSequence)FileSizeUtils.formatAutoFileSize(videoFileInfo.getRawFileSize()));
            if (videoFileInfo.getFileState() == 5) {
                this.setProgressBarVisible(false);
                this.setReDownloadVisible();
                this.mVideoTimeTv.setVisibility(8);
                this.mVideoSizeTv.setVisibility(8);
            } else if (videoFileInfo.getFileState() == 2) {
                this.setProgressBarVisible(false);
                this.loadImage(videoFileInfo.getFilePath());
            } else {
                this.setProgressBarVisible(true);
                this.mVideoTimeTv.setVisibility(8);
                this.mVideoSizeTv.setVisibility(8);
                this.mPlayFlagImg.setVisibility(8);
                ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile(dataSource, videoFileInfo);
            }
        }
        if (dataSource.getMessageState() < 4) {
            ((ChatListAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
        }
    }

    private void loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            this.mChatImage.loadImage(filePath, 0);
            if (this.mContentLayout.getVisibility() == 0) {
                ((ChatListAdapterPresenter)this.getPresenter()).scrollTo(this.curPosition);
            }
        } else {
            this.mVideoTimeTv.setVisibility(8);
            this.mPlayFlagImg.setVisibility(8);
            this.mVideoSizeTv.setVisibility(8);
            this.mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    private void setReDownloadVisible() {
        this.mChatImage.setImageResource(R.mipmap.im_uikit_ic_video_failed);
        if (this.mRetryBtn == null) {
            LogUtil.w("ERROR:reDownloadImageBtn is null.");
            return;
        }
        this.mRetryBtn.setVisibility(0);
    }

    private void setProgressBarVisible(boolean isVisible) {
        if (isVisible) {
            this.mLoadingPbar.setVisibility(0);
        } else {
            this.mLoadingPbar.setVisibility(8);
        }
    }
}

