/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.xdja.imsdk.db.bean.DuplicateIdDb;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.HdThumbFileDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.bean.SessionEntryDb;
import com.xdja.imsdk.db.bean.SyncIdDb;
import com.xdja.imsdk.db.builder.AttentionMsgBuilder;
import com.xdja.imsdk.db.dao.DuplicateIdDao;
import com.xdja.imsdk.db.dao.FileMsgDao;
import com.xdja.imsdk.db.dao.HdThumbFileDao;
import com.xdja.imsdk.db.dao.MsgEntryDao;
import com.xdja.imsdk.db.dao.RawFileDao;
import com.xdja.imsdk.db.dao.SessionEntryDao;
import com.xdja.imsdk.db.dao.SyncIdDao;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.model.internal.old.OldFile;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;

public class ImSdkDatabaseHelper
extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 12;
    private String account;
    private static final String SQL_ALTER_OLD_ID_REFERENCE = "ALTER TABLE id_reference RENAME TO id_ref_tmp";
    private static final String SQL_ALTER_OLD_FILE_MSG = "ALTER TABLE file_msg RENAME TO file_msg_tmp";
    private static final String SQL_ALTER_OLD_FILE_EXTRA = "ALTER TABLE file_extra_msg RENAME TO file_extra_tmp";
    private static final String SQL_ALTER_OLD_MSG_ENTRY = "ALTER TABLE msg_entry RENAME TO msg_tmp";
    private static final String SQL_ALTER_OLD_OPTIONS = "ALTER TABLE OPTIONS RENAME TO options_tmp";
    private static final String SQL_ALTER_OLD_SESSION_ENTRY = "ALTER TABLE session_entry RENAME TO session_tmp";
    private static final String SQL_DROP_TRIGGER_MSG_UPDATE = "DROP TRIGGER IF EXISTS session_update_on_insert_trigger";
    private static final String SQL_DROP_TRIGGER_MSG_DELETE_INSERT = "DROP TRIGGER IF EXISTS msg_deleted_on_insert_trigger";
    private static final String SQL_DROP_TRIGGER_MSG_DELETE = "DROP TRIGGER IF EXISTS msg_insert_deleted_on_delete_trigger";
    private static final String SQL_DROP_TRIGGER_MSG_DELETE_UPDATE = "DROP TRIGGER IF EXISTS file_msg_delete_on_update_trigger";
    private static final String SQL_DROP_TRIGGER_MSG_DELETE_DELETE = "DROP TRIGGER IF EXISTS file_msg_delete_on_delete_trigger";
    private static final String SQL_DROP_TRIGGER_SESSION_DELETE = "DROP TRIGGER IF EXISTS session_delete_msg_on_delete_trigger";
    private static final String SQL_DROP_OLD_ID = "DROP TABLE id_ref_tmp;";
    private static final String SQL_DROP_FILE_MSG = "DROP TABLE file_msg_tmp;";
    private static final String SQL_DROP_FILE_EXTRA = "DROP TABLE file_extra_tmp;";
    private static final String SQL_DROP_OPTIONS = "DROP TABLE options_tmp;";
    private static final String SQL_DROP_MSG = "DROP TABLE msg_tmp;";
    private static final String SQL_DROP_SESSION = "DROP TABLE session_tmp;";
    private static final String SQL_DROP_TRIGGER_SESSION_UPDATE = "DROP TRIGGER IF EXISTS session_update_on_insert_trigger";

    public ImSdkDatabaseHelper(Context context, String name, String account) {
        super(context, name, null, 12);
        this.account = account;
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        this.createMsgEntryTable(sqLiteDatabase);
        this.createSessionEntryTable(sqLiteDatabase);
        this.createFileMsgTable(sqLiteDatabase);
        this.createHdThumbFileTable(sqLiteDatabase);
        this.createRawFileTable(sqLiteDatabase);
        this.createLocalStateMsgTable(sqLiteDatabase);
        this.createDeletedMsgTable(sqLiteDatabase);
        this.createDuplicateIdTable(sqLiteDatabase);
        this.createSyncIdTable(sqLiteDatabase);
        this.createOptionsTable(sqLiteDatabase);
        this.createAttentionMsgTable(sqLiteDatabase);
        this.createGroupMsgStateTable(sqLiteDatabase);
        this.createGroupReadTable(sqLiteDatabase);
        this.createIndexInV11(sqLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sqlLiteDatabase, int oldVersion, int newVersion) {
        if (oldVersion == 5) {
            this.upgrade2V6(sqlLiteDatabase);
            oldVersion = 6;
        }
        if (oldVersion == 6) {
            this.upgrade2V7(sqlLiteDatabase);
            oldVersion = 7;
        }
        if (oldVersion == 7) {
            this.upgrade2V8(sqlLiteDatabase);
            oldVersion = 8;
        }
        if (oldVersion == 8) {
            this.upgrade2V9(sqlLiteDatabase);
            oldVersion = 9;
        }
        if (oldVersion == 9) {
            this.upgrade2V10(sqlLiteDatabase);
            oldVersion = 10;
        }
        if (oldVersion == 10) {
            this.upgrade2V11(sqlLiteDatabase);
            oldVersion = 11;
        }
        if (oldVersion == 11) {
            this.upgrade2V12(sqlLiteDatabase);
        }
    }

    private void upgrade2V6(SQLiteDatabase db) {
        db.execSQL("DROP TRIGGER IF EXISTS session_update_on_insert_trigger");
        db.execSQL(SQL_DROP_TRIGGER_MSG_DELETE_INSERT);
        db.execSQL(SQL_DROP_TRIGGER_MSG_DELETE);
        db.execSQL(SQL_DROP_TRIGGER_MSG_DELETE_UPDATE);
        db.execSQL(SQL_DROP_TRIGGER_MSG_DELETE_DELETE);
        db.execSQL(SQL_DROP_TRIGGER_SESSION_DELETE);
        db.execSQL(SQL_ALTER_OLD_ID_REFERENCE);
        db.execSQL(SQL_ALTER_OLD_FILE_MSG);
        db.execSQL(SQL_ALTER_OLD_FILE_EXTRA);
        db.execSQL(SQL_ALTER_OLD_MSG_ENTRY);
        db.execSQL(SQL_ALTER_OLD_OPTIONS);
        db.execSQL(SQL_ALTER_OLD_SESSION_ENTRY);
        this.createDuplicateIdTable(db);
        this.createSyncIdTable(db);
        this.createFileMsgTable(db);
        this.createHdThumbFileTable(db);
        this.createRawFileTable(db);
        this.createMsgEntryTable(db);
        this.createOptionsTable(db);
        this.createSessionEntryTable(db);
        this.upgradeId5To6(db);
        this.upgradeHdRaw5To6(db);
        this.upgradeFileMsg5To6(db);
        this.upgradeMsg5To6(db);
        this.upgradeSession5To6(db);
        db.execSQL(SQL_DROP_OLD_ID);
        db.execSQL(SQL_DROP_FILE_MSG);
        db.execSQL(SQL_DROP_FILE_EXTRA);
        db.execSQL(SQL_DROP_OPTIONS);
        db.execSQL(SQL_DROP_MSG);
        db.execSQL(SQL_DROP_SESSION);
    }

    private void upgrade2V7(SQLiteDatabase db) {
        StringBuilder ppNotice = new StringBuilder("UPDATE ");
        ppNotice.append("msg_entry").append(" SET ").append("TYPE");
        ppNotice.append(" = ").append(32769).append(" WHERE ");
        ppNotice.append("TYPE").append(" = ").append(129).append(";");
        db.execSQL(ppNotice.toString());
        StringBuilder pgNotice = new StringBuilder("UPDATE ");
        pgNotice.append("msg_entry").append(" SET ").append("TYPE");
        pgNotice.append(" = ").append(32773).append(" WHERE ");
        pgNotice.append("TYPE").append(" = ").append(133).append(";");
        db.execSQL(pgNotice.toString());
    }

    private void upgrade2V8(SQLiteDatabase db) {
        StringBuilder addMsg = new StringBuilder("ALTER TABLE ");
        addMsg.append("msg_entry").append(" ADD COLUMN ").append("MSG_EXTRA");
        addMsg.append(" TEXT;");
        db.execSQL(addMsg.toString());
        StringBuilder updateSession = new StringBuilder("UPDATE ");
        updateSession.append("session_entry").append(" SET ");
        updateSession.append("IM_PARTNER").append(" = '10000', ");
        updateSession.append("LAST_TIME").append(" = ");
        updateSession.append("START_TIME").append(", ");
        updateSession.append("SESSION_FLAG").append(" = '10000_100'");
        updateSession.append(" WHERE ").append("SESSION_TYPE").append(" = ");
        updateSession.append(100).append(";");
        db.execSQL(updateSession.toString());
    }

    private void upgrade2V9(SQLiteDatabase db) {
        StringBuilder fileMd5 = new StringBuilder("ALTER TABLE ");
        fileMd5.append("file_msg").append(" ADD COLUMN ").append("FILE_MD5");
        fileMd5.append(" TEXT;");
        StringBuilder hdMd5 = new StringBuilder("ALTER TABLE ");
        hdMd5.append("hd_thumb_file").append(" ADD COLUMN ").append("HD_MD5");
        hdMd5.append(" TEXT;");
        StringBuilder rawMd5 = new StringBuilder("ALTER TABLE ");
        rawMd5.append("raw_file").append(" ADD COLUMN ").append("RAW_MD5");
        rawMd5.append(" TEXT;");
        db.execSQL(fileMd5.toString());
        db.execSQL(hdMd5.toString());
        db.execSQL(rawMd5.toString());
    }

    private void upgrade2V10(SQLiteDatabase db) {
        try {
            StringBuilder msgExtraState = new StringBuilder("ALTER TABLE ");
            msgExtraState.append("msg_entry").append(" ADD COLUMN ").append("EXTRA_STATE");
            msgExtraState.append(" INTEGER DEFAULT 0;");
            db.execSQL(msgExtraState.toString());
            this.createAttentionMsgTable(db);
            this.createGroupMsgStateTable(db);
            this.createGroupReadTable(db);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void upgrade2V11(SQLiteDatabase db) {
        try {
            db.execSQL("DROP TRIGGER IF EXISTS session_update_on_insert_trigger");
            StringBuilder strictly = new StringBuilder("ALTER TABLE ");
            strictly.append("session_entry").append(" ADD COLUMN ").append("STRICTLY");
            strictly.append(" INTEGER DEFAULT 0;");
            db.execSQL(strictly.toString());
            db.execSQL("CREATE TRIGGER session_update_remind_on_insert_trigger  AFTER INSERT ON msg_entry BEGIN  UPDATE session_entry SET LAST_TIME = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new.SORT_TIME ELSE LAST_TIME END), LAST_MSG = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new._id ELSE LAST_MSG END), REMINDED = (CASE WHEN new.STATE > 0 AND (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) <> 8192 THEN REMINDED + 1 ELSE REMINDED END), STRICTLY = (CASE WHEN (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) = 8192 THEN STRICTLY + 1 ELSE STRICTLY END) WHERE (new.TYPE & 16) <> 16 AND SESSION_FLAG = new.SESSION_FLAG; END;");
            StringBuilder pgNotice = new StringBuilder("UPDATE ");
            pgNotice.append("msg_entry").append(" SET ").append("TYPE");
            pgNotice.append(" = ").append(32773).append(" WHERE ");
            pgNotice.append("TYPE").append(" = ").append(133).append(";");
            db.execSQL(pgNotice.toString());
            this.createIndexInV11(db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void upgrade2V12(SQLiteDatabase db) {
        try {
            db.execSQL("DROP TRIGGER IF EXISTS session_update_on_insert_trigger");
            db.execSQL("CREATE TRIGGER session_update_remind_on_insert_trigger  AFTER INSERT ON msg_entry BEGIN  UPDATE session_entry SET LAST_TIME = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new.SORT_TIME ELSE LAST_TIME END), LAST_MSG = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new._id ELSE LAST_MSG END), REMINDED = (CASE WHEN new.STATE > 0 AND (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) <> 8192 THEN REMINDED + 1 ELSE REMINDED END), STRICTLY = (CASE WHEN (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) = 8192 THEN STRICTLY + 1 ELSE STRICTLY END) WHERE (new.TYPE & 16) <> 16 AND SESSION_FLAG = new.SESSION_FLAG; END;");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMsgEntryTable(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE TABLE msg_entry (_id INTEGER PRIMARY KEY AUTOINCREMENT,SERVER_ID INTEGER UNIQUE,SENDER TEXT,RECEIVER TEXT,CARD_ID TEXT,TYPE INTEGER DEFAULT 0,CONTENT TEXT,STATE INTEGER DEFAULT 0,SESSION_FLAG TEXT,ATTR INTEGER DEFAULT 0,LIFE_TIME INTEGER DEFAULT 0,CREATE_TIME INTEGER DEFAULT 0,SENT_TIME INTEGER DEFAULT 0,SORT_TIME INTEGER DEFAULT 0,MSG_EXTRA TEXT,EXTRA_STATE INTEGER DEFAULT 0)");
            db.execSQL("CREATE TRIGGER session_update_remind_on_insert_trigger  AFTER INSERT ON msg_entry BEGIN  UPDATE session_entry SET LAST_TIME = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new.SORT_TIME ELSE LAST_TIME END), LAST_MSG = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new._id ELSE LAST_MSG END), REMINDED = (CASE WHEN new.STATE > 0 AND (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) <> 8192 THEN REMINDED + 1 ELSE REMINDED END), STRICTLY = (CASE WHEN (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) = 8192 THEN STRICTLY + 1 ELSE STRICTLY END) WHERE (new.TYPE & 16) <> 16 AND SESSION_FLAG = new.SESSION_FLAG; END;");
            db.execSQL("CREATE TRIGGER msg_insert_deleted_on_delete_trigger  BEFORE DELETE ON msg_entry WHEN (old.TYPE & 16) <> 16 AND old.SERVER_ID > 0  BEGIN  INSERT INTO deleted_msg (MSG_ID, SERVER_ID) VALUES(old._id, old.SERVER_ID); END; ");
            db.execSQL("CREATE TRIGGER file_msg_delete_on_delete_trigger  BEFORE DELETE ON msg_entry BEGIN  DELETE FROM file_msg WHERE MSG_ID = old._id; DELETE FROM hd_thumb_file WHERE HD_MSG_ID = old._id; DELETE FROM raw_file WHERE RAW_MSG_ID = old._id; END; ");
            db.execSQL("CREATE TRIGGER file_msg_delete_on_update_trigger  AFTER UPDATE ON msg_entry WHEN (new.TYPE & 2) = 2 AND new.STATE = 4 AND new.ATTR & 1 = 1 BEGIN  DELETE FROM file_msg WHERE MSG_ID = new._id; DELETE FROM hd_thumb_file WHERE HD_MSG_ID = old._id; DELETE FROM raw_file WHERE RAW_MSG_ID = old._id; END; ");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createSessionEntryTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE session_entry (_id INTEGER PRIMARY KEY AUTOINCREMENT,IM_PARTNER TEXT,SESSION_TYPE INTEGER DEFAULT 0,LAST_MSG INTEGER DEFAULT 0,START_TIME INTEGER DEFAULT 0,LAST_TIME INTEGER DEFAULT 0,REMINDED INTEGER DEFAULT 0,SESSION_FLAG TEXT UNIQUE,STRICTLY INTEGER DEFAULT 0)");
        db.execSQL("CREATE TRIGGER session_delete_msg_on_delete_trigger BEFORE DELETE ON session_entry BEGIN  DELETE FROM msg_entry WHERE SESSION_FLAG = old.SESSION_FLAG; END;");
    }

    private void createFileMsgTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE file_msg (_id INTEGER PRIMARY KEY ASC AUTOINCREMENT,FILE_PATH TEXT,ENCRYPT_PATH TEXT,FILE_NAME TEXT,FILE_SIZE INTEGER DEFAULT 0,ENCRYPT_SIZE INTEGER DEFAULT 0,TRANSLATE_SIZE INTEGER DEFAULT 0,SUFFIX TEXT,FID TEXT,FILE_STATE INTEGER DEFAULT 0,MSG_ID INTEGER DEFAULT 0 UNIQUE,FILE_TYPE INTEGER DEFAULT -1,EXTRA_INFO TEXT,FILE_MD5 TEXT)");
    }

    private void createHdThumbFileTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE hd_thumb_file (_id INTEGER PRIMARY KEY ASC AUTOINCREMENT,HD_MSG_ID INTEGER UNIQUE,HD_FILE_PATH TEXT,HD_ENCRYPT_PATH TEXT,HD_FILE_NAME TEXT,HD_FILE_SIZE INTEGER DEFAULT 0,HD_ENCRYPT_SIZE INTEGER DEFAULT 0,HD_TRANSLATE_SIZE INTEGER DEFAULT 0,HD_FID TEXT,HD_STATE INTEGER DEFAULT 0,HD_MD5 TEXT)");
    }

    private void createRawFileTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE raw_file (_id INTEGER PRIMARY KEY ASC AUTOINCREMENT,RAW_MSG_ID INTEGER UNIQUE,RAW_FILE_PATH TEXT,RAW_ENCRYPT_PATH TEXT,RAW_FILE_NAME TEXT,RAW_FILE_SIZE INTEGER DEFAULT 0,RAW_ENCRYPT_SIZE INTEGER DEFAULT 0,RAW_TRANSLATE_SIZE INTEGER DEFAULT 0,RAW_FID TEXT,RAW_STATE INTEGER DEFAULT 0,RAW_MD5 TEXT)");
    }

    private void createLocalStateMsgTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE local_state_msg (_id INTEGER PRIMARY KEY AUTOINCREMENT,SEND_TIME INTEGER,CONTENT TEXT)");
    }

    private void createDeletedMsgTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE deleted_msg (_id INTEGER PRIMARY KEY AUTOINCREMENT,MSG_ID INTEGER DEFAULT 0,SERVER_ID TEXT)");
    }

    private void createDuplicateIdTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE duplicate_id (_id INTEGER PRIMARY KEY AUTOINCREMENT,SEND_TIME TEXT,SERVER_ID TEXT)");
    }

    private void createSyncIdTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE sync_id (_id INTEGER PRIMARY KEY AUTOINCREMENT,ID_TYPE TEXT UNIQUE,ID_VALUE TEXT)");
    }

    private void createOptionsTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE options (_id INTEGER PRIMARY KEY AUTOINCREMENT,PROPERTY TEXT UNIQUE,VALUE TEXT)");
    }

    private void createAttentionMsgTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE att_msg (_id INTEGER PRIMARY KEY AUTOINCREMENT, ATT_SERVER_ID INTEGER UNIQUE, MSG_SERVER_ID INTEGER DEFAULT 0, ATT_TIME INTEGER DEFAULT 0,ATT_FROM TEXT,ATT_TO TEXT,RECEIVED INTEGER)");
        db.execSQL(AttentionMsgBuilder.ATT_SESSION_UPDATE_ON_INSERT_TRIGGER);
        db.execSQL("CREATE TRIGGER att_deleted_on_delete_trigger  BEFORE DELETE ON att_msg BEGIN  INSERT INTO deleted_msg (MSG_ID, SERVER_ID) VALUES(old._id, old.MSG_SERVER_ID); END; ");
        db.execSQL("CREATE TRIGGER att_insert_on_update_trigger  AFTER INSERT ON att_msg BEGIN  UPDATE msg_entry SET EXTRA_STATE = 1  WHERE SERVER_ID =  new.MSG_SERVER_ID; END;");
    }

    private void createGroupMsgStateTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE group_msg_state (_id INTEGER PRIMARY KEY AUTOINCREMENT, UPDATE_TYPE INTEGER DEFAULT 0, STATE_CONTENT TEXT)");
    }

    private void createGroupReadTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE group_read (_id INTEGER PRIMARY KEY AUTOINCREMENT, GROUP_SERVER_ID INTEGER DEFAULT 0, READ_LIST TEXT, UNREAD_LIST TEXT, INSERT_TIME INTEGER DEFAULT 0)");
    }

    private void createIndexInV11(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE INDEX msg_id_index ON msg_entry(_id)");
            db.execSQL("CREATE INDEX msg_server_index ON msg_entry(SERVER_ID)");
            db.execSQL("CREATE INDEX msg_tag_index ON msg_entry(SESSION_FLAG)");
            db.execSQL("CREATE INDEX msg_receiver_index ON msg_entry(RECEIVER)");
            db.execSQL("CREATE INDEX msg_sender_index ON msg_entry(SENDER)");
            db.execSQL("CREATE INDEX msg_create_index ON msg_entry(CREATE_TIME)");
            db.execSQL("CREATE INDEX session_tag_index ON session_entry(SESSION_FLAG)");
            db.execSQL("CREATE INDEX last_msg_index ON session_entry(LAST_MSG)");
            db.execSQL("CREATE INDEX file_msg_id_index ON file_msg(MSG_ID)");
            db.execSQL("CREATE INDEX hd_msg_id_index ON hd_thumb_file(HD_MSG_ID)");
            db.execSQL("CREATE INDEX raw_msg_id_index ON raw_file(RAW_MSG_ID)");
            db.execSQL("CREATE INDEX group_read_index ON group_read(GROUP_SERVER_ID)");
            db.execSQL("CREATE INDEX attention_server_index ON att_msg(ATT_SERVER_ID)");
            db.execSQL("CREATE INDEX attention_msg_index ON att_msg(MSG_SERVER_ID)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeHdRaw5To6(SQLiteDatabase db) {
        ArrayList<HdThumbFileDb> hdList = new ArrayList<HdThumbFileDb>();
        ArrayList<RawFileDb> rawList = new ArrayList<RawFileDb>();
        try (Cursor c = null;){
            String query = "SELECT msg_tmp.SENDER, file_extra_tmp.* FROM file_extra_tmp LEFT JOIN msg_tmp ON file_extra_tmp.MSG_ID = msg_tmp._id;";
            c = db.rawQuery(query, null);
            if (c.getCount() == 0) {
                return;
            }
            c.moveToPosition(-1);
            while (c.moveToNext()) {
                String rawName;
                String hdName = c.getString(c.getColumnIndex("TH_FILE_NAME"));
                if (!TextUtils.isEmpty((CharSequence)hdName)) {
                    HdThumbFileDb hd = new HdThumbFileDb();
                    hd.setHd_msg_id(c.getLong(c.getColumnIndex("MSG_ID")));
                    hd.setHd_file_path(c.getString(c.getColumnIndex("TH_FILE_URL")));
                    hd.setHd_file_name(c.getString(c.getColumnIndex("TH_FILE_NAME")));
                    hd.setHd_file_size(c.getLong(c.getColumnIndex("TH_FILE_SIZE")));
                    hd.setHd_translate_size(c.getLong(c.getColumnIndex("TH_TRANSLATE_SIZE")));
                    hd.setHd_fid(c.getString(c.getColumnIndex("TH_FID")));
                    hd.setHd_encrypt_size(c.getLong(c.getColumnIndex("TH_FILE_SIZE")));
                    hd.setHd_encrypt_path(c.getString(c.getColumnIndex("TH_FILE_URL")));
                    String sender = c.getString(c.getColumnIndex("SENDER"));
                    long size = hd.getHd_file_size();
                    long tSize = hd.getHd_translate_size();
                    if (TextUtils.equals((CharSequence)sender, (CharSequence)this.account)) {
                        if (tSize == 0L) {
                            hd.setHd_state(10);
                        } else if (tSize == size) {
                            hd.setHd_state(18);
                        } else {
                            hd.setHd_state(17);
                        }
                        hd.setHd_file_path(this.removeDat(hd.getHd_file_path()));
                        hd.setHd_file_name(this.removeDat(hd.getHd_file_name()));
                    } else if (tSize == 0L) {
                        hd.setHd_state(20);
                    } else if (tSize == size) {
                        hd.setHd_state(24);
                    } else {
                        hd.setHd_state(23);
                    }
                    hdList.add(hd);
                }
                if (TextUtils.isEmpty((CharSequence)(rawName = c.getString(c.getColumnIndex("RAW_FILE_NAME"))))) continue;
                RawFileDb raw = new RawFileDb();
                raw.setRaw_msg_id(c.getLong(c.getColumnIndex("MSG_ID")));
                raw.setRaw_file_path(c.getString(c.getColumnIndex("RAW_FILE_URL")));
                raw.setRaw_file_name(c.getString(c.getColumnIndex("RAW_FILE_NAME")));
                raw.setRaw_file_size(c.getLong(c.getColumnIndex("RAW_FILE_SIZE")));
                raw.setRaw_translate_size(c.getLong(c.getColumnIndex("RAW_TRANSLATE_SIZE")));
                raw.setRaw_fid(c.getString(c.getColumnIndex("RAW_FID")));
                raw.setRaw_encrypt_size(c.getLong(c.getColumnIndex("RAW_FILE_SIZE")));
                raw.setRaw_encrypt_path(c.getString(c.getColumnIndex("RAW_FILE_URL")));
                String sender = c.getString(c.getColumnIndex("SENDER"));
                long size = raw.getRaw_file_size();
                long tSize = raw.getRaw_translate_size();
                if (TextUtils.equals((CharSequence)sender, (CharSequence)this.account)) {
                    if (tSize == 0L) {
                        raw.setRaw_state(10);
                    } else if (tSize == size) {
                        raw.setRaw_state(18);
                    } else {
                        raw.setRaw_state(17);
                    }
                    raw.setRaw_file_path(this.removeDat(raw.getRaw_file_path()));
                    raw.setRaw_file_name(this.removeDat(raw.getRaw_file_name()));
                } else if (tSize == 0L) {
                    raw.setRaw_state(20);
                } else if (tSize == size) {
                    raw.setRaw_state(24);
                } else {
                    raw.setRaw_state(23);
                }
                rawList.add(raw);
            }
        }
        if (!hdList.isEmpty()) {
            HdThumbFileDao.getInstance().insertBatchUpgrade(db, hdList);
        }
        if (!rawList.isEmpty()) {
            RawFileDao.getInstance().insertBatchUpgrade(db, rawList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeFileMsg5To6(SQLiteDatabase db) {
        ArrayList<FileMsgDb> files = new ArrayList<FileMsgDb>();
        ArrayList<HdThumbFileDb> hdList = new ArrayList<HdThumbFileDb>();
        ArrayList<RawFileDb> rawList = new ArrayList<RawFileDb>();
        try (Cursor c = null;){
            String query = "SELECT msg_tmp.SENDER, msg_tmp.RECEIVER, file_msg_tmp.*, file_extra_tmp.RAW_FILE_URL, file_extra_tmp.TH_FILE_URL FROM file_msg_tmp LEFT JOIN msg_tmp ON msg_tmp._id = file_msg_tmp.MSG_ID LEFT JOIN file_extra_tmp ON msg_tmp._id = file_extra_tmp.MSG_ID;";
            c = db.rawQuery(query, null);
            if (c.getCount() == 0) {
                return;
            }
            c.moveToPosition(-1);
            while (c.moveToNext()) {
                FileMsgDb file = new FileMsgDb();
                file.setId(c.getLong(c.getColumnIndex("_id")));
                file.setFile_path(c.getString(c.getColumnIndex("FILE_URL")));
                file.setEncrypt_path(c.getString(c.getColumnIndex("FILE_URL")));
                file.setFile_name(c.getString(c.getColumnIndex("FILE_NAME")));
                file.setFile_size(c.getLong(c.getColumnIndex("FILE_SIZE")));
                file.setEncrypt_size(c.getLong(c.getColumnIndex("FILE_SIZE")));
                file.setTranslate_size(c.getLong(c.getColumnIndex("TRANSLATE_SIZE")));
                file.setSuffix(c.getString(c.getColumnIndex("SUFFIX")));
                file.setFid(c.getString(c.getColumnIndex("FID")));
                file.setMsg_id(c.getLong(c.getColumnIndex("MSG_ID")));
                file.setType(c.getInt(c.getColumnIndex("FILE_TYPE")));
                if (file.isVoice()) {
                    file.setExtra_info(c.getString(c.getColumnIndex("EXTRA_INFO")));
                }
                if (file.isImage()) {
                    String extraInfo = c.getString(c.getColumnIndex("EXTRA_INFO"));
                    String thPath = c.getString(c.getColumnIndex("TH_FILE_URL"));
                    String rawPath = c.getString(c.getColumnIndex("RAW_FILE_URL"));
                    if (!TextUtils.isEmpty((CharSequence)extraInfo) && TextUtils.isEmpty((CharSequence)thPath) && TextUtils.isEmpty((CharSequence)rawPath)) {
                        MsgEntryDb msg = new MsgEntryDb();
                        msg.setId(file.getMsg_id());
                        msg.setSender(c.getString(c.getColumnIndex("SENDER")));
                        msg.setReceiver(c.getString(c.getColumnIndex("RECEIVER")));
                        HdThumbFileDb hd = ModelMapper.getIns().mapHdExtraInfo(extraInfo);
                        RawFileDb raw = ModelMapper.getIns().mapRawExtraInfo(extraInfo);
                        if (hd != null) {
                            hd.setHd_msg_id(file.getMsg_id());
                            hdList.add(hd);
                        }
                        if (raw != null) {
                            raw.setRaw_msg_id(file.getMsg_id());
                            rawList.add(raw);
                        }
                    }
                    file.setExtra_info("");
                }
                String sender = c.getString(c.getColumnIndex("SENDER"));
                long size = file.getFile_size();
                long tSize = file.getTranslate_size();
                if (TextUtils.equals((CharSequence)sender, (CharSequence)this.account)) {
                    if (tSize == 0L) {
                        file.setFile_state(10);
                    } else if (tSize == size) {
                        file.setFile_state(18);
                    } else {
                        file.setFile_state(17);
                    }
                    file.setFile_path(this.removeDat(file.getFile_path()));
                    file.setFile_name(this.removeDat(file.getFile_name()));
                } else if (tSize == 0L) {
                    file.setFile_state(20);
                } else if (tSize == size) {
                    file.setFile_state(24);
                } else {
                    file.setFile_state(23);
                }
                files.add(file);
            }
        }
        if (!hdList.isEmpty()) {
            HdThumbFileDao.getInstance().insertBatchUpgrade(db, hdList);
        }
        if (!rawList.isEmpty()) {
            RawFileDao.getInstance().insertBatchUpgrade(db, rawList);
        }
        if (!files.isEmpty()) {
            FileMsgDao.getInstance().insertBatchUpgrade(db, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeMsg5To6(SQLiteDatabase db) {
        ArrayList<MessageWrapper> list = new ArrayList<MessageWrapper>();
        try (Cursor c = null;){
            String query = "SELECT msg_tmp.*, file_msg_tmp.FILE_TYPE, file_msg_tmp.FILE_URL FROM msg_tmp LEFT JOIN file_msg_tmp ON msg_tmp._id = file_msg_tmp.MSG_ID;";
            c = db.rawQuery(query, null);
            int count = c.getCount();
            if (count == 0) {
                return;
            }
            c.moveToPosition(-1);
            while (c.moveToNext()) {
                MessageWrapper wrapper = new MessageWrapper();
                MsgEntryDb msg = new MsgEntryDb();
                msg.setId(c.getLong(c.getColumnIndex("_id")));
                msg.setServer_id(c.getLong(c.getColumnIndex("SERVER_ID")));
                msg.setSender(c.getString(c.getColumnIndex("SENDER")));
                msg.setReceiver(c.getString(c.getColumnIndex("RECEIVER")));
                msg.setCard_id(c.getString(c.getColumnIndex("CARD_ID")));
                msg.setType(c.getInt(c.getColumnIndex("TYPE")));
                msg.setContent(c.getString(c.getColumnIndex("CONTENT")));
                msg.setState(c.getInt(c.getColumnIndex("STATE")));
                msg.setSession_flag(c.getString(c.getColumnIndex("SESSION_FLAG")));
                msg.setLife_time(c.getInt(c.getColumnIndex("LIFE_TIME")));
                int fileType = c.getInt(c.getColumnIndex("FILE_TYPE"));
                String filePath = c.getString(c.getColumnIndex("FILE_URL"));
                long dTime = c.getLong(c.getColumnIndex("DTIME"));
                long sTime = c.getLong(c.getColumnIndex("STIME")) / 1000000L;
                int failCode = c.getInt(c.getColumnIndex("FAIL_CODE"));
                int isNew = c.getInt(c.getColumnIndex("IS_NEW"));
                int modify = c.getInt(c.getColumnIndex("MODIFY"));
                msg.setCreate_time(dTime);
                msg.setSent_time(sTime);
                if (isNew == 0) {
                    msg.setAttr(2);
                }
                if (isNew == 1) {
                    msg.setAttr(1);
                }
                if (isNew == 2) {
                    msg.setAttr(3);
                }
                if (failCode == 703) {
                    msg.setState(-6);
                }
                if (TextUtils.equals((CharSequence)msg.getSender(), (CharSequence)this.account)) {
                    msg.setSort_time(dTime / 1000000L);
                    if (msg.isFile()) {
                        if (fileType == 1) {
                            msg.setContent(String.valueOf(1));
                        }
                        if (fileType == 3) {
                            msg.setContent(String.valueOf(3));
                        }
                    }
                } else {
                    msg.setSort_time(sTime);
                    if (msg.isFile()) {
                        if (TextUtils.isEmpty((CharSequence)filePath)) {
                            String content = msg.getContent();
                            OldFile oldFile = JsonUtils.mapGson(content, OldFile.class);
                            if (oldFile != null && !TextUtils.isEmpty((CharSequence)oldFile.getFileUrl())) {
                                wrapper = ModelMapper.getIns().mapOldFile(wrapper, msg, oldFile);
                            }
                        } else {
                            if (fileType == 1) {
                                msg.setContent(String.valueOf(1));
                            }
                            if (fileType == 3) {
                                msg.setContent(String.valueOf(3));
                            }
                        }
                    }
                }
                wrapper.setMsgEntryDb(msg);
                list.add(wrapper);
            }
        }
        if (list.isEmpty()) {
            return;
        }
        MsgEntryDao.getInstance().insertBatchUpgrade(db, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeSession5To6(SQLiteDatabase db) {
        ArrayList<SessionEntryDb> sessions = new ArrayList<SessionEntryDb>();
        try (Cursor c = null;){
            String query = "SELECT session_tmp.* FROM session_tmp;";
            c = db.rawQuery(query, null);
            if (c.getCount() == 0) {
                return;
            }
            c.moveToPosition(-1);
            while (c.moveToNext()) {
                SessionEntryDb session = new SessionEntryDb();
                session.setId(c.getLong(c.getColumnIndex("_id")));
                session.setIm_partner(c.getString(c.getColumnIndex("IM_PARTNER")));
                session.setSession_type(c.getInt(c.getColumnIndex("SESSION_TYPE")));
                session.setLast_msg(c.getLong(c.getColumnIndex("LAST_MSG")));
                session.setReminded(c.getInt(c.getColumnIndex("REMINDED")));
                session.setSession_flag(c.getString(c.getColumnIndex("SESSION_FLAG")));
                long time = c.getLong(c.getColumnIndex("DTIME"));
                session.setLast_time(time / 1000000L);
                session.setStart_time(time / 1000000L);
                sessions.add(session);
            }
        }
        if (!sessions.isEmpty()) {
            SessionEntryDao.getInstance().insertBatchUpgrade(db, sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeId5To6(SQLiteDatabase db) {
        ArrayList<DuplicateIdDb> dupList = new ArrayList<DuplicateIdDb>();
        ArrayList<SyncIdDb> syncList = new ArrayList<SyncIdDb>();
        try (Cursor c = null;){
            String query = "SELECT id_ref_tmp.* FROM id_ref_tmp;";
            c = db.rawQuery(query, null);
            if (c.getCount() == 0) {
                return;
            }
            c.moveToPosition(-1);
            while (c.moveToNext()) {
                String idType = c.getString(c.getColumnIndex("ID_TYPE"));
                String idValue = c.getString(c.getColumnIndex("ID_VALUE"));
                if (TextUtils.equals((CharSequence)"maxPreviousPullId", (CharSequence)idType)) {
                    SyncIdDb max = new SyncIdDb();
                    max.setId_type("max");
                    max.setId_value(idValue);
                    syncList.add(max);
                    continue;
                }
                if (TextUtils.equals((CharSequence)"lastPreviousPullId", (CharSequence)idType)) {
                    SyncIdDb last = new SyncIdDb();
                    last.setId_type("last");
                    last.setId_value(idValue);
                    syncList.add(last);
                    continue;
                }
                if (TextUtils.equals((CharSequence)"handledId", (CharSequence)idType)) {
                    SyncIdDb process = new SyncIdDb();
                    process.setId_type("process");
                    process.setId_value(idValue);
                    syncList.add(process);
                    continue;
                }
                if (TextUtils.equals((CharSequence)"prePullEndState", (CharSequence)idType)) {
                    SyncIdDb state = new SyncIdDb();
                    state.setId_type("state");
                    state.setId_value(idValue);
                    syncList.add(state);
                    continue;
                }
                DuplicateIdDb dup = new DuplicateIdDb();
                dup.setSend_time(idType);
                dup.setServer_id(idValue);
                dupList.add(dup);
            }
        }
        if (!dupList.isEmpty()) {
            DuplicateIdDao.getInstance().insertBatchUpgrade(db, dupList);
        }
        if (!syncList.isEmpty()) {
            SyncIdDao.getInstance().insertBatchUpgrade(db, syncList);
        }
    }

    private String removeDat(String name) {
        return ToolUtils.subString(name, "dat");
    }
}

