/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.AttentionMsgDb;
import com.xdja.imsdk.db.builder.AttentionMsgBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.UpdateArgs;
import java.util.ArrayList;
import java.util.List;

public class AttentionMsgDao
extends AbstractDao<AttentionMsgDb> {
    private static AttentionMsgDao instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttentionMsgDao getInstance() {
        if (instance != null) return instance;
        Class<AttentionMsgDao> clazz = AttentionMsgDao.class;
        synchronized (AttentionMsgDao.class) {
            instance = new AttentionMsgDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(AttentionMsgDb attentionMsgDb) {
        return this.insert(attentionMsgDb, AttentionMsgBuilder.insertSql());
    }

    public void insertBatch(List<AttentionMsgDb> list) {
        this.insertBatch(list, AttentionMsgBuilder.insertSql());
    }

    public int deleteAtt(String sql) {
        return this.delete(sql);
    }

    public void updateAtt(UpdateArgs args) {
        this.update(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRemind(String query) {
        ArrayList<Long> result = new ArrayList<Long>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                result.add(cursor.getLong(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttentionMsgDb> getAllAtts(String query) {
        ArrayList<AttentionMsgDb> result = new ArrayList<AttentionMsgDb>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                AttentionMsgDb db = new AttentionMsgDb();
                db.setMsg_server_id(cursor.getLong(0));
                db.setAtt_time(cursor.getLong(1));
                result.add(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getAttServerIds(String query) {
        ArrayList<Long> result = new ArrayList<Long>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                result.add(cursor.getLong(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return result;
    }

    @Override
    protected AttentionMsgDb readEntry(Cursor cursor, int offset) {
        AttentionMsgDb entity = new AttentionMsgDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Long.valueOf(cursor.getLong(offset + 1)), cursor.isNull(offset + 2) ? null : Long.valueOf(cursor.getLong(offset + 2)), cursor.isNull(offset + 3) ? null : Long.valueOf(cursor.getLong(offset + 3)), cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), cursor.isNull(offset + 6) ? null : Integer.valueOf(cursor.getInt(offset + 6)));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, AttentionMsgDb entity) {
        Integer received;
        String att_to;
        String att_from;
        Long att_time;
        Long msg_server_id;
        Long att_server_id;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((att_server_id = entity.getAtt_server_id()) != null) {
            stmt.bindLong(2, att_server_id.longValue());
        }
        if ((msg_server_id = entity.getMsg_server_id()) != null) {
            stmt.bindLong(3, msg_server_id.longValue());
        }
        if ((att_time = entity.getAtt_time()) != null) {
            stmt.bindLong(4, att_time.longValue());
        }
        if ((att_from = entity.getAtt_from()) != null) {
            stmt.bindString(5, att_from);
        }
        if ((att_to = entity.getAtt_to()) != null) {
            stmt.bindString(6, att_to);
        }
        if ((received = entity.getReceived()) != null) {
            stmt.bindLong(7, (long)received.intValue());
        }
    }
}

