/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.db.DbHelper;
import com.xdja.imsdk.db.bean.DuplicateIdDb;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.HdThumbFileDb;
import com.xdja.imsdk.db.bean.LocalStateMsgDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.builder.MsgEntryBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.dao.DuplicateIdDao;
import com.xdja.imsdk.db.dao.FileMsgDao;
import com.xdja.imsdk.db.dao.HdThumbFileDao;
import com.xdja.imsdk.db.dao.LocalStateMsgDao;
import com.xdja.imsdk.db.dao.RawFileDao;
import com.xdja.imsdk.db.dao.SessionEntryDao;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MsgEntryDao
extends AbstractDao<MsgEntryDb> {
    private static MsgEntryDao instance;

    private MsgEntryDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MsgEntryDao getInstance() {
        if (instance != null) return instance;
        Class<MsgEntryDao> clazz = MsgEntryDao.class;
        synchronized (MsgEntryDao.class) {
            if (instance != null) return instance;
            instance = new MsgEntryDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(MessageWrapper wrapper) {
        long rowId = 0L;
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return rowId;
        }
        Object object = DB_LOCK;
        synchronized (object) {
            SQLiteDatabase db = DbHelper.getInstance().getDatabase();
            db.beginTransaction();
            try {
                rowId = this.insert(db, wrapper);
                db.setTransactionSuccessful();
            }
            catch (SQLException e) {
                long l;
                try {
                    e.printStackTrace();
                    l = -5L;
                }
                catch (Throwable throwable) {
                    try {
                        db.endTransaction();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        Logger.getLogger().e("database already closed !!!");
                    }
                }
                db.endTransaction();
                return l;
            }
            db.endTransaction();
            return rowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBatchUpgrade(SQLiteDatabase db, List<MessageWrapper> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                db.beginTransaction();
                try {
                    for (MessageWrapper wrapper : wrappers) {
                        this.insert(db, wrapper);
                    }
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBatch(List<SessionWrapper> sessions, List<MessageWrapper> messages, List<DuplicateIdDb> dupIds, List<LocalStateMsgDb> bombs, List<LocalStateMsgDb> dupes, List<LocalStateMsgDb> recs) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    SessionEntryDao.getInstance().insertBatch(db, sessions);
                    this.insertBatch(db, messages);
                    DuplicateIdDao.getInstance().insertBatch(db, dupIds);
                    LocalStateMsgDao.getInstance().insertBatch(db, bombs);
                    LocalStateMsgDao.getInstance().insertBatch(db, dupes);
                    LocalStateMsgDao.getInstance().insertBatch(db, recs);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    private void insertBatch(SQLiteDatabase db, List<MessageWrapper> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (MessageWrapper message : messages) {
            this.insert(db, message);
        }
    }

    private long insert(SQLiteDatabase db, MessageWrapper wrapper) {
        long msgId = this.insert(db, wrapper.getMsgEntryDb());
        FileMsgDb fileMsgDb = wrapper.getFileMsgDb();
        if (wrapper.isFile() && fileMsgDb != null) {
            RawFileDb rawDb;
            fileMsgDb.setMsg_id(msgId);
            FileMsgDao.getInstance().insert(db, fileMsgDb);
            HdThumbFileDb hdDb = wrapper.getHdThumbFileDb();
            if (hdDb != null) {
                hdDb.setHd_msg_id(msgId);
                HdThumbFileDao.getInstance().insert(db, hdDb);
            }
            if ((rawDb = wrapper.getRawFileDb()) != null) {
                rawDb.setRaw_msg_id(msgId);
                RawFileDao.getInstance().insert(db, rawDb);
            }
        } else if (wrapper.isWeb() && fileMsgDb != null) {
            fileMsgDb.setMsg_id(msgId);
            FileMsgDao.getInstance().insert(db, fileMsgDb);
        }
        return msgId;
    }

    private long insert(SQLiteDatabase db, MsgEntryDb msg) {
        return this.insert(db, msg, MsgEntryBuilder.insertSql());
    }

    public int deleteMsg(String sql) {
        return this.delete(sql);
    }

    public void updateM(UpdateArgs args) {
        this.update(args);
    }

    public void updateMBatch(List<UpdateArgs> argsList) {
        this.updateBatch(MsgEntryBuilder.updateStateSql(), argsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMFState(UpdateArgs message, UpdateArgs file) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    this.update(db, message);
                    this.update(db, file);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEF(UpdateArgs msg, UpdateArgs file, UpdateArgs hd, UpdateArgs raw) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    this.update(db, msg);
                    this.update(db, file);
                    this.update(db, hd);
                    this.update(db, raw);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndSave(UpdateArgs args, LocalStateMsgDb lState) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    this.update(db, args);
                    LocalStateMsgDao.getInstance().insert(db, lState);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndSaveBatch(List<UpdateArgs> args, List<LocalStateMsgDb> lStates) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    this.updateBatch(db, MsgEntryBuilder.updateMsgStateSql(), args);
                    LocalStateMsgDao.getInstance().insertBatch(db, lStates);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndSaveReadBatch(List<UpdateArgs> args, List<LocalStateMsgDb> lStates) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    this.updateBatch(db, MsgEntryBuilder.updateMsgStateReadSql(), args);
                    LocalStateMsgDao.getInstance().insertBatch(db, lStates);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    Logger.getLogger().e("database exception !!!");
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageWrapper> getMessages(String query, OptType.MQuery type) {
        ArrayList<MessageWrapper> messages = new ArrayList<MessageWrapper>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                if (type == OptType.MQuery.NO) {
                    MsgEntryDb msgEntryDb = this.readEntry(cursor, 0);
                    MessageWrapper wrapper = new MessageWrapper(msgEntryDb);
                    messages.add(wrapper);
                    continue;
                }
                messages.add(this.loadMessageCursor(cursor, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageWrapper> getDup(String query) {
        ArrayList<MessageWrapper> messages = new ArrayList<MessageWrapper>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                messages.add(this.loadDupCursor(cursor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageWrapper getMessage(String query, OptType.MQuery type) {
        MessageWrapper message = new MessageWrapper();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                if (type == OptType.MQuery.NO) {
                    MsgEntryDb msgEntryDb = this.readEntry(cursor, 0);
                    message.setMsgEntryDb(msgEntryDb);
                    continue;
                }
                message = this.loadMessageCursor(cursor, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageWrapper getMessage(String query, ImSdkFileConstant.FileType type) {
        MessageWrapper message = new MessageWrapper();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                message = this.loadFileCursor(cursor, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getIds(String query) {
        ArrayList<Long> result = new ArrayList<Long>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                result.add(cursor.getLong(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdByServerId(String query) {
        long id = 0L;
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                id = cursor.getLong(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStrictlyCount(String query) {
        int id = 0;
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                id = cursor.getInt(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Integer> getStates(String query) {
        HashMap<Long, Integer> states = new HashMap<Long, Integer>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                states.put(cursor.getLong(0), cursor.getInt(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageWrapper> getSent(String query) {
        ArrayList<MessageWrapper> messages = new ArrayList<MessageWrapper>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                MsgEntryDb msg = new MsgEntryDb();
                msg.setId(cursor.getLong(0));
                msg.setCreate_time(cursor.getLong(1));
                msg.setReceiver(cursor.getString(2));
                msg.setType(cursor.getInt(3));
                MessageWrapper wrapper = new MessageWrapper(msg);
                messages.add(wrapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MsgEntryDb> getStrictlyMsg(String query) {
        ArrayList<MsgEntryDb> messages = new ArrayList<MsgEntryDb>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                MsgEntryDb msg = new MsgEntryDb();
                msg.setId(cursor.getLong(0));
                msg.setServer_id(cursor.getLong(1));
                msg.setType(cursor.getInt(2));
                msg.setState(cursor.getInt(3));
                msg.setSession_flag(cursor.getString(4));
                messages.add(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCachePath(String query) {
        Logger.getLogger().d("ImSdk getCache query start... ");
        long time = System.currentTimeMillis();
        ArrayList<String> paths = new ArrayList<String>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                for (int i = 0; i < 6; ++i) {
                    String path = cursor.getString(i);
                    if (TextUtils.isEmpty((CharSequence)path)) continue;
                    paths.add(path);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        Logger.getLogger().d("ImSdk getCache query end... ==> " + (System.currentTimeMillis() - time));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> getReceiptInfo(String query) {
        HashMap<Long, String> info = new HashMap<Long, String>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                info.put(cursor.getLong(0), cursor.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return info;
    }

    private MessageWrapper loadMessageCursor(Cursor cursor, OptType.MQuery type) {
        MessageWrapper wrapper = new MessageWrapper();
        MsgEntryDb m = new MsgEntryDb();
        m.setId(cursor.getLong(cursor.getColumnIndex("JOIN_ID")));
        m.setServer_id(cursor.getLong(cursor.getColumnIndex("SERVER_ID")));
        m.setCard_id(cursor.getString(cursor.getColumnIndex("CARD_ID")));
        m.setSender(cursor.getString(cursor.getColumnIndex("SENDER")));
        m.setReceiver(cursor.getString(cursor.getColumnIndex("RECEIVER")));
        m.setContent(cursor.getString(cursor.getColumnIndex("CONTENT")));
        m.setState(cursor.getInt(cursor.getColumnIndex("STATE")));
        m.setType(cursor.getInt(cursor.getColumnIndex("TYPE")));
        m.setSession_flag(cursor.getString(cursor.getColumnIndex("SESSION_FLAG")));
        m.setLife_time(cursor.getInt(cursor.getColumnIndex("LIFE_TIME")));
        m.setAttr(cursor.getInt(cursor.getColumnIndex("ATTR")));
        m.setSort_time(cursor.getLong(cursor.getColumnIndex("SORT_TIME")));
        m.setCreate_time(cursor.getLong(cursor.getColumnIndex("CREATE_TIME")));
        m.setSent_time(cursor.getLong(cursor.getColumnIndex("SENT_TIME")));
        m.setMsg_extra(cursor.getString(cursor.getColumnIndex("MSG_EXTRA")));
        m.setExtra_state(cursor.getInt(cursor.getColumnIndex("EXTRA_STATE")));
        wrapper.setMsgEntryDb(m);
        if (m.isFile() || m.isWeb()) {
            long hdId;
            long rawId;
            FileMsgDb f = new FileMsgDb();
            f.setId(cursor.getLong(cursor.getColumnIndex("F_JOIN_ID")));
            f.setFile_path(cursor.getString(cursor.getColumnIndex("FILE_PATH")));
            f.setEncrypt_path(cursor.getString(cursor.getColumnIndex("ENCRYPT_PATH")));
            f.setFile_name(cursor.getString(cursor.getColumnIndex("FILE_NAME")));
            f.setMsg_id(cursor.getLong(cursor.getColumnIndex("MSG_ID")));
            f.setFile_size(cursor.getLong(cursor.getColumnIndex("FILE_SIZE")));
            f.setTranslate_size(cursor.getLong(cursor.getColumnIndex("TRANSLATE_SIZE")));
            f.setEncrypt_size(cursor.getLong(cursor.getColumnIndex("ENCRYPT_SIZE")));
            f.setFid(cursor.getString(cursor.getColumnIndex("FID")));
            f.setFile_state(cursor.getInt(cursor.getColumnIndex("FILE_STATE")));
            f.setType(cursor.getInt(cursor.getColumnIndex("FILE_TYPE")));
            f.setSuffix(cursor.getString(cursor.getColumnIndex("SUFFIX")));
            f.setExtra_info(cursor.getString(cursor.getColumnIndex("EXTRA_INFO")));
            f.setFile_md5(cursor.getString(cursor.getColumnIndex("FILE_MD5")));
            wrapper.setFileMsgDb(f);
            if (type == OptType.MQuery.SHOW) {
                return wrapper;
            }
            if ((type == OptType.MQuery.RAW || type == OptType.MQuery.ALL) && (rawId = cursor.getLong(cursor.getColumnIndex("RAW_JOIN_ID"))) > 0L) {
                RawFileDb raw = new RawFileDb();
                raw.setId(rawId);
                raw.setRaw_file_path(cursor.getString(cursor.getColumnIndex("RAW_FILE_PATH")));
                raw.setRaw_encrypt_path(cursor.getString(cursor.getColumnIndex("RAW_ENCRYPT_PATH")));
                raw.setRaw_file_name(cursor.getString(cursor.getColumnIndex("RAW_FILE_NAME")));
                raw.setRaw_msg_id(cursor.getLong(cursor.getColumnIndex("RAW_MSG_ID")));
                raw.setRaw_file_size(cursor.getLong(cursor.getColumnIndex("RAW_FILE_SIZE")));
                raw.setRaw_translate_size(cursor.getLong(cursor.getColumnIndex("RAW_TRANSLATE_SIZE")));
                raw.setRaw_encrypt_size(cursor.getLong(cursor.getColumnIndex("RAW_ENCRYPT_SIZE")));
                raw.setRaw_fid(cursor.getString(cursor.getColumnIndex("RAW_FID")));
                raw.setRaw_state(cursor.getInt(cursor.getColumnIndex("RAW_STATE")));
                raw.setRaw_md5(cursor.getString(cursor.getColumnIndex("RAW_MD5")));
                wrapper.setRawFileDb(raw);
                if (type == OptType.MQuery.RAW) {
                    return wrapper;
                }
            }
            if (type == OptType.MQuery.ALL && (hdId = cursor.getLong(cursor.getColumnIndex("HD_JOIN_ID"))) > 0L) {
                HdThumbFileDb hd = new HdThumbFileDb();
                hd.setId(hdId);
                hd.setHd_file_path(cursor.getString(cursor.getColumnIndex("HD_FILE_PATH")));
                hd.setHd_encrypt_path(cursor.getString(cursor.getColumnIndex("HD_ENCRYPT_PATH")));
                hd.setHd_file_name(cursor.getString(cursor.getColumnIndex("HD_FILE_NAME")));
                hd.setHd_msg_id(cursor.getLong(cursor.getColumnIndex("HD_MSG_ID")));
                hd.setHd_file_size(cursor.getLong(cursor.getColumnIndex("HD_FILE_SIZE")));
                hd.setHd_translate_size(cursor.getLong(cursor.getColumnIndex("HD_TRANSLATE_SIZE")));
                hd.setHd_encrypt_size(cursor.getLong(cursor.getColumnIndex("HD_ENCRYPT_SIZE")));
                hd.setHd_fid(cursor.getString(cursor.getColumnIndex("HD_FID")));
                hd.setHd_state(cursor.getInt(cursor.getColumnIndex("HD_STATE")));
                hd.setHd_md5(cursor.getString(cursor.getColumnIndex("HD_MD5")));
                wrapper.setHdThumbFileDb(hd);
            }
        }
        return wrapper;
    }

    private MessageWrapper loadFileCursor(Cursor cursor, ImSdkFileConstant.FileType type) {
        MessageWrapper wrapper = new MessageWrapper();
        MsgEntryDb m = new MsgEntryDb();
        m.setId(cursor.getLong(cursor.getColumnIndex("JOIN_ID")));
        m.setType(cursor.getInt(cursor.getColumnIndex("TYPE")));
        wrapper.setMsgEntryDb(m);
        switch (type) {
            case IS_HD: {
                if (!m.isFile()) break;
                FileMsgDb f = new FileMsgDb();
                f.setType(cursor.getInt(cursor.getColumnIndex("FILE_TYPE")));
                wrapper.setFileMsgDb(f);
                long hdId = cursor.getLong(cursor.getColumnIndex("_id"));
                if (hdId <= 0L) break;
                HdThumbFileDb hd = new HdThumbFileDb();
                hd.setId(hdId);
                hd.setHd_file_path(cursor.getString(cursor.getColumnIndex("HD_FILE_PATH")));
                hd.setHd_encrypt_path(cursor.getString(cursor.getColumnIndex("HD_ENCRYPT_PATH")));
                hd.setHd_file_name(cursor.getString(cursor.getColumnIndex("HD_FILE_NAME")));
                hd.setHd_msg_id(cursor.getLong(cursor.getColumnIndex("HD_MSG_ID")));
                hd.setHd_file_size(cursor.getLong(cursor.getColumnIndex("HD_FILE_SIZE")));
                hd.setHd_translate_size(cursor.getLong(cursor.getColumnIndex("HD_TRANSLATE_SIZE")));
                hd.setHd_encrypt_size(cursor.getLong(cursor.getColumnIndex("HD_ENCRYPT_SIZE")));
                hd.setHd_fid(cursor.getString(cursor.getColumnIndex("HD_FID")));
                hd.setHd_state(cursor.getInt(cursor.getColumnIndex("HD_STATE")));
                hd.setHd_md5(cursor.getString(cursor.getColumnIndex("HD_MD5")));
                wrapper.setHdThumbFileDb(hd);
                break;
            }
            case IS_SHOW: {
                if (!m.isFile() && !m.isWeb()) break;
                FileMsgDb f = new FileMsgDb();
                f.setId(cursor.getLong(cursor.getColumnIndex("_id")));
                f.setFile_path(cursor.getString(cursor.getColumnIndex("FILE_PATH")));
                f.setEncrypt_path(cursor.getString(cursor.getColumnIndex("ENCRYPT_PATH")));
                f.setFile_name(cursor.getString(cursor.getColumnIndex("FILE_NAME")));
                f.setMsg_id(cursor.getLong(cursor.getColumnIndex("MSG_ID")));
                f.setFile_size(cursor.getLong(cursor.getColumnIndex("FILE_SIZE")));
                f.setTranslate_size(cursor.getLong(cursor.getColumnIndex("TRANSLATE_SIZE")));
                f.setEncrypt_size(cursor.getLong(cursor.getColumnIndex("ENCRYPT_SIZE")));
                f.setFid(cursor.getString(cursor.getColumnIndex("FID")));
                f.setFile_state(cursor.getInt(cursor.getColumnIndex("FILE_STATE")));
                f.setType(cursor.getInt(cursor.getColumnIndex("FILE_TYPE")));
                f.setSuffix(cursor.getString(cursor.getColumnIndex("SUFFIX")));
                f.setExtra_info(cursor.getString(cursor.getColumnIndex("EXTRA_INFO")));
                f.setFile_state(cursor.getInt(cursor.getColumnIndex("FILE_STATE")));
                f.setFile_md5(cursor.getString(cursor.getColumnIndex("FILE_MD5")));
                wrapper.setFileMsgDb(f);
                break;
            }
            case IS_RAW: {
                if (!m.isFile()) break;
                FileMsgDb f = new FileMsgDb();
                f.setType(cursor.getInt(cursor.getColumnIndex("FILE_TYPE")));
                wrapper.setFileMsgDb(f);
                long rawId = cursor.getLong(cursor.getColumnIndex("_id"));
                if (rawId <= 0L) break;
                RawFileDb raw = new RawFileDb();
                raw.setId(rawId);
                raw.setRaw_file_path(cursor.getString(cursor.getColumnIndex("RAW_FILE_PATH")));
                raw.setRaw_encrypt_path(cursor.getString(cursor.getColumnIndex("RAW_ENCRYPT_PATH")));
                raw.setRaw_file_name(cursor.getString(cursor.getColumnIndex("RAW_FILE_NAME")));
                raw.setRaw_msg_id(cursor.getLong(cursor.getColumnIndex("RAW_MSG_ID")));
                raw.setRaw_file_size(cursor.getLong(cursor.getColumnIndex("RAW_FILE_SIZE")));
                raw.setRaw_translate_size(cursor.getLong(cursor.getColumnIndex("RAW_TRANSLATE_SIZE")));
                raw.setRaw_encrypt_size(cursor.getLong(cursor.getColumnIndex("RAW_ENCRYPT_SIZE")));
                raw.setRaw_fid(cursor.getString(cursor.getColumnIndex("RAW_FID")));
                raw.setRaw_state(cursor.getInt(cursor.getColumnIndex("RAW_STATE")));
                raw.setRaw_md5(cursor.getString(cursor.getColumnIndex("RAW_MD5")));
                wrapper.setRawFileDb(raw);
                break;
            }
        }
        return wrapper;
    }

    private MessageWrapper loadDupCursor(Cursor cursor) {
        MessageWrapper wrapper = new MessageWrapper();
        MsgEntryDb m = new MsgEntryDb();
        m.setCreate_time(cursor.getLong(cursor.getColumnIndex("CREATE_TIME")));
        m.setSender(cursor.getString(cursor.getColumnIndex("SENDER")));
        m.setReceiver(cursor.getString(cursor.getColumnIndex("RECEIVER")));
        m.setType(cursor.getInt(cursor.getColumnIndex("TYPE")));
        m.setState(cursor.getInt(cursor.getColumnIndex("STATE")));
        wrapper.setMsgEntryDb(m);
        return wrapper;
    }

    @Override
    protected MsgEntryDb readEntry(Cursor cursor, int offset) {
        MsgEntryDb entry = new MsgEntryDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Long.valueOf(cursor.getLong(offset + 1)), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), cursor.isNull(offset + 5) ? null : Integer.valueOf(cursor.getInt(offset + 5)), cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), cursor.isNull(offset + 7) ? null : Integer.valueOf(cursor.getInt(offset + 7)), cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), cursor.isNull(offset + 9) ? null : Integer.valueOf(cursor.getInt(offset + 9)), cursor.isNull(offset + 10) ? null : Integer.valueOf(cursor.getInt(offset + 10)), cursor.isNull(offset + 11) ? null : Long.valueOf(cursor.getLong(offset + 11)), cursor.isNull(offset + 12) ? null : Long.valueOf(cursor.getLong(offset + 12)), cursor.isNull(offset + 13) ? null : Long.valueOf(cursor.getLong(offset + 13)), cursor.isNull(offset + 14) ? null : cursor.getString(offset + 14), cursor.isNull(offset + 15) ? null : Integer.valueOf(cursor.getInt(offset + 15)));
        return entry;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, MsgEntryDb entity) {
        Integer extra_state;
        String msg_extra;
        Long sort_time;
        Long sent_time;
        Long create_time;
        Integer life_time;
        Integer attr;
        String session_flag;
        Integer state;
        String content;
        Integer type;
        String card_id;
        String receiver;
        String sender;
        Long server_id;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((server_id = entity.getServer_id()) != null) {
            stmt.bindLong(2, server_id.longValue());
        }
        if ((sender = entity.getSender()) != null) {
            stmt.bindString(3, sender);
        }
        if ((receiver = entity.getReceiver()) != null) {
            stmt.bindString(4, receiver);
        }
        if ((card_id = entity.getCard_id()) != null) {
            stmt.bindString(5, card_id);
        }
        if ((type = entity.getType()) != null) {
            stmt.bindLong(6, (long)type.intValue());
        }
        if ((content = entity.getContent()) != null) {
            stmt.bindString(7, content);
        }
        if ((state = entity.getState()) != null) {
            stmt.bindLong(8, (long)state.intValue());
        }
        if ((session_flag = entity.getSession_flag()) != null) {
            stmt.bindString(9, session_flag);
        }
        if ((attr = entity.getAttr()) != null) {
            stmt.bindLong(10, (long)attr.intValue());
        }
        if ((life_time = entity.getLife_time()) != null) {
            stmt.bindLong(11, (long)life_time.intValue());
        }
        if ((create_time = entity.getCreate_time()) != null) {
            stmt.bindLong(12, create_time.longValue());
        }
        if ((sent_time = entity.getSent_time()) != null) {
            stmt.bindLong(13, sent_time.longValue());
        }
        if ((sort_time = entity.getSort_time()) != null) {
            stmt.bindLong(14, sort_time.longValue());
        }
        if ((msg_extra = entity.getMsg_extra()) != null) {
            stmt.bindString(15, msg_extra);
        }
        if ((extra_state = entity.getExtra_state()) != null) {
            stmt.bindLong(16, (long)extra_state.intValue());
        }
    }
}

