/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.body;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.constant.OkHttpConstants;
import com.xdja.imsdk.logger.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class ChunkProgressRequestBody
extends RequestBody {
    private static final int BUFFER_LENGTH = 2048;
    @NonNull
    private File mFile;
    private long mChunk;
    @NonNull
    private final ProgressListener mProgressListener;

    public ChunkProgressRequestBody(@NonNull File file, long chunk, @NonNull ProgressListener progressListener) {
        this.mFile = file;
        this.mChunk = chunk;
        this.mProgressListener = progressListener;
    }

    public MediaType contentType() {
        return OkHttpConstants.MEDIA_TYPE_FILE;
    }

    public long contentLength() {
        long available = this.mFile.length() - this.mChunk * 0x500000L;
        if (available < 0L) {
            Logger.getLogger().e("Content length error: fileLength=" + this.mFile.length() + ", chunk=" + this.mChunk);
        }
        return Math.min(available, 0x500000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        long length = this.mFile.length();
        if (length == 0L) {
            FileNotFoundException exception = new FileNotFoundException(this.mFile + " does not exist or length is 0");
            Logger.getLogger().e("Upload file error: " + exception);
            throw exception;
        }
        RandomAccessFile accessFile = null;
        int currentProgress = 0;
        long offset = this.mChunk * 0x500000L;
        int blocks = (int)Math.ceil((double)this.contentLength() * 1.0 / 2048.0);
        byte[] buffer = new byte[2048];
        try {
            accessFile = new RandomAccessFile(this.mFile, "r");
            accessFile.seek(offset);
            for (int i = 0; i < blocks; ++i) {
                int size = accessFile.read(buffer);
                sink.write(buffer, 0, size);
                long byteCount = offset + (long)(i * 2048) + (long)size;
                int progress = (int)(byteCount * 100L / length);
                if (progress <= currentProgress) continue;
                this.mProgressListener.update(byteCount, progress, byteCount == length);
                currentProgress = progress;
            }
        }
        finally {
            if (accessFile != null) {
                accessFile.close();
            }
        }
    }
}

