/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.body;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public final class ProgressResponseBody
extends ResponseBody {
    @NonNull
    private final ResponseBody mResponseBody;
    private long mOffset;
    @NonNull
    private final ProgressListener mProgressListener;
    private BufferedSource mBufferedSource;

    public ProgressResponseBody(@NonNull ResponseBody responseBody, long offset, @NonNull ProgressListener progressListener) {
        this.mResponseBody = responseBody;
        this.mOffset = offset;
        this.mProgressListener = progressListener;
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            long currentProgress;
            {
                this.totalBytesRead = ProgressResponseBody.this.mOffset;
                this.currentProgress = 0L;
            }

            public long read(@NonNull Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                int progress = (int)(this.totalBytesRead * 100L / (ProgressResponseBody.this.mResponseBody.contentLength() + ProgressResponseBody.this.mOffset));
                if ((long)progress > this.currentProgress) {
                    ProgressResponseBody.this.mProgressListener.update(this.totalBytesRead, progress, progress == 100);
                    this.currentProgress = progress;
                }
                return bytesRead;
            }
        };
    }
}

