/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.bean.GroupMsgStateDb;
import com.xdja.imsdk.db.bean.GroupReadDb;
import com.xdja.imsdk.db.helper.DelArgs;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.callback.IPostCallback;
import com.xdja.imsdk.http.receipt.MssParser;
import com.xdja.imsdk.http.receipt.request.MssBatchUpdateRequest;
import com.xdja.imsdk.http.receipt.request.MssGetRequest;
import com.xdja.imsdk.http.receipt.request.param.MssBaseInfo;
import com.xdja.imsdk.http.receipt.result.MssBatchResult;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.build.HttpManagerFactory;
import com.xdja.imsdk.manager.build.RequestFactory;
import com.xdja.imsdk.util.JsonUtil;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImMssManager {
    private static ImMssManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImMssManager getInstance() {
        Class<ImMssManager> clazz = ImMssManager.class;
        synchronized (ImMssManager.class) {
            if (instance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, List<String>> getReceiptList(long id) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Map<Long, String> info = ImSdkDbUtils.queryReceiptInfo(OptHelper.getIns().getReceipt(id));
        if (info.size() == 0) {
            return result;
        }
        Set<Long> serverIds = info.keySet();
        long serverId = 0L;
        String groupId = "";
        for (Long i : serverIds) {
            serverId = i;
            groupId = info.get(i);
        }
        Map<String, String> receipts = ImSdkDbUtils.queryReceiptList(OptHelper.getIns().getReadQuery(serverId));
        try {
            List read = (List)JsonUtils.getGson().fromJson(receipts.get("read"), new TypeToken<List<String>>(){}.getType());
            List unread = (List)JsonUtils.getGson().fromJson(receipts.get("unread"), new TypeToken<List<String>>(){}.getType());
            if (read != null) {
                result.put("read", read);
            }
            if (unread != null) {
                result.put("unread", unread);
            }
        }
        catch (Exception e) {
            Logger.getLogger().d("ImSdk parse error:" + e);
        }
        RequestInfo requestInfo = RequestFactory.buildMssRead(groupId, String.valueOf(serverId));
        this.startRequest(requestInfo);
        return result;
    }

    public int changeGroupRead(String account, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        Map<Long, String> receiptInfo = ImSdkDbUtils.queryReceiptInfo(OptHelper.getIns().getChange(ids));
        if (receiptInfo.size() == 0) {
            return 0;
        }
        MssBatchUpdateRequest request = new MssBatchUpdateRequest();
        request.setAccountid(account);
        ArrayList<MssBaseInfo> infoList = new ArrayList<MssBaseInfo>();
        Set<Long> serverIds = receiptInfo.keySet();
        ArrayList<Long> attIds = new ArrayList<Long>();
        for (Long i : serverIds) {
            MssBaseInfo in = new MssBaseInfo();
            in.setGroupid(receiptInfo.get(i));
            in.setMessageid(String.valueOf(i));
            infoList.add(in);
            attIds.add(i);
        }
        DelArgs delArgs = OptHelper.getIns().getAttDel(attIds);
        ImSdkDbUtils.delete(delArgs);
        request.setKeys(JsonUtils.getGson().toJson(infoList));
        GroupMsgStateDb groupMsgStateDb = new GroupMsgStateDb();
        groupMsgStateDb.setState_content(JsonUtil.toJson(request));
        groupMsgStateDb.setUpdate_type(1);
        long id = ImSdkDbUtils.saveGroupState(groupMsgStateDb);
        RequestInfo info = RequestFactory.buildMssReceipts(id, request);
        this.startRequest(info);
        return 0;
    }

    public void sendHistoryGroupState() {
        List<GroupMsgStateDb> groups = ImSdkDbUtils.queryGroupStates();
        if (groups == null || groups.isEmpty()) {
            return;
        }
        for (GroupMsgStateDb group : groups) {
            MssBatchUpdateRequest request = JsonUtil.mapGson(group.getState_content(), MssBatchUpdateRequest.class);
            if (request == null) continue;
            RequestInfo info = RequestFactory.buildMssReceipts(group.getId(), request);
            this.startRequest(info);
        }
    }

    private void startRequest(RequestInfo requestInfo) {
        HttpManagerFactory.getHttpManager().postAsync(requestInfo, new IPostCallback(){

            @Override
            public void onSuccess(String result, RequestInfo requestInfo) {
                Logger.getLogger().d("ImSdk postRequest onSuccess " + requestInfo + ", result " + result);
                ImMssManager.this.parseSuccess(result, requestInfo);
            }

            @Override
            public void onFailed(int code, RequestInfo requestInfo) {
                ImMssManager.this.parseFail(code, requestInfo);
            }
        });
    }

    private void processBatchState(String result, RequestInfo requestInfo) {
        MssBatchResult updateResult = MssParser.parseBatchUpdateResult(result);
        if (updateResult != null && updateResult.success()) {
            ImSdkDbUtils.delete(OptHelper.getIns().getGroupStateDel(requestInfo.getTag()));
        } else {
            Logger.getLogger().i("error: " + result);
            ImSdkDbUtils.delete(OptHelper.getIns().getGroupStateDel(requestInfo.getTag()));
        }
    }

    private void processRead(String result, RequestInfo requestInfo) {
        MssGetRequest request = MssParser.parseReadRequest(requestInfo.getJson());
        if (request == null) {
            return;
        }
        String serverId = request.getMessageid();
        Map<String, String> receipts = ImSdkDbUtils.queryReceiptList(OptHelper.getIns().getReadQuery(Long.valueOf(serverId)));
        Map<String, Integer> newValue = MssParser.parseReadResult(result);
        if (newValue == null) {
            return;
        }
        ArrayList<String> readList = new ArrayList<String>();
        ArrayList<String> unreadList = new ArrayList<String>();
        Set<Map.Entry<String, Integer>> entrySet = newValue.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            if (entry.getValue() == 3) {
                readList.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == 0) {
                unreadList.add(entry.getKey());
                continue;
            }
            Logger.getLogger().e("ImSdk get receipt error:" + entry);
        }
        HashMap<String, List<String>> requestResult = new HashMap<String, List<String>>();
        requestResult.put("read", readList);
        requestResult.put("unread", unreadList);
        if (receipts.isEmpty()) {
            GroupReadDb readDb = new GroupReadDb();
            readDb.setGroup_server_id(Long.valueOf(serverId));
            readDb.setRead_list(((Object)readList).toString());
            readDb.setUnread_list(((Object)unreadList).toString());
            readDb.setInsert_time(ImSdkConfigManager.getInstance().getCurrentMillis());
            ImSdkDbUtils.saveGroupRead(readDb);
            long id = ImSdkDbUtils.queryIdByServerId(OptHelper.getIns().getIdByServerId(serverId));
            ImSdkCallbackManager.getInstance().callReceipts(id, requestResult);
        } else {
            long id = ImSdkDbUtils.queryIdByServerId(OptHelper.getIns().getIdByServerId(serverId));
            ImSdkDbUtils.update(OptHelper.getIns().getGroupReadUpdate(serverId, ((Object)readList).toString(), ((Object)unreadList).toString()));
            ImSdkCallbackManager.getInstance().callReceipts(id, requestResult);
        }
    }

    private boolean compareAccounts(List<String> oldAccounts, List<String> newAccounts) {
        if (oldAccounts != null && newAccounts != null) {
            boolean result = false;
            block0: for (String oldAccount : oldAccounts) {
                for (String newAccount : newAccounts) {
                    if (!ToolUtils.equals(oldAccount, newAccount)) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        return false;
    }

    private void parseSuccess(String result, RequestInfo requestInfo) {
        if (requestInfo == null) {
            return;
        }
        switch (requestInfo.getType()) {
            case READ: {
                this.processRead(result, requestInfo);
                break;
            }
            case RECEIPT: {
                break;
            }
            case RECEIPTS: {
                this.processBatchState(result, requestInfo);
                break;
            }
        }
    }

    private void parseFail(int code, RequestInfo requestInfo) {
        Logger.getLogger().e("ImSdk request error: " + code + ", request info: " + requestInfo);
        if (code == 50101) {
            String ticket = null;
            if (requestInfo != null && requestInfo.getHeaders() != null) {
                ticket = requestInfo.getHeaders().get("ticket");
            }
            ImSdkCallbackManager.getInstance().callState(code, ticket);
        }
    }

    private static class Factory {
        private Factory() {
        }

        static ImMssManager getInstance() {
            return new ImMssManager();
        }
    }
}

