/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.reflect.TypeToken;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.http.bean.Condition;
import com.xdja.imsdk.http.bean.Ext;
import com.xdja.imsdk.http.bean.ImRequestBeanN;
import com.xdja.imsdk.http.bean.ImResultErrorBeanN;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.http.callback.IHttpCallback;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.result.FailStateResult;
import com.xdja.imsdk.http.result.LoginResult;
import com.xdja.imsdk.http.result.NormalResult;
import com.xdja.imsdk.http.result.ResultValue;
import com.xdja.imsdk.http.result.StateResultN;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.HttpManager;
import com.xdja.imsdk.manager.ImMssManager;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.build.HttpManagerFactory;
import com.xdja.imsdk.manager.callback.NetCallback;
import com.xdja.imsdk.manager.callback.ResultCallback;
import com.xdja.imsdk.manager.msg.MsgManagerHelper;
import com.xdja.imsdk.manager.msg.MsgParamGen;
import com.xdja.imsdk.manager.msg.PullAccord;
import com.xdja.imsdk.manager.msg.SyncAccord;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class ImSyncManager {
    private static final int SYNC_EXPIRY_TIME = 0x6DDD00;
    private static ImSyncManager imSyncManager;
    private long time = 0L;
    private String account;
    private ResultCallback callback;
    private NetCallback net;
    private Condition condition = new Condition(0L, 0L);
    private ExecutorService syncPool;
    private SyncAccord syncAccord;
    private MsgParamGen paramGen;
    private long mSyncLocalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImSyncManager getInstance() {
        Class<ImSyncManager> clazz = ImSyncManager.class;
        synchronized (ImSyncManager.class) {
            if (imSyncManager == null) {
                imSyncManager = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return imSyncManager;
        }
    }

    public void init(String account, String cardId, ResultCallback callback, NetCallback net) {
        this.account = account;
        this.callback = callback;
        this.net = net;
        this.condition = new Condition(ImSdkConfigManager.getInstance().getSync(), ImSdkConfigManager.getInstance().getRoam());
        this.time = ImSdkConfigManager.getInstance().getDiff();
        this.paramGen = new MsgParamGen(account, cardId);
        this.syncPool = Executors.newSingleThreadExecutor();
        this.syncAccord = new SyncAccord(false, false);
        MsgManagerHelper.initSyncDb();
        this.syncMessage();
    }

    public void cancelAll() {
        this.shutdownAndAwaitTermination(this.syncPool);
        imSyncManager = null;
    }

    public void handlePushNewNotice() {
        if (this.net == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk receive new message " + this.syncAccord);
        this.callbackNetState(10000);
        this.syncMessage();
    }

    public void handlePushConnectResult(int state) {
        if (this.net == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk receive push connect " + this.syncAccord);
        this.callbackNetState(state);
        if (state == 10000) {
            this.syncMessage();
        }
    }

    public void syncMessage() {
        if (this.net == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk start sync message " + this.syncAccord);
        if (this.syncAccord.isPulling()) {
            this.syncAccord.setNeedSync(true);
            return;
        }
        this.pullMessage(this.paramGen.getPullAccord());
    }

    public void sendText(MsgBean msgBean, long id) {
        this.executeSyncTask(new SyncTask(HttpApiConstant.IMRequestType.NORMAL, msgBean, id));
    }

    public void sendState(String states, long id) {
        this.executeSyncTask(new SyncTask(HttpApiConstant.IMRequestType.STATE, states, id));
    }

    public void sendRecall(MsgBean recall, long id) {
        this.executeSyncTask(new SyncTask(HttpApiConstant.IMRequestType.RECALL, recall, id));
    }

    public void sendRemind(MsgBean remind, long id) {
        this.executeSyncTask(new SyncTask(HttpApiConstant.IMRequestType.REMIND, remind, id));
    }

    private void pullMessage(PullAccord accord) {
        if (accord == null || this.syncAccord == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        this.syncAccord.setPulling(true);
        Logger.getLogger().d("ImSdk new pull task " + accord + ", sync accord " + this.syncAccord);
        this.executeSyncTask(new SyncTask(HttpApiConstant.IMRequestType.PULL, accord, 0L));
    }

    private void loginIM() {
        HttpManagerFactory.getHttpManager().postAsync(ImSdkConfigManager.getInstance().getLoginUrl(), this.paramGen.getLoginPara(), new HttpManager.HttpCallback(){

            @Override
            public void onSuccess(@NonNull String result) {
                ImSyncManager.this.loginSuccess(result);
            }

            @Override
            public void onFailed() {
                ImSyncManager.this.loginFail();
            }
        });
    }

    private void executeSyncTask(SyncTask task) {
        if (this.syncPool != null && !this.syncPool.isShutdown()) {
            try {
                this.syncPool.execute(task);
            }
            catch (Exception e) {
                Logger.getLogger().e("ImSdk execute sync task exception..." + e);
                this.syncPool.shutdown();
            }
        }
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        pool.shutdownNow();
        Thread.currentThread().interrupt();
    }

    private void checkSyncTime(HttpApiConstant.IMRequestType type) {
        if (!(type == HttpApiConstant.IMRequestType.LOGIN || this.syncAccord.isLogin() || this.syncAccord == null || this.time != 0L && System.currentTimeMillis() - this.mSyncLocalTime <= 0x6DDD00L)) {
            this.loginIM();
        }
    }

    private void startRequest(final HttpApiConstant.IMRequestType type, final Object object, final long id) {
        if (this.callback == null || this.net == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        ImRequestBeanN requestBean = null;
        ImRequestConfig config = this.paramGen.getRequestConfig(type, id);
        switch (type) {
            case LOGIN: {
                if (this.time != 0L) break;
                requestBean = this.paramGen.getLoginPara();
                break;
            }
            case PULL: {
                if (!(object instanceof PullAccord)) break;
                PullAccord accord = (PullAccord)object;
                this.pullRequestPrepare(accord);
                requestBean = this.paramGen.getPullPara(accord.getStartId(), accord.getSize(), this.condition);
                break;
            }
            case NORMAL: {
                if (!(object instanceof MsgBean)) break;
                MsgBean msgBean = (MsgBean)object;
                requestBean = this.paramGen.getSendPara(msgBean, id);
                break;
            }
            case STATE: {
                if (!(object instanceof String)) break;
                String states = (String)object;
                requestBean = this.paramGen.getSendStatePara(states, id);
                break;
            }
            case RECALL: {
                if (!(object instanceof MsgBean)) break;
                MsgBean recall = (MsgBean)object;
                requestBean = this.paramGen.getSendPara(recall, id);
                break;
            }
            case REMIND: {
                if (!(object instanceof MsgBean)) break;
                MsgBean recall = (MsgBean)object;
                requestBean = this.paramGen.getReminderPara(recall, id);
                break;
            }
        }
        IHttpCallback callback = new IHttpCallback(){

            @Override
            public void onSuccess(JSONObject jsonObject) {
                ImSyncManager.this.callbackNetState(40000);
                ImSyncManager.this.executeSyncTask(new SyncTask(type, object, id, jsonObject, true));
            }

            @Override
            public void onFailed(int code, JSONObject jsonObject) {
                ImSyncManager.this.executeSyncTask(new SyncTask(type, object, id, jsonObject, false));
            }

            @Override
            public void onFailed(int code, JSONObject requestJsonObject, @NonNull String result) {
                ImSyncManager.this.executeSyncTask(new SyncTask(type, object, id, requestJsonObject, result, false));
            }

            @Override
            public void onNetChanged(int code, JSONObject jsonObject) {
                ImSyncManager.this.callbackNetState(code);
            }
        };
        if (requestBean == null || config == null) {
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(JsonUtils.getGson().toJson((Object)requestBean));
        }
        catch (JSONException e) {
            Logger.getLogger().d("ImSdk request json exception... " + (Object)((Object)e));
        }
        Logger.getLogger().d("ImSdk request " + jsonObject + ", config " + config);
        HttpManagerFactory.getHttpManager().sendImRequest(jsonObject, config, callback);
        if (type == HttpApiConstant.IMRequestType.PULL) {
            ImMssManager.getInstance().sendHistoryGroupState();
        }
    }

    private void parseFailResult(HttpApiConstant.IMRequestType type, Object object, long id, JSONObject json, @Nullable String result) {
        switch (type) {
            case LOGIN: {
                this.loginFail();
                break;
            }
            case PULL: {
                if (!(object instanceof PullAccord)) break;
                PullAccord accord = (PullAccord)object;
                this.pullFail(accord, json);
                break;
            }
            case NORMAL: {
                this.sendTextFail(id, result);
                break;
            }
            case STATE: {
                this.sendStatesFail(id);
                break;
            }
            case RECALL: {
                this.sendRecallFail(id);
                break;
            }
            case REMIND: {
                this.sendRemindFail(id);
            }
        }
    }

    private void parseSuccessResult(HttpApiConstant.IMRequestType type, Object object, long id, JSONObject json) {
        switch (type) {
            case LOGIN: {
                this.loginSuccess(json);
                break;
            }
            case PULL: {
                if (object == null || !(object instanceof PullAccord)) break;
                PullAccord accord = (PullAccord)object;
                this.pullSuccess(accord, json);
                break;
            }
            case NORMAL: {
                if (object == null || !(object instanceof MsgBean)) break;
                this.sendTextSuccess(id, json);
                break;
            }
            case STATE: {
                this.callbackRemoveState(id);
                if (object == null || !(object instanceof String)) break;
                this.sendStatesSuccess(id, json);
                break;
            }
            case RECALL: {
                if (object == null || !(object instanceof MsgBean)) break;
                this.sendRecallSuccess(id, json);
                break;
            }
            case REMIND: {
                if (object == null || !(object instanceof MsgBean)) break;
                this.sendRemindSuccess(id, json);
                break;
            }
        }
    }

    private void loginFail() {
        Logger.getLogger().w("Server time -> synchronous failed");
        if (this.time == 0L && this.syncAccord != null && this.syncAccord.retryTimeSync()) {
            this.loginIM();
        }
    }

    private void loginSuccess(JSONObject json) {
        if (json == null || this.syncAccord == null) {
            return;
        }
        this.syncAccord.resetTimeSync();
        ResultValue bean = null;
        try {
            bean = (ResultValue)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<ResultValue<LoginResult>>(){}.getType());
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk login result exception!!! [" + json + "]");
        }
        if (bean != null) {
            this.time = ToolUtils.getTimeDistance(((LoginResult)bean.getValue()).getSst());
            MsgManagerHelper.saveTime(this.time);
            this.syncMessage();
            return;
        }
        if (!this.parseErrorResult(HttpApiConstant.IMRequestType.LOGIN, json)) {
            Logger.getLogger().d("ImSdk parse login result exception...");
        }
    }

    private void loginSuccess(String result) {
        if (result == null || this.syncAccord == null) {
            return;
        }
        this.syncAccord.resetTimeSync();
        ResultValue bean = null;
        try {
            bean = (ResultValue)JsonUtils.getGson().fromJson(result, new TypeToken<ResultValue<LoginResult>>(){}.getType());
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk login result exception!!! [" + result + "]");
        }
        if (bean != null) {
            long serverTime = ((LoginResult)bean.getValue()).getSst();
            this.time = ToolUtils.getTimeDistance(serverTime);
            this.mSyncLocalTime = System.currentTimeMillis();
            Logger.getLogger().d("Server time -> synchronized: serverTime=" + serverTime + ", bootTime=" + this.time + ", localTime=" + this.mSyncLocalTime);
            MsgManagerHelper.saveTime(this.time);
            this.syncMessage();
        }
    }

    public void sendTextFail(long id, @Nullable String result) {
        int code = 0;
        if (result != null) {
            ImResultErrorBeanN errorBean = (ImResultErrorBeanN)JsonUtils.getGson().fromJson(result, new TypeToken<ImResultErrorBeanN<Ext>>(){}.getType());
            code = errorBean.getCode();
        }
        MsgManagerHelper.updateMessage(String.valueOf(id), code);
        this.callbackChange(String.valueOf(id));
    }

    private void sendTextSuccess(long id, JSONObject json) {
        if (json != null) {
            NormalResult bean = null;
            try {
                bean = (NormalResult)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<NormalResult<Ext>>(){}.getType());
            }
            catch (Exception e) {
                Logger.getLogger().e("ImSdk send message result exception!!! [" + json + "]");
            }
            if (bean != null && !TextUtils.isEmpty((CharSequence)bean.getValueLong())) {
                String serverId = bean.getValueLong();
                if (bean.getExt() != null && !TextUtils.isEmpty((CharSequence)((Ext)bean.getExt()).getFlagid())) {
                    MsgManagerHelper.sendTextSuccess(((Ext)bean.getExt()).getFlagid(), serverId);
                    this.callbackChange(((Ext)bean.getExt()).getFlagid());
                    return;
                }
            }
            if (this.parseErrorResult(HttpApiConstant.IMRequestType.NORMAL, json)) {
                return;
            }
        }
        MsgManagerHelper.updateMessage(String.valueOf(id), 0);
        this.callbackChange(String.valueOf(id));
    }

    public void sendRecallFail(long id) {
        this.callbackRecall(id, -102);
    }

    public void sendRemindFail(long id) {
        this.callbackMessageChange(String.valueOf(id));
    }

    private void sendRecallSuccess(long id, JSONObject json) {
        if (json != null) {
            StateResultN bean = null;
            try {
                bean = (StateResultN)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<StateResultN>(){}.getType());
            }
            catch (Exception e) {
                Logger.getLogger().e("ImSdk send recall message result exception!!! [" + json + "]");
            }
            if (bean != null && bean.getExt() != null && !TextUtils.isEmpty((CharSequence)bean.getExt().getFlagid())) {
                String content = ImSdkCallbackManager.getInstance().getNoticeByAccount(this.account, null);
                MsgManagerHelper.recallSuccess(id, content);
                this.callbackRecall(id, -100);
                return;
            }
            if (this.parseErrorResult(HttpApiConstant.IMRequestType.RECALL, json)) {
                return;
            }
        }
        this.callbackRecall(id, -102);
    }

    private void sendRemindSuccess(long id, JSONObject json) {
        if (json != null) {
            NormalResult bean = null;
            try {
                bean = (NormalResult)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<NormalResult<Ext>>(){}.getType());
            }
            catch (Exception e) {
                Logger.getLogger().e("ImSdk send message result exception!!! [" + json + "]");
            }
            if (bean != null && !TextUtils.isEmpty((CharSequence)bean.getValueLong())) {
                String serverId = bean.getValueLong();
                if (bean.getExt() != null && !TextUtils.isEmpty((CharSequence)((Ext)bean.getExt()).getFlagid())) {
                    ImSdkDbUtils.update(OptHelper.getIns().getAttServerIdUpdate(id, serverId));
                    this.callbackMessageChange(((Ext)bean.getExt()).getFlagid());
                    return;
                }
            }
            if (this.parseErrorResult(HttpApiConstant.IMRequestType.REMIND, json)) {
                this.deleteAtt(id);
                return;
            }
        }
        this.deleteAtt(id);
    }

    private void deleteAtt(long id) {
        ImSdkDbUtils.delete(OptHelper.getIns().getAttDel(id));
    }

    public void sendStatesFail(long id) {
        this.callbackRemoveState(ToolUtils.getLong(id));
    }

    private void sendStatesSuccess(long id, JSONObject json) {
        if (json != null) {
            StateResultN bean = null;
            try {
                bean = (StateResultN)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<StateResultN>(){}.getType());
            }
            catch (Exception e) {
                Logger.getLogger().e("ImSdk send recall message result exception!!! [" + json + "]");
            }
            if (bean != null && bean.getExt() != null && !TextUtils.isEmpty((CharSequence)bean.getExt().getFlagid())) {
                MsgManagerHelper.deleteState(String.valueOf(id));
                if (bean.getValue() != null && !bean.getValue().isEmpty()) {
                    List<FailStateResult> failStates = bean.getValue();
                    MsgManagerHelper.saveFailState(failStates, this.account);
                }
                return;
            }
            if (this.parseErrorResult(HttpApiConstant.IMRequestType.STATE, json)) {
                // empty if block
            }
        }
    }

    private void pullFail(PullAccord accord, JSONObject json) {
        Logger.getLogger().e("ImSdk pull message fail " + json);
        this.pullException(accord, json);
    }

    private void pullSuccess(PullAccord accord, JSONObject json) {
        ResultValue result;
        if (json == null || accord == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        try {
            result = (ResultValue)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<ResultValue<List<MsgBean>>>(){}.getType());
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk pull message result exception!!! [" + json + "]");
            this.pullException(accord, json);
            return;
        }
        Logger.getLogger().d("ImSdk pull result " + result);
        if (result == null || result.getValue() == null) {
            this.pullException(accord, json);
            return;
        }
        if (((List)result.getValue()).isEmpty()) {
            this.pullFinish(accord);
        }
        boolean syncFinish = false;
        int count = 0;
        ArrayList<MsgBean> messages = new ArrayList<MsgBean>();
        for (MsgBean msg : (List)result.getValue()) {
            if (accord.isFirstPull()) {
                if (msg.isReceived(this.account)) {
                    syncFinish = true;
                }
            } else {
                if (msg.getI() == accord.getEndId()) {
                    syncFinish = true;
                }
                if (msg.getI() < accord.getEndId()) {
                    ++count;
                }
            }
            if (msg.getI() > accord.getMaxId()) {
                accord.setMaxId(msg.getI());
            }
            if (syncFinish) break;
            messages.add(msg);
        }
        if (count >= 3) {
            syncFinish = true;
        }
        if (messages.isEmpty() || this.callback == null) {
            syncFinish = true;
        } else {
            Logger.getLogger().d("ImSdk pull result parse " + accord);
            if (!accord.isFirstPull()) {
                this.callback.ReceiveMessage(messages);
            } else if (accord.firstCanCallback()) {
                this.callback.ReceiveMessage(messages);
            } else if (MsgManagerHelper.isSent(messages, this.account)) {
                accord.addFirstList(messages);
            } else {
                accord.setFirstCanCallback(true);
                this.callback.ReceiveMessage(accord.getFirstList());
                accord.clearFirstList();
                this.callback.ReceiveMessage(messages);
            }
            long lastId = ((MsgBean)messages.get(messages.size() - 1)).getI();
            Logger.getLogger().d("ImSdk pull message lastId = " + lastId);
            accord.nextAccord(lastId);
        }
        if (syncFinish) {
            this.pullFinish(accord);
            return;
        }
        Logger.getLogger().d("ImSdk pull message cycle accord = " + accord);
        this.pullMessage(accord);
    }

    private boolean parseErrorResult(HttpApiConstant.IMRequestType type, JSONObject json) {
        ImResultErrorBeanN errorBean;
        if (json == null) {
            return false;
        }
        try {
            errorBean = (ImResultErrorBeanN)JsonUtils.getGson().fromJson(json.toString(), new TypeToken<ImResultErrorBeanN<Ext>>(){}.getType());
        }
        catch (Exception e) {
            this.callbackImSdk(50023);
            Logger.getLogger().e("ImSdk parse error result exception [" + json + "]");
            return false;
        }
        if (errorBean == null) {
            this.callbackImSdk(50023);
            Logger.getLogger().e("ImSdk parse error result exception...");
            return false;
        }
        int code = errorBean.getCode();
        if (errorBean.getExt() == null || TextUtils.isEmpty((CharSequence)((Ext)errorBean.getExt()).getFlagid())) {
            return false;
        }
        String flagId = ((Ext)errorBean.getExt()).getFlagid();
        switch (type) {
            case LOGIN: {
                break;
            }
            case PULL: {
                break;
            }
            case NORMAL: {
                MsgManagerHelper.updateMessage(flagId, code);
                this.callbackChange(flagId);
                break;
            }
            case STATE: {
                this.callbackRemoveState(ToolUtils.getLong(flagId));
                if (code != 552) break;
                MsgManagerHelper.deleteState(flagId);
                break;
            }
            case RECALL: {
                this.callbackRecall(ToolUtils.getLong(flagId), -102);
                break;
            }
            case REMIND: {
                this.deleteAtt(ToolUtils.getLong(flagId));
                break;
            }
        }
        return true;
    }

    private void pullRequestPrepare(PullAccord accord) {
        if (accord == null || this.callback == null) {
            return;
        }
        this.callback.SendState();
        if (accord.needQueryEnd()) {
            MsgManagerHelper.querySyncAccord(accord);
        }
    }

    private void pullFinish(PullAccord accord) {
        if (accord == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk pull message finish... " + accord);
        if (accord.isFirstPull()) {
            if (!MsgManagerHelper.isSent(accord.getFirstList(), this.account)) {
                this.callback.ReceiveMessage(accord.getFirstList());
                accord.clearFirstList();
            } else if (MsgManagerHelper.isAssistant(accord.getFirstList(), this.account)) {
                this.callback.ReceiveMessage(accord.getFirstList());
                accord.clearFirstList();
            } else {
                MsgManagerHelper.updateProcessId(accord.getLastId());
            }
        }
        MsgManagerHelper.updateSyncDb(accord, true);
        if (this.syncAccord.needSync()) {
            this.pullMessage(this.paramGen.getPullAccord());
            this.syncAccord.setNeedSync(false);
        } else {
            this.syncAccord.setPulling(false);
        }
    }

    private void pullException(PullAccord accord, JSONObject json) {
        if (accord == null || this.syncAccord == null || this.paramGen == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk pull exception " + accord);
        if (accord.isFirstPull()) {
            if (!MsgManagerHelper.isSent(accord.getFirstList(), this.account)) {
                this.callback.ReceiveMessage(accord.getFirstList());
                accord.clearFirstList();
            } else if (MsgManagerHelper.isAssistant(accord.getFirstList(), this.account)) {
                this.callback.ReceiveMessage(accord.getFirstList());
                accord.clearFirstList();
            }
        }
        this.syncAccord.setPulling(false);
        MsgManagerHelper.updateSyncDb(accord, false);
        this.parseErrorResult(HttpApiConstant.IMRequestType.PULL, json);
    }

    private void callbackNetState(int code) {
        if (this.net == null) {
            return;
        }
        this.net.NetChanged(code);
    }

    private void requestFail(int code) {
        if (code == 50101) {
            this.callbackImSdk(50024);
        }
    }

    private void callbackImSdk(int code) {
        ImSdkCallbackManager.getInstance().callState(code, null);
    }

    private void callbackChange(String id) {
        MsgManagerHelper.callbackSendResult(id);
    }

    private void callbackRecall(long id, int code) {
        MsgManagerHelper.callbackRecallResult(id, code);
    }

    private void callbackMessageChange(String id) {
        MsgManagerHelper.callbackRemind(id);
    }

    private void callbackRemoveState(long id) {
        if (this.callback == null) {
            return;
        }
        this.callback.RemoveState(id);
    }

    private class SyncTask
    implements Runnable {
        private HttpApiConstant.IMRequestType type;
        private JSONObject json;
        private String mResult;
        private Object object;
        private long id;
        private boolean success;

        private SyncTask(HttpApiConstant.IMRequestType type, Object object, long id) {
            this.type = type;
            this.object = object;
            this.id = id;
        }

        private SyncTask(HttpApiConstant.IMRequestType type, Object object, long id, JSONObject json, boolean success) {
            this.type = type;
            this.object = object;
            this.id = id;
            this.json = json;
            this.success = success;
        }

        private SyncTask(HttpApiConstant.IMRequestType type, Object object, long id, JSONObject json, String result, boolean success) {
            this.type = type;
            this.object = object;
            this.id = id;
            this.json = json;
            this.mResult = result;
            this.success = success;
        }

        @Override
        public void run() {
            ImSyncManager.this.checkSyncTime(this.type);
            if (this.json == null) {
                ImSyncManager.this.startRequest(this.type, this.object, this.id);
            } else if (this.success) {
                ImSyncManager.this.parseSuccessResult(this.type, this.object, this.id, this.json);
            } else {
                ImSyncManager.this.parseFailResult(this.type, this.object, this.id, this.json, this.mResult);
            }
        }
    }

    private static class Factory {
        private Factory() {
        }

        static ImSyncManager getInstance() {
            return new ImSyncManager();
        }
    }
}

