/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.process;

import android.text.TextUtils;
import com.xdja.imsdk.constant.ChangeAction;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.bean.AttentionMsgDb;
import com.xdja.imsdk.db.bean.DuplicateIdDb;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.logger.DebugHelper;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkFileManager;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.manager.build.HttpManagerFactory;
import com.xdja.imsdk.manager.callback.SendCallback;
import com.xdja.imsdk.manager.process.ReceiveNode;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.internal.IMState;
import com.xdja.imsdk.model.internal.content.RemindContent;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;
import com.xdja.imsdk.strategy.FileStateStrategy;
import com.xdja.imsdk.strategy.FileStateStrategyFactory;
import com.xdja.imsdk.util.FileSizeUtils;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class ReceiveProcess {
    private SendCallback sendCallback;
    private Thread receivedThread;
    private String account;
    private final LinkedBlockingQueue<ReceiveNode> receivedQueue = new LinkedBlockingQueue();
    private Map<String, List<MessageWrapper>> newMap = new HashMap<String, List<MessageWrapper>>();
    private boolean preLoad = false;

    public ReceiveProcess(String account, SendCallback sendCallback) {
        this.account = account;
        this.sendCallback = sendCallback;
        this.preLoad = ImSdkConfigManager.getInstance().needPreload();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<MsgBean> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        DebugHelper.logMsgBean("ImSdk receive msg bean list ", list);
        ReceiveNode msg = new ReceiveNode(Constant.ReceiveType.RECEIVE);
        ArrayList<MsgBean> messages = new ArrayList<MsgBean>();
        messages.addAll(list);
        msg.setMessages(messages);
        this.receivedQueue.offer(msg);
        LinkedBlockingQueue<ReceiveNode> linkedBlockingQueue = this.receivedQueue;
        synchronized (linkedBlockingQueue) {
            this.receivedQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageWrapper message, ImSdkFileConstant.FileType type) {
        ReceiveNode msg = new ReceiveNode(Constant.ReceiveType.DECRYPT);
        msg.setFile(message);
        msg.setFileType(type);
        this.receivedQueue.offer(msg);
        LinkedBlockingQueue<ReceiveNode> linkedBlockingQueue = this.receivedQueue;
        synchronized (linkedBlockingQueue) {
            this.receivedQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedBlockingQueue<ReceiveNode> linkedBlockingQueue = this.receivedQueue;
        synchronized (linkedBlockingQueue) {
            this.receivedQueue.notifyAll();
        }
        if (this.receivedThread != null) {
            this.receivedThread.interrupt();
        }
    }

    protected void init() {
        if (this.receivedThread == null) {
            this.receivedThread = new Thread(new ReceivedRunnable());
            this.receivedThread.setName("receivedThread");
            this.receivedThread.start();
        } else if (!this.receivedThread.isAlive()) {
            this.receivedThread.start();
        }
    }

    private void processDecrypt(MessageWrapper message, ImSdkFileConstant.FileType type) {
        int state;
        String dest;
        String path;
        if (message == null || message.getMsgEntryDb() == null) {
            return;
        }
        SecurityPara para = ModelMapper.getIns().getSecurityPara(message.getMsgEntryDb());
        if (para == null) {
            return;
        }
        if (type == ImSdkFileConstant.FileType.IS_SHOW) {
            if (message.getFileMsgDb() == null) {
                return;
            }
            path = message.getFileMsgDb().getEncrypt_path();
            dest = message.getFileMsgDb().getFile_path();
            String md5 = message.getFileMsgDb().getFile_md5();
            state = ToolUtils.getInt(message.getFileMsgDb().getFile_state());
        } else if (type == ImSdkFileConstant.FileType.IS_HD) {
            if (message.getHdThumbFileDb() == null) {
                return;
            }
            path = message.getHdThumbFileDb().getHd_encrypt_path();
            dest = message.getHdThumbFileDb().getHd_file_path();
            String md5 = message.getHdThumbFileDb().getHd_md5();
            state = ToolUtils.getInt(message.getHdThumbFileDb().getHd_state());
        } else {
            if (message.getRawFileDb() == null) {
                return;
            }
            path = message.getRawFileDb().getRaw_encrypt_path();
            dest = message.getRawFileDb().getRaw_file_path();
            String md5 = message.getRawFileDb().getRaw_md5();
            state = ToolUtils.getInt(message.getRawFileDb().getRaw_state());
        }
        if (ToolUtils.isEmpty(path) || ToolUtils.isEmpty(dest)) {
            Logger.getLogger().e("current decrypt file path error!!! ");
            return;
        }
        File file = new File(dest);
        if (file.exists()) {
            if (TextUtils.equals((CharSequence)this.account, (CharSequence)message.getMsgEntryDb().getSender())) {
                return;
            }
            Logger.getLogger().d("current decrypt file already exist: " + dest);
            if (state < 0) {
                Logger.getLogger().e("current decrypt file state error!!! ");
                return;
            }
            if (state < 26) {
                SecurityResult existResult = new SecurityResult(dest, 0);
                this.updateDecrypt(existResult, message, type);
                long id = message.getMsgEntryDb().getId();
                this.callbackFinish(id, type, existResult.success());
            }
        } else {
            SecurityResult result = ImSdkCallbackManager.getInstance().callDecryptFile(path, dest, para);
            if (result == null) {
                return;
            }
            this.updateDecrypt(result, message, type);
            if (!result.success()) {
                Logger.getLogger().e("Download file -> decrypt file failed: message=" + message + ", result=" + result);
                FileUtils.deleteFile(dest);
            }
            long id = message.getMsgEntryDb().getId();
            this.callbackFinish(id, type, result.success());
        }
    }

    private void callbackFinish(long id, ImSdkFileConstant.FileType type, boolean decrypt) {
        MessageWrapper file = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
        if (file == null || file.getMsgEntryDb() == null) {
            return;
        }
        if (file.getMsgEntryDb().isRecalled()) {
            return;
        }
        IMMessage msg = ModelMapper.getIns().mapIMMessageDecryptDone(file);
        IMFileInfo fileInfo = new IMFileInfo(msg);
        fileInfo.setTag(file.getMsgEntryDb().getSession_flag());
        fileInfo.setFileType(type);
        fileInfo.setPercent(100);
        FileStateStrategy fileStateStrategy = FileStateStrategyFactory.createFileStateStrategy();
        if (decrypt) {
            fileInfo.setState(fileStateStrategy.getDownloadDoneState());
            if (file.getFileMsgDb() != null) {
                ImSdkFileManager.getInstance().changeStateAndCallbackFinish(fileInfo, msg, file.getFileMsgDb().isNormal());
            } else {
                ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
            }
        } else {
            fileInfo.setState(fileStateStrategy.getDownloadFailState());
            ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FAIL);
        }
    }

    private void updateDecrypt(SecurityResult result, MessageWrapper message, ImSdkFileConstant.FileType type) {
        long id = message.getMsgEntryDb().getId();
        if (!result.success()) {
            ImSdkDbUtils.update(OptHelper.getIns().getFTUpdate(type, -1L, 25, id));
            return;
        }
        if (type == ImSdkFileConstant.FileType.IS_SHOW) {
            if (message.getFileMsgDb() == null) {
                return;
            }
            String filePath = result.getResult();
            long fileSize = FileSizeUtils.getFileSize(filePath);
            ImSdkDbUtils.update(OptHelper.getIns().getDFUpdate(type, filePath, fileSize, 26, id));
        } else if (type == ImSdkFileConstant.FileType.IS_HD) {
            if (message.getHdThumbFileDb() == null) {
                return;
            }
            String hdPath = result.getResult();
            long hdSize = FileSizeUtils.getFileSize(hdPath);
            ImSdkDbUtils.update(OptHelper.getIns().getDFUpdate(type, hdPath, hdSize, 26, id));
        } else {
            if (message.getRawFileDb() == null) {
                return;
            }
            String rawPath = result.getResult();
            long rawSize = FileSizeUtils.getFileSize(rawPath);
            ImSdkDbUtils.update(OptHelper.getIns().getDFUpdate(type, rawPath, rawSize, 26, id));
        }
    }

    private void processReceived(List<MsgBean> list) {
        boolean empty;
        boolean bl = empty = list == null || list.isEmpty();
        if (this.queueIsEmpty() || empty) {
            this.callbackAll();
        }
        if (empty) {
            return;
        }
        ArrayList<MsgBean> messages = new ArrayList<MsgBean>();
        ArrayList<MsgBean> states = new ArrayList<MsgBean>();
        ArrayList<MsgBean> recalls = new ArrayList<MsgBean>();
        ArrayList<MsgBean> reminds = new ArrayList<MsgBean>();
        ArrayList<Long> nIds = new ArrayList<Long>();
        ArrayList<Long> sIds = new ArrayList<Long>();
        ArrayList<Long> rIds = new ArrayList<Long>();
        List<MessageWrapper> sentFilter = ImSdkDbUtils.querySent(OptHelper.getIns().getSentQuery(this.account));
        for (MsgBean msg : list) {
            boolean isSame;
            boolean isNormal = msg.isNormalType();
            boolean isState = msg.isStateMsg();
            boolean isRecall = msg.isRecallMsg();
            boolean isRemind = msg.isRemind();
            if (isNormal && !(isSame = this.isDupSending(msg, sentFilter))) {
                messages.add(msg);
                nIds.add(msg.getI());
            }
            if (isRemind) {
                reminds.add(msg);
            }
            if (isState && !this.isSendOut(msg)) {
                states.add(msg);
                sIds.add(ToolUtils.getLong(msg.getC()));
            }
            if (!isRecall) continue;
            recalls.add(msg);
            rIds.add(ToolUtils.getLong(msg.getC()));
        }
        this.processNormals(messages, nIds);
        this.processStates(states, sIds);
        this.processRecall(recalls, rIds);
        this.processRemind(reminds);
        this.saveProcessed(list);
    }

    private boolean isDupSending(MsgBean msg, List<MessageWrapper> filter) {
        if (filter == null || filter.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (MessageWrapper wrapper : filter) {
            if (wrapper == null || wrapper.getMsgEntryDb() == null) continue;
            boolean sameRec = TextUtils.equals((CharSequence)msg.getTo(), (CharSequence)wrapper.getMsgEntryDb().getReceiver());
            boolean sameType = msg.getT() == wrapper.getMsgEntryDb().getType().intValue();
            long fst = msg.getFst();
            long createTime = wrapper.getMsgEntryDb().getCreate_time();
            if (!sameRec || !sameType || !this.timeEquals(fst, createTime)) continue;
            Logger.getLogger().d("message " + msg.getI() + " is duplicate !!!");
            result = true;
            break;
        }
        return result;
    }

    private boolean timeEquals(long send, long create) {
        try {
            String sendStr = String.valueOf(send).substring(0, 12);
            String createStr = String.valueOf(create).substring(0, 12);
            if (TextUtils.equals((CharSequence)sendStr, (CharSequence)createStr)) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("process message error !!!");
            return false;
        }
        return false;
    }

    private void processNormals(List<MsgBean> normals, List<Long> ids) {
        if (normals == null || normals.isEmpty()) {
            this.callbackAll();
            return;
        }
        ArrayList<MsgBean> results = new ArrayList<MsgBean>();
        ArrayList<MsgBean> toSaveDup = new ArrayList<MsgBean>();
        ArrayList<MessageWrapper> dupStates = new ArrayList<MessageWrapper>();
        ArrayList<MsgBean> dupResult = new ArrayList<MsgBean>();
        HashMap<Long, MsgBean> noDupResult = new HashMap<Long, MsgBean>();
        List<Long> savedFilter = ImSdkDbUtils.queryIds(OptHelper.getIns().getSaveQuery(ids));
        List<Long> delFilter = ImSdkDbUtils.queryDelIds(OptHelper.getIns().getDelQuery(ids));
        for (MsgBean msg : normals) {
            Long id = msg.getI();
            if (savedFilter.contains(id) || delFilter.contains(id)) continue;
            dupResult.add(msg);
            noDupResult.put(msg.getFst(), msg);
        }
        if (dupResult.size() > noDupResult.size()) {
            for (MsgBean msg : dupResult) {
                MsgBean dup;
                if (!this.isSame(msg, dup = (MsgBean)noDupResult.get(msg.getFst()))) continue;
                toSaveDup.add(msg);
            }
        }
        ArrayList<Long> noDupFst = new ArrayList<Long>();
        ArrayList noDupList = new ArrayList();
        Set entrySet = noDupResult.entrySet();
        for (Map.Entry entry : entrySet) {
            noDupFst.add((Long)entry.getKey());
            noDupList.add(entry.getValue());
        }
        List<MessageWrapper> savedFstFilter = ImSdkDbUtils.queryDup(OptHelper.getIns().getDupQuery(noDupFst));
        if (savedFstFilter == null || savedFstFilter.isEmpty()) {
            results = noDupList;
        } else {
            for (MsgBean msg : noDupList) {
                boolean isDuplicate = false;
                for (MessageWrapper wrapper : savedFstFilter) {
                    if (!this.isSame(msg, wrapper)) continue;
                    toSaveDup.add(msg);
                    isDuplicate = true;
                    if (!wrapper.getMsgEntryDb().needState()) continue;
                    wrapper.getMsgEntryDb().setServer_id(msg.getI());
                    if (msg.isSupportMsg()) {
                        dupStates.add(wrapper);
                        continue;
                    }
                    dupStates.add(ModelMapper.getIns().getNewStateWrapper(wrapper, msg.getT()));
                }
                if (isDuplicate) continue;
                results.add(msg);
            }
        }
        List<String> list = ImSdkDbUtils.querySessions(OptHelper.getIns().getTQuery());
        ArrayList<MessageWrapper> toSaveM = new ArrayList<MessageWrapper>();
        HashMap<String, SessionWrapper> toSaveS = new HashMap<String, SessionWrapper>();
        HashSet<String> toRefreshS = new HashSet<String>();
        ArrayList<MessageWrapper> sendBombs = new ArrayList<MessageWrapper>();
        ArrayList<MessageWrapper> recStates = new ArrayList<MessageWrapper>();
        for (MsgBean msg : results) {
            MessageWrapper wrapper = ModelMapper.getIns().mapMWrapper(msg);
            if (wrapper == null || wrapper.getMsgEntryDb() == null) continue;
            if (this.isRecNewMsg(msg)) {
                wrapper.getMsgEntryDb().setState(2);
                msg.setStat(2);
                if (msg.isSupportMsg()) {
                    recStates.add(wrapper);
                } else {
                    recStates.add(ModelMapper.getIns().getNewStateWrapper(wrapper, msg.getT()));
                }
            }
            if (msg.getStat() == 5) {
                String content = msg.isGroupMsg() ? ImSdkCallbackManager.getInstance().getNoticeByAccount(msg.getF(), msg.getTo()) : ImSdkCallbackManager.getInstance().getNoticeByAccount(msg.getF(), null);
                wrapper.getMsgEntryDb().setContent(content);
            }
            if (this.isRecReadBomb(msg)) {
                if (msg.isSupportMsg()) {
                    sendBombs.add(wrapper);
                } else {
                    sendBombs.add(ModelMapper.getIns().getNewStateWrapper(wrapper, msg.getT()));
                }
                msg.setStat(4);
            }
            if (this.isRecBombed(msg)) {
                msg.setC("");
            }
            if (!this.isDestroyedStrictly(msg)) {
                toSaveM.add(wrapper);
            }
            String tag = wrapper.getMsgEntryDb().getSession_flag();
            boolean existed = list.contains(tag);
            boolean saving = toSaveS.containsKey(tag);
            if (existed) {
                toRefreshS.add(tag);
                continue;
            }
            if (saving || this.isDestroyedStrictly(msg)) continue;
            SessionWrapper newSession = ModelMapper.getIns().getSWrapper(msg);
            toSaveS.put(tag, newSession);
        }
        List<SessionWrapper> sessions = ModelMapper.getIns().mapSessions(toSaveS);
        List<DuplicateIdDb> dupIds = ModelMapper.getIns().mapDup(toSaveDup);
        List<IMState> bombs = ModelMapper.getIns().getStates(sendBombs);
        List<IMState> dupes = ModelMapper.getIns().getStates(dupStates);
        List<IMState> recs = ModelMapper.getIns().getStates(recStates);
        Logger.getLogger().d("ImSdk receive dup ids " + dupIds);
        this.save(sessions, toSaveM, dupIds, bombs, dupes, recs);
        this.sendState();
        this.callbackSM(toSaveS, toSaveM, toRefreshS);
        this.loadFile(toSaveM);
    }

    private void processStates(List<MsgBean> states, List<Long> ids) {
        if (states == null || states.isEmpty()) {
            return;
        }
        Map<Long, Integer> savedState = ImSdkDbUtils.queryMStates(OptHelper.getIns().getStates(ids));
        ArrayList<MsgBean> toUpdate = new ArrayList();
        ArrayList<Long> toUpdateIds = new ArrayList();
        if (savedState.isEmpty()) {
            toUpdate = states;
            toUpdateIds = ids;
        } else {
            for (MsgBean state : states) {
                boolean stateIsValid;
                Long serverId = ToolUtils.getLong(state.getC());
                boolean isExist = savedState.containsKey(serverId);
                if (!isExist || !(stateIsValid = state.getStat() > savedState.get(serverId))) continue;
                toUpdate.add(state);
                toUpdateIds.add(serverId);
            }
        }
        this.updateState(toUpdate);
        this.callbackSR(toUpdateIds);
        this.deleteStrictly(toUpdateIds);
    }

    private void processRecall(List<MsgBean> recalls, List<Long> ids) {
        if (recalls == null || recalls.isEmpty()) {
            return;
        }
        List<MessageWrapper> messages = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMSQuery(ids), OptType.MQuery.ALL);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        Map<String, List<MessageWrapper>> map = this.classifyMessage(messages);
        Set<String> tags = map.keySet();
        List<SessionWrapper> sWrappers = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(tags), OptType.SQuery.HAVE);
        if (sWrappers == null || sWrappers.isEmpty()) {
            return;
        }
        for (SessionWrapper sWrapper : sWrappers) {
            String tag = sWrapper.getSessionEntryDb().getSession_flag();
            List<MessageWrapper> list = map.get(tag);
            if (list == null || list.isEmpty()) continue;
            int count = sWrapper.getSessionEntryDb().getReminded();
            for (MessageWrapper mWrapper : list) {
                if (mWrapper.getMsgEntryDb().getState() == 5) continue;
                long id = mWrapper.getMsgEntryDb().getId();
                String sender = mWrapper.getMsgEntryDb().getSender();
                boolean isNewMsg = mWrapper.getMsgEntryDb().getState() == 2;
                String content = mWrapper.getMsgEntryDb().isGroup() ? ImSdkCallbackManager.getInstance().getNoticeByAccount(sender, mWrapper.getMsgEntryDb().getReceiver()) : ImSdkCallbackManager.getInstance().getNoticeByAccount(sender, null);
                if (!TextUtils.equals((CharSequence)this.account, (CharSequence)sender) && isNewMsg && --count >= 0) {
                    ImSdkDbUtils.update(OptHelper.getIns().getRUpdate(tag, count, false));
                }
                if (mWrapper.isFile() || mWrapper.isWeb()) {
                    HttpManagerFactory.getHttpManager().cancelRequest(id);
                }
                UpdateArgs updateArgs = OptHelper.getIns().getEUpdate(id, 5, content);
                ImSdkDbUtils.update(updateArgs);
                ImSdkDbUtils.delete(OptHelper.getIns().getFileDel(id));
                ImSdkDbUtils.delete(OptHelper.getIns().getHDDel(id));
                ImSdkDbUtils.delete(OptHelper.getIns().getRawDel(id));
                IMMessage message = ModelMapper.getIns().mapMessage(ImSdkDbUtils.queryMessage(OptHelper.getIns().getMIQuery(id), OptType.MQuery.NO));
                SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
                IMSession session = ModelMapper.getIns().mapSession(wrapper);
                ImSdkCallbackManager.getInstance().callRecall(session, message, -100);
            }
        }
    }

    private void processRemind(List<MsgBean> reminds) {
        if (reminds == null || reminds.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MsgBean msgBean : reminds) {
            ids.add(msgBean.getI());
        }
        List<Long> attSaved = ImSdkDbUtils.queryAttServerIds(OptHelper.getIns().getAttServerIdQuery(ids));
        List<Long> attDel = ImSdkDbUtils.queryDelIds(OptHelper.getIns().getDelQuery(ids));
        ArrayList<MsgBean> okRemind = new ArrayList<MsgBean>();
        for (MsgBean msg : reminds) {
            Long id = msg.getI();
            if (attSaved.contains(id) || attDel.contains(id)) continue;
            okRemind.add(msg);
        }
        ArrayList<Long> notificationIds = new ArrayList<Long>();
        ArrayList<AttentionMsgDb> attentionMsgDbs = new ArrayList<AttentionMsgDb>();
        for (MsgBean msgBean : okRemind) {
            AttentionMsgDb attentionMsgDb = new AttentionMsgDb();
            attentionMsgDb.setAtt_server_id(msgBean.getI());
            attentionMsgDb.setAtt_from(msgBean.getF());
            attentionMsgDb.setAtt_to(msgBean.getTo());
            if (msgBean.getTo().equals(this.account)) {
                attentionMsgDb.setReceived(1);
            } else {
                attentionMsgDb.setReceived(2);
            }
            String content = msgBean.getC();
            RemindContent remindContent = JsonUtils.mapGson(content, RemindContent.class);
            if (remindContent != null) {
                attentionMsgDb.setMsg_server_id(remindContent.getServerId());
                attentionMsgDb.setAtt_time(remindContent.getTime());
                notificationIds.add(remindContent.getServerId());
            }
            attentionMsgDbs.add(attentionMsgDb);
        }
        ImSdkDbUtils.saveAttBatch(attentionMsgDbs);
        if (!notificationIds.isEmpty()) {
            List<MessageWrapper> messages = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMSQuery(notificationIds), OptType.MQuery.ALL);
            ArrayList<MessageWrapper> wrappers = new ArrayList<MessageWrapper>();
            for (AttentionMsgDb db : attentionMsgDbs) {
                for (MessageWrapper msg : messages) {
                    if (db.getMsg_server_id().longValue() != msg.getMsgEntryDb().getServer_id().longValue() || msg.getMsgEntryDb().readOrBomb()) continue;
                    msg.getMsgEntryDb().setSort_time(db.getAtt_time());
                    wrappers.add(msg);
                }
            }
            if (wrappers.isEmpty()) {
                return;
            }
            List<IMMessage> imMessages = ModelMapper.getIns().mapMessages(wrappers);
            SessionWrapper sWrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSQuery(ToolUtils.getResidentTag()), OptType.SQuery.NON);
            IMSession session = ModelMapper.getIns().mapSession(sWrapper);
            ImSdkCallbackManager.getInstance().callMessage(session, imMessages, ChangeAction.ACT_ADD);
            ImSdkCallbackManager.getInstance().callNew(session, imMessages);
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
        }
    }

    private void callbackAll() {
        if (this.newMap == null || this.newMap.isEmpty()) {
            return;
        }
        Set<String> tags = this.newMap.keySet();
        List<SessionWrapper> sessions = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(tags), OptType.SQuery.HAVE);
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        for (SessionWrapper session : sessions) {
            List<MessageWrapper> messages = this.newMap.get(session.getSessionEntryDb().getSession_flag());
            this.callbackNM(session, messages);
        }
        this.newMap.clear();
    }

    private void callbackNM(SessionWrapper sWrapper, List<MessageWrapper> mWrappers) {
        ArrayList<IMMessage> adds = new ArrayList<IMMessage>();
        ArrayList<IMMessage> news = new ArrayList<IMMessage>();
        IMSession session = ModelMapper.getIns().mapSession(sWrapper);
        for (MessageWrapper msg : mWrappers) {
            IMMessage message = ModelMapper.getIns().mapMessage(msg);
            adds.add(message);
            if (!msg.getMsgEntryDb().isNew()) continue;
            news.add(message);
        }
        ImSdkCallbackManager.getInstance().callNew(session, news);
        ImSdkCallbackManager.getInstance().callMessage(session, adds, ChangeAction.ACT_ADD);
        this.sendCallback.SendStates();
    }

    private void callbackSM(Map<String, SessionWrapper> toSaveS, List<MessageWrapper> toSaveM, Set<String> toRefreshS) {
        this.callbackNewS(toSaveS);
        this.callbackRS(toRefreshS);
        this.prepareCallback(toSaveM);
    }

    private void callbackNewS(Map<String, SessionWrapper> toSaveS) {
        if (toSaveS == null || toSaveS.isEmpty()) {
            return;
        }
        Set<String> tags = toSaveS.keySet();
        List<SessionWrapper> newS = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(tags), OptType.SQuery.HAVE);
        if (newS == null || newS.isEmpty()) {
            return;
        }
        for (SessionWrapper entry : newS) {
            IMSession session = ModelMapper.getIns().mapSession(entry);
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_ADD);
        }
    }

    private void callbackRS(Set<String> toRefreshS) {
        if (toRefreshS == null || toRefreshS.isEmpty()) {
            return;
        }
        List<SessionWrapper> sessions = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(toRefreshS), OptType.SQuery.HAVE);
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        for (SessionWrapper wrapper : sessions) {
            IMSession session = ModelMapper.getIns().mapSession(wrapper);
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
        }
    }

    private void prepareCallback(List<MessageWrapper> toSaveM) {
        List<Long> serverIds = ModelMapper.getIns().getServerIds(toSaveM);
        if (serverIds.isEmpty()) {
            return;
        }
        List<MessageWrapper> messages = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMSQuery(serverIds), OptType.MQuery.ALL);
        this.assertCallback(messages);
    }

    private void callbackSR(List<Long> serverIds) {
        if (serverIds == null || serverIds.isEmpty()) {
            return;
        }
        List<MessageWrapper> messages = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMSQuery(serverIds), OptType.MQuery.ALL);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        Map<String, List<MessageWrapper>> map = this.classifyMessage(messages);
        Set<String> tags = map.keySet();
        List<SessionWrapper> sWrappers = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(tags), OptType.SQuery.HAVE);
        if (sWrappers == null || sWrappers.isEmpty()) {
            return;
        }
        for (SessionWrapper sWrapper : sWrappers) {
            String tag = sWrapper.getSessionEntryDb().getSession_flag();
            List<MessageWrapper> list = map.get(tag);
            if (list == null || list.isEmpty()) continue;
            IMSession session = ModelMapper.getIns().mapSession(sWrapper);
            for (MessageWrapper mWrapper : list) {
                IMMessage message = ModelMapper.getIns().mapMessage(mWrapper);
                ImSdkCallbackManager.getInstance().callChange(session, message);
            }
        }
    }

    private void assertCallback(List<MessageWrapper> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        Map<String, List<MessageWrapper>> map = this.classifyMessage(messages);
        Set<String> tags = map.keySet();
        List<SessionWrapper> sessions = ImSdkDbUtils.querySessions(OptHelper.getIns().getSQuery(tags), OptType.SQuery.HAVE);
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        for (SessionWrapper session : sessions) {
            String tag = session.getSessionEntryDb().getSession_flag();
            List<MessageWrapper> list = map.get(tag);
            if (list == null || list.isEmpty()) continue;
            if (this.queueIsEmpty()) {
                this.callbackNM(session, list);
                continue;
            }
            if (this.newMap.containsKey(tag)) {
                this.newMap.get(tag).addAll(list);
                if (this.newMap.get(tag).size() <= 15) continue;
                this.callbackNM(session, this.newMap.get(tag));
                this.newMap.remove(tag);
                continue;
            }
            if (list.size() > 15) {
                this.callbackNM(session, list);
                continue;
            }
            this.newMap.put(tag, list);
        }
    }

    private void save(List<SessionWrapper> sessions, List<MessageWrapper> messages, List<DuplicateIdDb> dupIds, List<IMState> bombs, List<IMState> dupes, List<IMState> recs) {
        ImSdkDbUtils.saveReceived(sessions, messages, dupIds, bombs, dupes, recs);
    }

    private void saveProcessed(List<MsgBean> list) {
        long id = list.get(list.size() - 1).getI();
        ImSdkDbUtils.update(OptHelper.getIns().getSyncUpdate("process", id));
    }

    private void sendState() {
        this.sendCallback.SendStates();
    }

    private void updateState(List<MsgBean> states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        ArrayList<UpdateArgs> args = new ArrayList<UpdateArgs>();
        for (MsgBean msg : states) {
            args.add(OptHelper.getIns().getSUpdate(ToolUtils.getLong(msg.getC()), msg.getStat()));
        }
        ImSdkDbUtils.updateBatch(args);
    }

    private void deleteStrictly(List<Long> serverIds) {
        List<MsgEntryDb> list = ImSdkDbUtils.queryStrictly(OptHelper.getIns().getMSISQuery(serverIds));
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> tags = new ArrayList<String>();
        for (MsgEntryDb msg : list) {
            if (!msg.isStrictlyDestroyed()) continue;
            ids.add(msg.getId());
            if (tags.contains(msg.getSession_flag())) continue;
            tags.add(msg.getSession_flag());
        }
        if (!ids.isEmpty()) {
            Map<String, Long> sessionIds = ImSdkDbUtils.querySessionIds(OptHelper.getIns().getSessoinIds(tags));
            ImSdkDbUtils.delete(OptHelper.getIns().getMDel(ids));
            for (String tag : tags) {
                if (ids.contains(sessionIds.get(tag))) {
                    MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getMQuery(tag), OptType.MQuery.NO);
                    if (msg != null && msg.getMsgEntryDb() != null) {
                        ImSdkDbUtils.update(OptHelper.getIns().getLUpdate(tag, msg.getMsgEntryDb().getId(), msg.getMsgEntryDb().getSort_time()));
                    }
                    SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
                    IMSession session = ModelMapper.getIns().mapSession(wrapper);
                    if (session == null) {
                        return;
                    }
                    ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
                }
                if (ImSdkDbUtils.queryStrictlyCount(OptHelper.getIns().getStrictlyQuery(tag)) != 0) continue;
                SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
                IMSession session = ModelMapper.getIns().mapSession(wrapper);
                ImSdkCallbackManager.getInstance().callStrictly(session);
            }
        }
    }

    private void loadFile(List<MessageWrapper> toSaveM) {
        if (!this.preLoad) {
            return;
        }
        if (toSaveM == null || toSaveM.isEmpty()) {
            return;
        }
        List<Long> serverIds = ModelMapper.getIns().getServerIds(toSaveM);
        if (serverIds.isEmpty()) {
            return;
        }
        List<MessageWrapper> messages = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMSQuery(serverIds), OptType.MQuery.ALL);
        ArrayList<MessageWrapper> files = new ArrayList<MessageWrapper>();
        for (MessageWrapper message : messages) {
            FileMsgDb file = message.getFileMsgDb();
            if (file == null || TextUtils.isEmpty((CharSequence)file.getFid())) continue;
            if (message.getMsgEntryDb().isFile() && file.needPreDownload()) {
                files.add(message);
            }
            if (!message.getMsgEntryDb().isWeb()) continue;
            files.add(message);
        }
        ImSdkFileManager.getInstance().downloadPreStart(files);
    }

    private boolean isSendOut(MsgBean msg) {
        return msg.getF().equals(this.account);
    }

    private boolean isRecReadBomb(MsgBean msg) {
        boolean isRec = !this.isSendOut(msg);
        boolean isRead = msg.isReadMsg();
        boolean isBomb = msg.isBombMsg();
        return isRec && isRead && isBomb;
    }

    private boolean isRecNewMsg(MsgBean msg) {
        boolean isRec = !this.isSendOut(msg);
        boolean isNew = msg.getStat() == 1;
        return isRec && isNew;
    }

    private boolean isRecBombed(MsgBean msg) {
        boolean isRec = !this.isSendOut(msg);
        boolean bombed = msg.getStat() == 4;
        boolean isBomb = msg.isBombMsg();
        return isRec && bombed && isBomb;
    }

    private boolean isDestroyedStrictly(MsgBean msg) {
        return msg.isStrictlyMsg() && msg.getStat() == 4;
    }

    private boolean isSame(MsgBean msg, MsgBean dup) {
        if (msg == null || dup == null) {
            return false;
        }
        return msg.getFst() == dup.getFst() && msg.getF().equals(dup.getF()) && msg.getTo().equals(dup.getTo()) && msg.getT() == dup.getT() && msg.getI() != dup.getI();
    }

    private boolean isSame(MsgBean msg, MessageWrapper wrapper) {
        if (msg == null || wrapper == null || wrapper.getMsgEntryDb() == null) {
            return false;
        }
        return msg.getFst() == wrapper.getMsgEntryDb().getCreate_time().longValue() && msg.getF().equals(wrapper.getMsgEntryDb().getSender()) && msg.getTo().equals(wrapper.getMsgEntryDb().getReceiver()) && msg.getT() == wrapper.getMsgEntryDb().getType().intValue();
    }

    private boolean queueIsEmpty() {
        return this.receivedQueue.isEmpty();
    }

    private Map<String, List<MessageWrapper>> classifyMessage(List<MessageWrapper> messages) {
        HashMap<String, List<MessageWrapper>> map = new HashMap<String, List<MessageWrapper>>();
        for (MessageWrapper message : messages) {
            String tag = message.getMsgEntryDb().getSession_flag();
            if (map.containsKey(tag)) {
                ((List)map.get(tag)).add(message);
                continue;
            }
            ArrayList<MessageWrapper> list = new ArrayList<MessageWrapper>();
            list.add(message);
            map.put(tag, list);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiveNode getNext() {
        ReceiveNode node = null;
        try {
            while (this.receivedThread != null && !this.receivedThread.isInterrupted() && (node = this.receivedQueue.poll()) == null) {
                LinkedBlockingQueue<ReceiveNode> linkedBlockingQueue = this.receivedQueue;
                synchronized (linkedBlockingQueue) {
                    this.receivedQueue.wait();
                }
            }
            return node;
        }
        catch (Exception ie) {
            Logger.getLogger().e("im exit receive queue...");
        }
        return node;
    }

    protected class ReceivedRunnable
    implements Runnable {
        protected ReceivedRunnable() {
        }

        @Override
        public void run() {
            try {
                while (ReceiveProcess.this.receivedThread != null && !ReceiveProcess.this.receivedThread.isInterrupted()) {
                    ReceiveNode node = ReceiveProcess.this.getNext();
                    if (node == null) {
                        return;
                    }
                    switch (node.getType()) {
                        case RECEIVE: {
                            ReceiveProcess.this.processReceived(node.getMessages());
                            break;
                        }
                        case DECRYPT: {
                            ReceiveProcess.this.processDecrypt(node.getFile(), node.getFileType());
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("im exit receive thread " + e);
            }
        }
    }
}

