/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.RandomStringUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileUtils {
    private static final long BUFFER_SIZE = 8192L;
    private static int RANDOM = 2;
    private static AsyncTask task;
    private static final Map<String, String> FILE_TYPES;

    public static String getParent(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return FileUtils.getDefaultParent();
        }
        return path + "XdjaIm" + File.separator;
    }

    public static String getRec(String path) {
        return FileUtils.getParent(path) + "FileRec" + File.separator;
    }

    public static String getDefaultParent() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "XdjaIm" + File.separator;
    }

    public static String getDefaultRec() {
        return FileUtils.getDefaultParent() + "FileRec" + File.separator;
    }

    public static String getVoicePath() {
        return FileUtils.getFilePath("Voice");
    }

    public static String getImagePath() {
        return FileUtils.getFilePath("Image");
    }

    public static String getVideoPath() {
        return FileUtils.getFilePath("Video");
    }

    public static String getWebFilePath() {
        return FileUtils.getFilePath("Web");
    }

    public static String getPicFilePath() {
        return FileUtils.getFilePath("Pic");
    }

    public static String getMediaFilePath() {
        return FileUtils.getFilePath("Media");
    }

    private static String getNormalPath() {
        return FileUtils.getFilePath("Normal");
    }

    public static String getUnknownPath() {
        String end = "Unknown" + File.separator;
        String path = ImSdkConfigManager.getInstance().getParentPath() + end;
        return FileUtils.initFile(path, end);
    }

    private static String getFilePath(String dir) {
        String end = dir + File.separator + RandomStringUtils.randomAlphanumeric(RANDOM) + File.separator + RandomStringUtils.randomAlphanumeric(RANDOM) + File.separator;
        String path = ImSdkConfigManager.getInstance().getParentPath() + end;
        return FileUtils.initFile(path, end);
    }

    private static String initFile(String path, String end) {
        if (ToolUtils.initFile(path)) {
            return path;
        }
        path = FileUtils.getDefaultParent() + end;
        if (ToolUtils.initFile(path)) {
            return path;
        }
        return FileUtils.getDefaultParent();
    }

    public static String getEncryptPath(int type, String name) {
        if (type == 0) {
            String path = FileUtils.getNormalPath() + name;
            return FileUtils.fileRename(path) + ".dat";
        }
        return FileUtils.getRanPath(type, name) + ".dat";
    }

    public static String getRanPath(int type, String name) {
        String path;
        switch (type) {
            case 1: {
                path = FileUtils.getVoicePath() + name;
                break;
            }
            case 3: {
                path = FileUtils.getImagePath() + name;
                break;
            }
            case 2: {
                path = FileUtils.getVideoPath() + name;
                break;
            }
            case 4: {
                path = FileUtils.getWebFilePath() + name;
                break;
            }
            case 5: {
                path = FileUtils.getPicFilePath() + name;
                break;
            }
            case 6: {
                path = FileUtils.getMediaFilePath() + name;
                break;
            }
            default: {
                path = FileUtils.getUnknownPath() + name;
            }
        }
        return FileUtils.fileRename(path);
    }

    public static String getFileRecPath(String name) {
        String path = ImSdkConfigManager.getInstance().getRecPath();
        path = ToolUtils.initFile(path) ? path + name : FileUtils.getDefaultRec() + name;
        return FileUtils.fileRename(path);
    }

    public static String subDat(String name) {
        return ToolUtils.subString(name, "dat");
    }

    public static String addDat(String name) {
        return name + ".dat";
    }

    public static String getName(String name) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        return RandomStringUtils.randomAlphanumeric(2);
    }

    public static long getCacheSize(List<String> paths) {
        String path = ImSdkConfigManager.getInstance().getCachePath();
        long size = 0L;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return size;
        }
        FileUtils.getFileSize(path, paths);
        return size;
    }

    public static String fileRename(String path) {
        String encryptPath = path + ".dat";
        File file = new File(path);
        File encryptFile = new File(encryptPath);
        String suffix = ToolUtils.getLastString(path, ".");
        String name = ToolUtils.subString(path, suffix);
        int count = 1;
        while (file.exists() || encryptFile.exists()) {
            if (TextUtils.isEmpty((CharSequence)suffix)) {
                path = name + "(" + count + ")";
                encryptPath = path + ".dat";
            } else {
                path = name + "(" + count + ")." + suffix;
                encryptPath = path + ".dat";
            }
            file = new File(path);
            encryptFile = new File(encryptPath);
            ++count;
        }
        return path;
    }

    public static void deleteFile(List<String> paths) {
        String path = ImSdkConfigManager.getInstance().getCachePath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        FileUtils.deleteFile(file, paths);
    }

    public static void deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        FileUtils.deleteFile(file, null);
    }

    public static void deleteFile(File file, List<String> paths) {
        if (file == null) {
            Logger.getLogger().e("ImSdk delete file null parameter");
            return;
        }
        try {
            boolean directory = file.isDirectory();
            if (directory) {
                File[] childFiles = file.listFiles();
                if (childFiles != null) {
                    for (File child : childFiles) {
                        FileUtils.deleteFile(child, paths);
                    }
                } else {
                    Logger.getLogger().d("ImSdk delete file child is null");
                }
            }
            if (FileUtils.invalidPath(file.getAbsolutePath(), paths) && !file.delete()) {
                Logger.getLogger().e("ImSdk delete file fail");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static String getSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index);
    }

    public static void save(@NonNull InputStream inputStream, long size, File file, long startsPoint) throws IOException {
        File directory = file.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new FileNotFoundException("Can't make directory " + directory);
        }
        if (startsPoint == 0L) {
            FileUtils.save(inputStream, file);
        } else {
            FileUtils.saveFromOffset(inputStream, size, file, startsPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(@NonNull InputStream inputStream, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int len;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                bufferedOutputStream.write(buffer, 0, len);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFromOffset(@NonNull InputStream inputStream, long size, File file, long startsPoint) throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileChannel channelOut = null;
        try {
            int len;
            randomAccessFile = new RandomAccessFile(file, "rwd");
            channelOut = randomAccessFile.getChannel();
            long bufferPosition = startsPoint;
            long bufferSize = Math.min(size, 8192L);
            MappedByteBuffer mappedBuffer = channelOut.map(FileChannel.MapMode.READ_WRITE, bufferPosition, bufferSize);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                if (mappedBuffer.remaining() < len) {
                    bufferSize = Math.min(size + startsPoint - (bufferPosition += (long)mappedBuffer.position()), 8192L);
                    mappedBuffer = channelOut.map(FileChannel.MapMode.READ_WRITE, bufferPosition, bufferSize);
                }
                mappedBuffer.put(buffer, 0, len);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (channelOut != null) {
                try {
                    channelOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private static void getFileSize(String path, List<String> paths) {
        Logger.getLogger().d("ImSdk cache get " + task);
        if (task != null) {
            return;
        }
        task = new AsyncTask(){
            private long size;

            protected Object doInBackground(Object ... params) {
                String path = (String)params[0];
                List pathList = (List)params[1];
                this.size = 0L;
                this.getSize(path, pathList);
                Logger.getLogger().d("ImSdk cache get end " + task);
                ImSdkCallbackManager.getInstance().callCacheSize(true, this.size);
                task = null;
                return null;
            }

            private void getSize(String path, List<String> paths) {
                if (this.isCancelled()) {
                    return;
                }
                File file = new File(path);
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    if (listFiles == null) {
                        return;
                    }
                    for (File f : listFiles) {
                        if (this.isCancelled()) {
                            return;
                        }
                        this.getSize(f.getPath(), paths);
                    }
                } else if (FileUtils.invalidPath(file.getAbsolutePath(), paths)) {
                    this.size += file.length();
                    Logger.getLogger().d("ImSdk cache getting " + task);
                    ImSdkCallbackManager.getInstance().callCacheSize(false, this.size);
                }
            }
        }.execute(new Object[]{path, paths});
    }

    private static boolean invalidPath(String path, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return true;
        }
        for (String p : paths) {
            if (TextUtils.isEmpty((CharSequence)p)) {
                return false;
            }
            if (!p.equalsIgnoreCase(path)) continue;
            return false;
        }
        return true;
    }

    private static void initAllFileTypes() {
        FILE_TYPES.put("FFD8FF", "jpg");
        FILE_TYPES.put("89504E47", "png");
        FILE_TYPES.put("47494638", "gif");
        FILE_TYPES.put("49492A00", "tif");
        FILE_TYPES.put("424D", "bmp");
        FILE_TYPES.put("41433130", "dwg");
        FILE_TYPES.put("38425053", "psd");
        FILE_TYPES.put("7B5C727466", "rtf");
        FILE_TYPES.put("3C3F786D6C", "xml");
        FILE_TYPES.put("44656C69766572792D646174653A", "eml");
        FILE_TYPES.put("D0CF11E0", "doc");
        FILE_TYPES.put("5374616E64617264204A", "mdb");
        FILE_TYPES.put("252150532D41646F6265", "ps");
        FILE_TYPES.put("255044462D312E", "pdf");
        FILE_TYPES.put("52617221", "rar");
        FILE_TYPES.put("57415645", "wav");
        FILE_TYPES.put("41564920", "avi");
        FILE_TYPES.put("2E524D46", "rm");
        FILE_TYPES.put("000001BA", "mpg");
        FILE_TYPES.put("000001B3", "mpg");
        FILE_TYPES.put("6D6F6F76", "mov");
        FILE_TYPES.put("3026B2758E66CF11", "asf");
        FILE_TYPES.put("4D546864", "mid");
        FILE_TYPES.put("1F8B08", "gz");
        FILE_TYPES.put("2321414D520A", "amr");
        FILE_TYPES.put("000000186674", "mp4");
        FILE_TYPES.put("FFFAA0404F0A", "mp3");
        FILE_TYPES.put("3C21444F4354", "html");
        FILE_TYPES.put("504B0304140006000800", "docx");
        FILE_TYPES.put("504B0304140008080800", "zip");
    }

    @Nullable
    public static String getFileType(String filePath) {
        String header = FileUtils.getFileHeader(filePath);
        if (header != null) {
            Set<String> keySet = FILE_TYPES.keySet();
            for (String key : keySet) {
                if (!header.startsWith(key) && !key.startsWith(header)) continue;
                return FILE_TYPES.get(key);
            }
        }
        Logger.getLogger().w("File type not found: filePath=" + filePath + ", header=" + header);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getFileHeader(String filePath) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            byte[] b = new byte[10];
            if (fileInputStream.read(b) != -1) {
                String string = FileUtils.bytesToHexString(b);
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Nullable
    private static String bytesToHexString(byte[] src) {
        if (src == null || src.length <= 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : src) {
            String hex = Integer.toHexString(b & 0xFF).toUpperCase();
            if (hex.length() < 2) {
                builder.append(0);
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    static {
        FILE_TYPES = new HashMap<String, String>();
        FileUtils.initAllFileTypes();
    }
}

