/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.util.Log;
import com.xdja.imsdk.logger.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThumbnailUtils {
    public static final int KIND_TH = 1;
    public static final int KIND_HD = 2;
    private static final int MAX_NUM_PIXELS_THUMBNAIL = 172800;
    private static final int MAX_NUM_PIXELS_HD_THUMBNAIL = 921600;
    private static final int UNCONSTRAINED = -1;
    private static final int FILE_SIZE = 0x100000;
    public static final float RATIO = 3.0f;
    public static final int TARGET_SIZE_MINI_THUMBNAIL = 320;
    public static final int TARGET_SIZE_HD_THUMBNAIL = 720;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createImageThumbnail(String filePath, int kind, File saveFile) {
        boolean wantMini = kind == 1;
        int targetSize = wantMini ? 320 : 720;
        int maxPixels = wantMini ? 172800 : 921600;
        int quality = 80;
        Bitmap bitmap = null;
        FileInputStream stream = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inSampleSize = 1;
            stream = new FileInputStream(filePath);
            FileDescriptor fd = stream.getFD();
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            if (options.mCancel || options.outWidth <= 0 || options.outHeight <= 0) {
                String string = null;
                return string;
            }
            int outWidth = options.outWidth;
            int outHeight = options.outHeight;
            if ((float)outWidth * 1.0f / (float)outHeight >= 3.0f || (float)outHeight * 1.0f / (float)outWidth >= 3.0f) {
                if (wantMini) {
                    if ((float)outWidth * 1.0f / (float)outHeight >= 3.0f) {
                        outHeight = Math.min(outHeight, 1920);
                        bitmap = ThumbnailUtils.cropCenterBitmap(filePath, options, (int)((float)outHeight * 3.0f), outHeight);
                    } else {
                        outWidth = Math.min(outWidth, 1080);
                        bitmap = ThumbnailUtils.cropCenterBitmap(filePath, options, outWidth, (int)((float)outWidth * 3.0f));
                    }
                } else if ((float)outWidth * 1.0f / (float)outHeight >= 3.0f) {
                    outHeight = Math.min(outHeight, 1920);
                    bitmap = ThumbnailUtils.createBitmap(ThumbnailUtils.getDegree(filePath), ThumbnailUtils.readImage(filePath, options, outHeight, (int)((float)outHeight * 3.0f)));
                } else {
                    outWidth = Math.min(outWidth, 1080);
                    bitmap = ThumbnailUtils.createBitmap(ThumbnailUtils.getDegree(filePath), ThumbnailUtils.readImage(filePath, options, (int)((float)outWidth * 3.0f), outWidth));
                }
            } else {
                boolean copy;
                if (wantMini) {
                    copy = outWidth <= 360 && outHeight <= 480;
                } else if (stream.available() <= 0x100000) {
                    if (outWidth <= 7300 && outHeight <= 5500) {
                        copy = true;
                        Logger.getLogger().d("get thumbnail hd filePath = " + filePath);
                    } else {
                        copy = false;
                    }
                } else {
                    copy = false;
                }
                Logger.getLogger().d("get thumbnail result = " + filePath + ", copy = " + copy);
                if (copy) {
                    bitmap = ThumbnailUtils.createBitmap(ThumbnailUtils.getDegree(filePath), BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, null));
                    quality = 100;
                } else {
                    options.inSampleSize = ThumbnailUtils.computeSampleSize(options, targetSize, maxPixels);
                    options.inJustDecodeBounds = false;
                    options.inDither = false;
                    bitmap = ThumbnailUtils.createBitmap(ThumbnailUtils.getDegree(filePath), BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options));
                    quality = 80;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {}
        }
        return ThumbnailUtils.saveBitmap(bitmap, quality, saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap readImage(String originalPath, BitmapFactory.Options options, int height, int width) {
        FileInputStream fis = null;
        int oomWidth = 0;
        int oomHeight = 0;
        try {
            fis = new FileInputStream(new File(originalPath));
            FileDescriptor fd = fis.getFD();
            options.inJustDecodeBounds = false;
            options.inDither = false;
            oomWidth = options.outWidth;
            oomHeight = options.outHeight;
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"ThumbnailUtil", (String)("ERROR: " + e));
            if (height > 0 && width > 0) {
                Bitmap bitmap = ThumbnailUtils.oomBitmap(originalPath, options, oomHeight, oomWidth, width, height);
                return bitmap;
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap oomBitmap(String originalPath, BitmapFactory.Options options, int width, int height, int reqHeight, int reqWidth) {
        if (reqHeight <= 0 || reqWidth <= 0) {
            return null;
        }
        if (width > 1080 && height > 1920) {
            options.inSampleSize = (int)Math.max((float)width * 1.0f / (float)reqWidth, (float)height * 1.0f / (float)reqHeight);
        }
        options.inDither = false;
        options.inPurgeable = true;
        options.outWidth = width;
        options.outHeight = height;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(originalPath));
            FileDescriptor fd = fis.getFD();
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"ThumbnailUtil", (String)("ERROR: " + e));
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap createBitmap(int degree, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap rotateBitmap = null;
        try {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degree);
            Bitmap bitmap2 = rotateBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        finally {
            if (!bitmap.equals(rotateBitmap)) {
                bitmap.recycle();
            }
        }
        return null;
    }

    public static int getDegree(String filePath) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private static Bitmap cropCenterBitmap(String filePath, BitmapFactory.Options options, int reqWidth, int reqHeight) {
        Bitmap bitmap;
        if (options.outWidth > 1080 && options.outHeight > 1920) {
            options.inSampleSize = (int)Math.max((float)options.outWidth * 1.0f / (float)reqWidth, (float)options.outHeight * 1.0f / (float)reqHeight);
        }
        if ((bitmap = ThumbnailUtils.readImage(filePath, options, 0, 0)) == null) {
            Log.d((String)"ThumbnailUtils", (String)"read bitmap error!!");
            return null;
        }
        int xTopLeft = 0;
        int yTopLeft = 0;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > reqWidth) {
            xTopLeft = (width - reqWidth) / 2;
        } else {
            reqWidth = width;
        }
        if (height > reqHeight) {
            yTopLeft = (height - reqHeight) / 2;
        } else {
            reqHeight = height;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)ThumbnailUtils.getDegree(filePath));
        try {
            Bitmap output = Bitmap.createBitmap((Bitmap)bitmap, (int)xTopLeft, (int)yTopLeft, (int)reqWidth, (int)reqHeight, (Matrix)matrix, (boolean)true);
            if (!bitmap.equals(output)) {
                bitmap.recycle();
            }
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = ThumbnailUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBitmap(Bitmap bitmap, int quality, File saveFile) {
        if (saveFile == null || bitmap == null) {
            return null;
        }
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        FilterOutputStream bos = null;
        boolean bSaveRet = false;
        try {
            saveFile.createNewFile();
            bos = new BufferedOutputStream(new FileOutputStream(saveFile));
            bSaveRet = bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)bos);
            ((BufferedOutputStream)bos).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bSaveRet ? saveFile.getAbsolutePath() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFile(String srcFilePath, File destFile) {
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists()) {
            return null;
        }
        if (destFile.exists()) {
            return srcFilePath;
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(srcFilePath));
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
            destFile.createNewFile();
            byte[] buffer = new byte[1024];
            int readLen = 0;
            while ((readLen = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readLen);
            }
            ((BufferedOutputStream)bos).flush();
            String string = destFile.getAbsolutePath();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return srcFilePath;
    }
}

