/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.DbHelper;
import com.xdja.imsdk.db.helper.SqlBuilder;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDao<T> {
    protected static final Object DB_LOCK = new Object();

    protected long insert(T entry, String sql) {
        return this.executeInsert(entry, sql);
    }

    protected void insertBatch(Iterable<T> entries, String sql) {
        this.executeInsertBatch(entries, sql);
    }

    protected void insertBatchUpgrade(SQLiteDatabase db, Iterable<T> entries, String sql) {
        this.executeUpgradeInsertBatch(db, entries, sql);
    }

    protected int delete(String sql) {
        return this.executeDelete(sql);
    }

    protected void update(UpdateArgs args) {
        String tableName = args.getName();
        ContentValues values = args.getValues();
        String[] whereClause = args.getWhereClause();
        String[] whereArgs = args.getWhereArgs();
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        String[] bindArgs = new String[bindArgsSize];
        String[] valuesColumns = new String[setValuesSize];
        int i = 0;
        String[] stringArray = values.keySet().iterator();
        while (stringArray.hasNext()) {
            String colName;
            valuesColumns[i] = colName = (String)stringArray.next();
            bindArgs[i++] = String.valueOf(values.get(colName));
        }
        if (whereArgs != null) {
            for (String where : whereArgs) {
                bindArgs[i++] = where;
            }
        }
        String sql = SqlBuilder.updateSql(tableName, valuesColumns, whereClause);
        this.executeUpdate(sql, bindArgs);
    }

    protected void updateBatch(String sql, List<UpdateArgs> args) {
        if (args == null || args.isEmpty()) {
            return;
        }
        ArrayList<String[]> bindArgsList = new ArrayList<String[]>();
        for (UpdateArgs arg : args) {
            ContentValues values = arg.getValues();
            String[] whereArgs = arg.getWhereArgs();
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            String[] bindArgs = new String[bindArgsSize];
            int i = 0;
            for (String colName : values.keySet()) {
                bindArgs[i++] = String.valueOf(values.get(colName));
            }
            if (whereArgs != null) {
                for (String where : whereArgs) {
                    bindArgs[i++] = where;
                }
            }
            bindArgsList.add(bindArgs);
        }
        this.executeUpdateBatch(sql, bindArgsList);
    }

    protected long insert(SQLiteDatabase db, T entry, String sql) {
        return this.executeInsert(db, entry, sql);
    }

    protected void insertBatch(SQLiteDatabase db, Iterable<T> entries, String sql) {
        this.executeInsertBatch(db, entries, sql);
    }

    protected void update(SQLiteDatabase db, UpdateArgs args) {
        if (args == null) {
            return;
        }
        String tableName = args.getName();
        ContentValues values = args.getValues();
        String[] whereClause = args.getWhereClause();
        String[] whereArgs = args.getWhereArgs();
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        String[] bindArgs = new String[bindArgsSize];
        String[] valuesColumns = new String[setValuesSize];
        int i = 0;
        String[] stringArray = values.keySet().iterator();
        while (stringArray.hasNext()) {
            String colName;
            valuesColumns[i] = colName = (String)stringArray.next();
            bindArgs[i++] = String.valueOf(values.get(colName));
        }
        if (whereArgs != null) {
            for (String where : whereArgs) {
                bindArgs[i++] = where;
            }
        }
        String sql = SqlBuilder.updateSql(tableName, valuesColumns, whereClause);
        this.executeUpdate(db, sql, bindArgs);
    }

    protected void updateBatch(SQLiteDatabase db, String sql, List<UpdateArgs> args) {
        if (args == null || args.isEmpty()) {
            return;
        }
        ArrayList<String[]> bindArgsList = new ArrayList<String[]>();
        for (UpdateArgs arg : args) {
            ContentValues values = arg.getValues();
            String[] whereArgs = arg.getWhereArgs();
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            String[] bindArgs = new String[bindArgsSize];
            int i = 0;
            for (String colName : values.keySet()) {
                bindArgs[i++] = values.get(colName) + "";
            }
            if (whereArgs != null) {
                for (String where : whereArgs) {
                    bindArgs[i++] = where;
                }
            }
            bindArgsList.add(bindArgs);
        }
        this.executeUpdateBatch(db, sql, bindArgsList);
    }

    protected Cursor query(String sql) {
        return this.executeQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCursor(Cursor cursor) {
        Object object = DB_LOCK;
        synchronized (object) {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeInsert(T entity, String sql) {
        long rowId = 0L;
        Object object = DB_LOCK;
        synchronized (object) {
            SQLiteDatabase db = DbHelper.getInstance().getDatabase();
            SQLiteStatement stmt = db.compileStatement(sql);
            db.beginTransaction();
            try {
                this.bindValues(stmt, entity);
                rowId = stmt.executeInsert();
                db.setTransactionSuccessful();
            }
            catch (SQLException e) {
                long l;
                try {
                    e.printStackTrace();
                    l = -5L;
                }
                catch (Throwable throwable) {
                    try {
                        db.endTransaction();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        Logger.getLogger().e("database already closed !!!");
                    }
                }
                db.endTransaction();
                return l;
            }
            db.endTransaction();
            return rowId;
        }
    }

    private long executeInsert(SQLiteDatabase db, T entity, String sql) {
        long rowId = 0L;
        try {
            SQLiteStatement stmt = db.compileStatement(sql);
            this.bindValues(stmt, entity);
            rowId = stmt.executeInsert();
        }
        catch (Exception e) {
            Logger.getLogger().e("database already closed !!!");
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpgradeInsertBatch(SQLiteDatabase db, Iterable<T> entities, String sql) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteStatement stmt = db.compileStatement(sql);
                db.beginTransaction();
                try {
                    for (T entity : entities) {
                        this.bindValues(stmt, entity);
                        stmt.executeInsert();
                    }
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsertBatch(Iterable<T> entities, String sql) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                SQLiteStatement stmt = db.compileStatement(sql);
                db.beginTransaction();
                try {
                    for (T entity : entities) {
                        this.bindValues(stmt, entity);
                        stmt.executeInsert();
                    }
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    private void executeInsertBatch(SQLiteDatabase db, Iterable<T> entities, String sql) {
        try {
            SQLiteStatement stmt = db.compileStatement(sql);
            for (T entity : entities) {
                this.bindValues(stmt, entity);
                stmt.executeInsert();
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("database already closed !!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeDelete(String sql) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                db.beginTransaction();
                try {
                    db.execSQL(sql);
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    int n = -5;
                    return n;
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(String sql, String[] bindArgs) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                SQLiteStatement stmt = db.compileStatement(sql);
                db.beginTransaction();
                try {
                    stmt.bindAllArgsAsStrings(bindArgs);
                    stmt.execute();
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    private void executeUpdate(SQLiteDatabase db, String sql, String[] bindArgs) {
        try {
            SQLiteStatement stmt = db.compileStatement(sql);
            stmt.bindAllArgsAsStrings(bindArgs);
            stmt.execute();
        }
        catch (Exception e) {
            Logger.getLogger().e("database already closed !!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateBatch(String sql, List<String[]> bindArgsList) {
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                SQLiteStatement stmt = db.compileStatement(sql);
                db.beginTransaction();
                try {
                    for (String[] bindArgs : bindArgsList) {
                        stmt.bindAllArgsAsStrings(bindArgs);
                        stmt.execute();
                    }
                    db.setTransactionSuccessful();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
        }
    }

    private void executeUpdateBatch(SQLiteDatabase db, String sql, List<String[]> bindArgsList) {
        try {
            SQLiteStatement stmt = db.compileStatement(sql);
            for (String[] bindArgs : bindArgsList) {
                stmt.bindAllArgsAsStrings(bindArgs);
                stmt.execute();
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("database already closed !!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor executeQuery(String sql) {
        Cursor cursor = null;
        Object object = DB_LOCK;
        synchronized (object) {
            try {
                String[] args = null;
                SQLiteDatabase db = DbHelper.getInstance().getDatabase();
                cursor = db.rawQuery(sql, args);
            }
            catch (Exception e) {
                Logger.getLogger().e("database already closed !!!");
            }
            return cursor;
        }
    }

    protected abstract T readEntry(Cursor var1, int var2);

    protected abstract void bindValues(SQLiteStatement var1, T var2);
}

