/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SecurityHttps {
    private static final String DEFAULT_PASSWORD = "111111";

    public static SSLParams getSSLParams(Context context, int storeId, String pwd) {
        SSLParams sslParams = new SSLParams();
        sslParams.sSLSocketFactory = SecurityHttps.getSSLSocketFactory(context, storeId, SecurityHttps.getPwd(pwd));
        return sslParams;
    }

    private static String getPwd(String pwd) {
        String password = "";
        password = TextUtils.isEmpty((CharSequence)pwd) ? DEFAULT_PASSWORD : pwd;
        return password;
    }

    private static SSLSocketFactory getSSLSocketFactory(Context context, int storeId, String pwd) {
        SSLContext sslContext = SecurityHttps.getSSLContext(SecurityHttps.readKeyStore(context, storeId, pwd), pwd);
        if (sslContext == null) {
            return null;
        }
        return sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore readKeyStore(Context context, int res, String password) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inputStream = context.getResources().openRawResource(res);
            keyStore.load(inputStream, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ce) {
            Logger.getLogger().i(ce.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ie) {
                    Logger.getLogger().i(ie.getMessage());
                }
            }
        }
        return keyStore;
    }

    @SuppressLint(value={"TrulyRandom"})
    private static SSLContext getSSLContext(KeyStore keyStore, String password) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ne) {
            Logger.getLogger().i(ne.getMessage());
        }
        return sslContext;
    }

    public static class SSLParams {
        public SSLSocketFactory sSLSocketFactory;
        public X509TrustManager trustManager;
    }
}

