/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.security.SignResult;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class SignInterceptor
implements Interceptor {
    @NonNull
    private String mType;
    @NonNull
    private String mFileId;
    private SignResult mSignResult;

    public SignInterceptor(@NonNull String type, @Nullable String fileId) {
        this.mType = type;
        this.mFileId = TextUtils.isEmpty((CharSequence)fileId) ? "Unknown" : fileId;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().url(this.createSignUrl(chain.request().url())).build();
        return chain.proceed(request);
    }

    @NonNull
    public HttpUrl createSignUrl(@NonNull HttpUrl originUrl) {
        if (originUrl.queryParameter("sign") != null) {
            return originUrl;
        }
        HttpUrl url = originUrl;
        if (this.mSignResult == null) {
            this.mSignResult = ImSdkCallbackManager.getInstance().getSign(this.mType, this.mFileId);
        }
        if (this.mSignResult != null) {
            url = url.newBuilder().addQueryParameter("sign", this.mSignResult.getSign()).addQueryParameter("ts", this.mSignResult.getTs()).addQueryParameter("userid", this.mSignResult.getUserId()).build();
        }
        return url;
    }
}

