/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.msg;

import android.text.TextUtils;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.bean.LocalStateMsgDb;
import com.xdja.imsdk.db.bean.SyncIdDb;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.http.bean.StateBean;
import com.xdja.imsdk.http.result.FailStateResult;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.manager.msg.PullAccord;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MsgManagerHelper {
    public static void initSyncDb() {
        ArrayList<SyncIdDb> ids = new ArrayList<SyncIdDb>();
        ids.add(ModelMapper.getIns().getSync(0L, "max"));
        ids.add(ModelMapper.getIns().getSync(0L, "last"));
        ids.add(ModelMapper.getIns().getSync(0L, "process"));
        ids.add(ModelMapper.getIns().getSync(0L, "state"));
        ids.add(ModelMapper.getIns().getSync(0L, "end"));
        ImSdkDbUtils.saveSyncIdBatch(ids);
    }

    public static void updateSyncDb(PullAccord accord, boolean success) {
        Logger.getLogger().d("ImSdk update sync id " + accord + success);
        ArrayList<UpdateArgs> updateArgs = new ArrayList<UpdateArgs>();
        if (success) {
            UpdateArgs maxUpdate = OptHelper.getIns().getSyncUpdate("max", accord.getMaxId());
            UpdateArgs lastUpdate = OptHelper.getIns().getSyncUpdate("last", accord.getLastId());
            UpdateArgs successState = OptHelper.getIns().getSyncUpdate("state", 0L);
            updateArgs.add(maxUpdate);
            updateArgs.add(lastUpdate);
            updateArgs.add(successState);
            if (ImSdkDbUtils.syncVersionOld()) {
                ArrayList<SyncIdDb> ids = new ArrayList<SyncIdDb>();
                ids.add(ModelMapper.getIns().getSync(0L, "end"));
                ImSdkDbUtils.saveSyncId(ids);
            } else {
                UpdateArgs endUpdate = OptHelper.getIns().getSyncUpdate("end", accord.getEndId());
                updateArgs.add(endUpdate);
            }
        } else {
            UpdateArgs failState = OptHelper.getIns().getSyncUpdate("state", 1L);
            updateArgs.add(failState);
            if (ImSdkDbUtils.syncVersionOld()) {
                ArrayList<SyncIdDb> ids = new ArrayList<SyncIdDb>();
                ids.add(ModelMapper.getIns().getSync(0L, "end"));
                ImSdkDbUtils.saveSyncId(ids);
            }
        }
        ImSdkDbUtils.updateBatch(updateArgs);
    }

    public static void updateProcessId(long id) {
        ImSdkDbUtils.update(OptHelper.getIns().getSyncUpdate("process", id));
    }

    public static void querySyncAccord(PullAccord accord) {
        long state = ImSdkDbUtils.querySyncId("state");
        long maxId = ImSdkDbUtils.querySyncId("max");
        long lastId = ImSdkDbUtils.querySyncId("last");
        long processId = ImSdkDbUtils.querySyncId("process");
        accord.setLastId(lastId);
        accord.setMaxId(maxId);
        if (state == 1L) {
            long end = ImSdkDbUtils.syncVersionOld() ? maxId : ImSdkDbUtils.querySyncId("end");
            accord.setEndId(end);
        } else {
            long end;
            if (maxId == 0L || lastId == 0L || processId == 0L) {
                end = 0L;
                accord.setEndId(end);
            }
            end = processId == lastId ? maxId : lastId;
            accord.setEndId(end);
        }
    }

    public static void saveTime(long time) {
        HashMap<String, String> timeMap = new HashMap<String, String>();
        timeMap.put("diff", String.valueOf(time));
        ImSdkConfigManager.getInstance().saveConfig(timeMap);
    }

    public static void sendTextSuccess(String flagId, String serverId) {
        ImSdkDbUtils.update(OptHelper.getIns().getMSUpdate(flagId, serverId));
    }

    public static void updateMessage(String id, int code) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            return;
        }
        ImSdkDbUtils.update(OptHelper.getIns().getMFUpdate(id, code));
    }

    public static void deleteState(String id) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            return;
        }
        ImSdkDbUtils.delete(OptHelper.getIns().getLSDel(id));
    }

    public static void saveFailState(List<FailStateResult> failStates, String account) {
        ArrayList<StateBean> stateBeans = new ArrayList<StateBean>();
        if (failStates == null || failStates.isEmpty()) {
            return;
        }
        for (FailStateResult state : failStates) {
            if (state.getRes() != 553 && state.getRes() != 550) continue;
            StateBean stateBean = new StateBean();
            stateBean.setStat(state.getStat());
            stateBean.setC(state.getMsgid() + "");
            stateBean.setT(state.getT());
            stateBean.setTo(state.getTo());
            stateBean.setF(account);
            stateBeans.add(stateBean);
        }
        if (!stateBeans.isEmpty()) {
            LocalStateMsgDb localStatus = new LocalStateMsgDb();
            localStatus.setContent(JsonUtils.getGson().toJson(stateBeans));
            localStatus.setSendTime(ImSdkConfigManager.getInstance().getCurrentMillis());
            ImSdkDbUtils.saveLocal(localStatus);
        }
    }

    public static void recallSuccess(long id, String content) {
        ImSdkDbUtils.update(OptHelper.getIns().getRCUpdate(id, content));
        ImSdkDbUtils.delete(OptHelper.getIns().getFileDel(id));
        ImSdkDbUtils.delete(OptHelper.getIns().getHDDel(id));
        ImSdkDbUtils.delete(OptHelper.getIns().getRawDel(id));
    }

    public static boolean isSent(List<MsgBean> list, String account) {
        if (list == null || list.isEmpty() || TextUtils.isEmpty((CharSequence)account)) {
            return false;
        }
        boolean result = true;
        for (MsgBean msg : list) {
            if (account.equals(msg.getF()) || msg.isStateMsg() || !msg.isUnReceiveMsg()) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isAssistant(List<MsgBean> list, String account) {
        if (list == null || list.isEmpty() || TextUtils.isEmpty((CharSequence)account)) {
            return false;
        }
        boolean result = false;
        for (MsgBean msg : list) {
            if (!account.equals(msg.getF()) || !msg.isAssistant()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void callbackSendResult(String id) {
        MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(ToolUtils.getLong(id)), OptType.MQuery.ALL);
        if (msg.getMsgEntryDb() == null) {
            return;
        }
        SessionWrapper session = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(msg.getMsgEntryDb().getSession_flag()), OptType.SQuery.HAVE);
        ImSdkCallbackManager.getInstance().callChange(ModelMapper.getIns().mapSession(session), ModelMapper.getIns().mapMessage(msg));
    }

    public static void callbackRemind(String id) {
        MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMAQuery(ToolUtils.getLong(id)), OptType.MQuery.ALL);
        if (msg.getMsgEntryDb() == null) {
            return;
        }
        SessionWrapper session = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(msg.getMsgEntryDb().getSession_flag()), OptType.SQuery.HAVE);
        ImSdkCallbackManager.getInstance().callChange(ModelMapper.getIns().mapSession(session), ModelMapper.getIns().mapMessage(msg));
    }

    public static void callbackRecallResult(long id, int code) {
        if (id > 0L) {
            MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getMIQuery(id), OptType.MQuery.NO);
            if (msg.getMsgEntryDb() == null) {
                return;
            }
            SessionWrapper session = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(msg.getMsgEntryDb().getSession_flag()), OptType.SQuery.HAVE);
            ImSdkCallbackManager.getInstance().callRecall(ModelMapper.getIns().mapSession(session), ModelMapper.getIns().mapMessage(msg), code);
        }
    }
}

