/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.cache.impl;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.common.cache.entity.DeviceEntity;
import com.xdja.im.common.cache.entity.ServerEntity;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.persistent.PropertyUtil;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class ConfigCacheImpl
implements ConfigCache {
    public static final String PRONAME = "im_uikit_config.conf";
    public static final String DEVICE_TYPE = "deviceType";
    public static final String PLATFORM_TYPE = "platformType";
    public static final String EXT_TYPE = "extType";
    public static final String HASAT = "hasAt";
    public static final String FILESIZE = "fileSize";
    public static final String FACESIZE = "faceSize";
    public static final String SESSIONFACESIZE = "sessionFaceSize";
    public static final String SERVER_IM_URL = "imUrl";
    public static final String SERVER_MX_URL = "mxUrl";
    public static final String SERVER_USER_ID = "userid";
    public static final String SERVER_USER_SECRET = "usersecret";
    public static final String SERVER_FASTDFS_ADDR = "fastDfsAddr";
    public static final String SERVER_FASTDFS_PORT = "fastDfsPort";
    public static final int DEFAULT_DEVICE_TYPE = 1;
    public static final int DEFAULT_PLATFORM_TYPE = 0;
    public static final int DEFAULT_EXT_TYPE = 0;
    public static final int DEFAULT_HASFORWARD = 0;
    public static final int DEFAULT_FILESIZE = 100;
    public static final double DEFAULT_FACESIZE = 1.1;
    public static final double DEFAULT_SESSIONFACESIZE = 0.8;
    private Map<String, String> configEntity;
    private DeviceEntity deviceEntity;
    private ServerEntity serverEntity;
    private PropertyUtil propertyUtil;

    @Inject
    public ConfigCacheImpl(PropertyUtil propertyUtil) {
        this.propertyUtil = propertyUtil;
        if (this.configEntity == null || this.configEntity.isEmpty()) {
            this.configEntity = this.get();
        }
        this.deviceEntity = new DeviceEntity();
        int deviceId = 1;
        int platform = 0;
        int extType = 0;
        int hasAt = 0;
        int fileSize = 100;
        double faceSize = 1.1;
        double sessionFaceSize = 0.8;
        try {
            deviceId = TextUtils.isEmpty((CharSequence)this.configEntity.get(DEVICE_TYPE)) ? 1 : Integer.valueOf(this.configEntity.get(DEVICE_TYPE));
            platform = TextUtils.isEmpty((CharSequence)this.configEntity.get(PLATFORM_TYPE)) ? 0 : Integer.valueOf(this.configEntity.get(PLATFORM_TYPE));
            extType = TextUtils.isEmpty((CharSequence)this.configEntity.get(EXT_TYPE)) ? 0 : Integer.valueOf(this.configEntity.get(EXT_TYPE));
            hasAt = TextUtils.isEmpty((CharSequence)this.configEntity.get(HASAT)) ? 0 : Integer.valueOf(this.configEntity.get(HASAT));
            fileSize = TextUtils.isEmpty((CharSequence)this.configEntity.get(FILESIZE)) ? 100 : Integer.valueOf(this.configEntity.get(FILESIZE));
            faceSize = TextUtils.isEmpty((CharSequence)this.configEntity.get(FACESIZE)) ? 1.1 : Double.valueOf(this.configEntity.get(FACESIZE));
            sessionFaceSize = TextUtils.isEmpty((CharSequence)this.configEntity.get(FACESIZE)) ? 0.8 : Double.valueOf(this.configEntity.get(SESSIONFACESIZE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deviceEntity.setDeviceType(deviceId);
        this.deviceEntity.setPlatformType(platform);
        this.deviceEntity.setExtType(extType);
        this.deviceEntity.setHasAt(hasAt);
        this.deviceEntity.setFileSize(fileSize);
        this.deviceEntity.setFaceSize(faceSize);
        this.deviceEntity.setSessionFaceSize(sessionFaceSize);
        this.serverEntity = new ServerEntity();
        this.serverEntity.setImUrl(this.configEntity.get(SERVER_IM_URL));
        this.serverEntity.setMxUrl(this.configEntity.get(SERVER_MX_URL));
    }

    @Override
    @Nullable
    public Map<String, String> get() {
        this.configEntity = new HashMap<String, String>();
        this.propertyUtil.load(PRONAME);
        this.configEntity = this.propertyUtil.getAll();
        return this.configEntity;
    }

    @Override
    public DeviceEntity getDevice() {
        return this.deviceEntity;
    }

    @Override
    public ServerEntity getServer() {
        return this.serverEntity;
    }
}

