/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.imageloader;

import android.app.Activity;
import android.content.Context;
import android.widget.ImageView;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestManager;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.uikit.R;

public class GlideImageLoader
implements ImageLoader {
    @Override
    public void loadImage(Activity activity, ImageView target, String path, ImageView.ScaleType type, int width, int height) {
        RequestManager requestManager = Glide.with((Activity)activity);
        DrawableTypeRequest builder = requestManager.load(path);
        if (type == ImageView.ScaleType.CENTER_CROP) {
            builder.centerCrop();
        }
        if (width > 0 && height > 0) {
            builder.override(width, height);
        }
        builder.error(R.mipmap.im_uikit_pic_default).priority(Priority.HIGH).dontTransform().dontAnimate().into(target);
    }

    @Override
    public void clearMemoryCache(Activity activity) {
        Glide.get((Context)activity).clearMemory();
    }
}

