/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.router;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.SparseArray;
import com.xdja.im.common.router.annotations.ClassName;
import com.xdja.im.common.router.annotations.Component;
import com.xdja.im.common.router.annotations.Key;
import com.xdja.im.common.router.annotations.RequestCode;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;

public class IntentWrapper {
    private int mFlags;
    private Context mContext;
    private Bundle mExtras;
    private String mClassName;
    private ComponentName mComponent;
    private int mRequestCode = -1;
    private Intent mIntent;

    IntentWrapper(Context context, String className, Bundle extras, int flags, int requestCode) {
        this.mFlags = flags;
        this.mContext = context;
        this.mExtras = extras;
        this.mClassName = className;
        this.mRequestCode = requestCode;
        this.mIntent = new Intent();
        this.mIntent.setClassName(this.mContext, this.mClassName);
        this.mIntent.putExtras(this.mExtras);
        this.mIntent.addFlags(this.mFlags);
    }

    public IntentWrapper(Context context, ComponentName component, Bundle extras, int flags, int requestCode) {
        this.mFlags = flags;
        this.mContext = context;
        this.mExtras = extras;
        this.mComponent = component;
        this.mRequestCode = requestCode;
        this.mIntent = new Intent();
        this.mIntent.setComponent(component);
        this.mIntent.putExtras(this.mExtras);
        this.mIntent.addFlags(this.mFlags);
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public void setComponentName(ComponentName component) {
        this.mComponent = component;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(@NonNull String newClassName) {
        this.mIntent.setClassName(this.mContext, newClassName);
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void addFlags(int flags) {
        this.mIntent.addFlags(flags);
    }

    public void start() {
        try {
            if (this.mRequestCode == -1) {
                this.startActivity();
            } else {
                this.startActivityForResult(this.mRequestCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startActivity() {
        try {
            if (!(this.mContext instanceof Activity)) {
                this.mIntent.addFlags(0x10000000);
            }
            this.mContext.startActivity(this.mIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startActivityForResult(int requestCode) {
        try {
            if (!(this.mContext instanceof Activity)) {
                throw new RuntimeException("startActivityForResult only works for activity context");
            }
            ((Activity)this.mContext).startActivityForResult(this.mIntent, requestCode);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static final class Builder {
        private int mFlags;
        private Context mContext;
        Method mMethod;
        Object[] mArgs;
        String mPackageName;
        String mClassName;
        int mRequestCode;

        public Builder(Context context, Method method, Object ... args) {
            this.mContext = context;
            this.mMethod = method;
            this.mArgs = args;
        }

        public Builder addFlags(int flags) {
            this.mFlags |= flags;
            return this;
        }

        public IntentWrapper build() {
            Annotation[] methodAnnotations;
            for (Annotation annotation : methodAnnotations = this.mMethod.getAnnotations()) {
                this.parseMethodAnnotation(annotation);
            }
            if (TextUtils.isEmpty((CharSequence)this.mClassName)) {
                throw new RuntimeException("ClassName annotation is required.");
            }
            Type[] types = this.mMethod.getGenericParameterTypes();
            Annotation[][] parameterAnnotationsArray = this.mMethod.getParameterAnnotations();
            Bundle bundleExtra = new Bundle();
            for (int i = 0; i < types.length; ++i) {
                Annotation[] parameterAnnotations;
                String key = null;
                for (Annotation annotation : parameterAnnotations = parameterAnnotationsArray[i]) {
                    if (!(annotation instanceof Key)) continue;
                    key = ((Key)annotation).value();
                    break;
                }
                this.parseParameter(bundleExtra, types[i], key, this.mArgs[i]);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mPackageName)) {
                ComponentName componentName = new ComponentName(this.mPackageName, this.mClassName);
                return new IntentWrapper(this.mContext, componentName, bundleExtra, this.mFlags, this.mMethod.isAnnotationPresent(RequestCode.class) ? this.mRequestCode : -1);
            }
            return new IntentWrapper(this.mContext, this.mClassName, bundleExtra, this.mFlags, this.mMethod.isAnnotationPresent(RequestCode.class) ? this.mRequestCode : -1);
        }

        /*
         * Enabled aggressive block sorting
         */
        void parseParameter(Bundle bundleExtra, Type type, String key, Object arg) {
            Class<?>[] interfaces;
            Class<?> rawParameterType;
            block37: {
                Class<?>[] interfaces2;
                block36: {
                    Class<?>[] interfaces3;
                    Type actualTypeArgument;
                    block35: {
                        Class<?>[] interfaces4;
                        block33: {
                            block34: {
                                rawParameterType = this.getRawType(type);
                                if (rawParameterType == String.class) {
                                    bundleExtra.putString(key, arg.toString());
                                    return;
                                }
                                if (rawParameterType == String[].class) {
                                    bundleExtra.putStringArray(key, (String[])arg);
                                    return;
                                }
                                if (rawParameterType == Integer.TYPE || rawParameterType == Integer.class) {
                                    bundleExtra.putInt(key, Integer.parseInt(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == int[].class || rawParameterType == Integer[].class) {
                                    bundleExtra.putIntArray(key, (int[])arg);
                                    return;
                                }
                                if (rawParameterType == Short.TYPE || rawParameterType == Short.class) {
                                    bundleExtra.putShort(key, Short.parseShort(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == short[].class || rawParameterType == Short[].class) {
                                    bundleExtra.putShortArray(key, (short[])arg);
                                    return;
                                }
                                if (rawParameterType == Long.TYPE || rawParameterType == Long.class) {
                                    bundleExtra.putLong(key, Long.parseLong(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == long[].class || rawParameterType == Long[].class) {
                                    bundleExtra.putLongArray(key, (long[])arg);
                                    return;
                                }
                                if (rawParameterType == Character.TYPE) {
                                    bundleExtra.putChar(key, arg.toString().toCharArray()[0]);
                                    return;
                                }
                                if (rawParameterType == char[].class) {
                                    bundleExtra.putCharArray(key, arg.toString().toCharArray());
                                    return;
                                }
                                if (rawParameterType == Double.TYPE || rawParameterType == Double.class) {
                                    bundleExtra.putDouble(key, Double.parseDouble(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == double[].class || rawParameterType == Double[].class) {
                                    bundleExtra.putDoubleArray(key, (double[])arg);
                                    return;
                                }
                                if (rawParameterType == Float.TYPE || rawParameterType == Float.class) {
                                    bundleExtra.putFloat(key, Float.parseFloat(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == float[].class || rawParameterType == Float[].class) {
                                    bundleExtra.putFloatArray(key, (float[])arg);
                                    return;
                                }
                                if (rawParameterType == Byte.TYPE || rawParameterType == Byte.class) {
                                    bundleExtra.putByte(key, Byte.parseByte(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == byte[].class || rawParameterType == Byte[].class) {
                                    bundleExtra.putByteArray(key, (byte[])arg);
                                    return;
                                }
                                if (rawParameterType == Boolean.TYPE || rawParameterType == Boolean.class) {
                                    bundleExtra.putBoolean(key, Boolean.parseBoolean(arg.toString()));
                                    return;
                                }
                                if (rawParameterType == boolean[].class || rawParameterType == Boolean[].class) {
                                    bundleExtra.putBooleanArray(key, (boolean[])arg);
                                    return;
                                }
                                if (rawParameterType == Bundle.class) {
                                    if (TextUtils.isEmpty((CharSequence)key)) {
                                        bundleExtra.putAll((Bundle)arg);
                                        return;
                                    }
                                    bundleExtra.putBundle(key, (Bundle)arg);
                                    return;
                                }
                                if (rawParameterType == SparseArray.class) break block33;
                                if (rawParameterType != ArrayList.class) break block34;
                                if (!(type instanceof ParameterizedType)) throw new RuntimeException("ArrayList\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                                ParameterizedType parameterizedType = (ParameterizedType)type;
                                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                                if (actualTypeArguments == null) throw new RuntimeException("ArrayList\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                                if (actualTypeArguments.length != 1) {
                                    throw new RuntimeException("ArrayList\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                                }
                                actualTypeArgument = actualTypeArguments[0];
                                if (actualTypeArgument == String.class) {
                                    bundleExtra.putStringArrayList(key, (ArrayList)arg);
                                    return;
                                }
                                if (actualTypeArgument == Integer.class) {
                                    bundleExtra.putIntegerArrayList(key, (ArrayList)arg);
                                    return;
                                }
                                if (actualTypeArgument == CharSequence.class) {
                                    bundleExtra.putCharSequenceArrayList(key, (ArrayList)arg);
                                    return;
                                }
                                break block35;
                            }
                            if (rawParameterType.isArray()) break block36;
                            break block37;
                        }
                        if (!(type instanceof ParameterizedType)) throw new RuntimeException("SparseArray\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        Type actualTypeArgument2 = actualTypeArguments[0];
                        if (!(actualTypeArgument2 instanceof Class)) return;
                        Class<?>[] classArray = interfaces4 = ((Class)actualTypeArgument2).getInterfaces();
                        int n = classArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> interfaceClass = classArray[n2];
                            if (interfaceClass == Parcelable.class) {
                                bundleExtra.putSparseParcelableArray(key, (SparseArray)arg);
                                return;
                            }
                            ++n2;
                        }
                        throw new RuntimeException("SparseArray\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                    }
                    if (!(actualTypeArgument instanceof Class)) return;
                    Class<?>[] classArray = interfaces3 = ((Class)actualTypeArgument).getInterfaces();
                    int n = classArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Class<?> interfaceClass = classArray[n3];
                        if (interfaceClass == Parcelable.class) {
                            bundleExtra.putParcelableArrayList(key, (ArrayList)arg);
                            return;
                        }
                        ++n3;
                    }
                    throw new RuntimeException("ArrayList\u7684\u6cdb\u578b\u5fc5\u987b\u5b9e\u73b0Parcelable\u63a5\u53e3");
                }
                Class<?>[] classArray = interfaces2 = rawParameterType.getComponentType().getInterfaces();
                int n = classArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Class<?> interfaceClass = classArray[n4];
                    if (interfaceClass == Parcelable.class) {
                        bundleExtra.putParcelableArray(key, (Parcelable[])arg);
                        return;
                    }
                    ++n4;
                }
                throw new RuntimeException("Object[]\u6570\u7ec4\u4e2d\u7684\u5bf9\u8c61\u5fc5\u987b\u5168\u90e8\u5b9e\u73b0\u4e86Parcelable\u63a5\u53e3");
            }
            Class<?>[] classArray = interfaces = rawParameterType.getInterfaces();
            int n = classArray.length;
            int n5 = 0;
            while (n5 < n) {
                Class<?> interfaceClass = classArray[n5];
                if (interfaceClass == Serializable.class) {
                    bundleExtra.putSerializable(key, (Serializable)arg);
                } else {
                    if (interfaceClass != Parcelable.class) throw new RuntimeException("Bundle\u4e0d\u652f\u6301\u7684\u7c7b\u578b, \u53c2\u6570: " + key);
                    bundleExtra.putParcelable(key, (Parcelable)arg);
                }
                ++n5;
            }
        }

        void parseMethodAnnotation(Annotation annotation) {
            if (annotation instanceof Component) {
                this.mPackageName = ((Component)annotation).pkg();
                this.mClassName = ((Component)annotation).cls();
            } else if (annotation instanceof ClassName) {
                this.mClassName = ((ClassName)annotation).value();
            } else if (annotation instanceof RequestCode) {
                this.mRequestCode = ((RequestCode)annotation).value();
            }
        }

        Class<?> getRawType(Type type) {
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                if (!(rawType instanceof Class)) {
                    throw new IllegalArgumentException();
                }
                return (Class)rawType;
            }
            if (type instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)type).getGenericComponentType();
                return Array.newInstance(this.getRawType(componentType), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (type instanceof WildcardType) {
                return this.getRawType(((WildcardType)type).getUpperBounds()[0]);
            }
            throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
        }
    }
}

