/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.push;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.core.push.PushController;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.pushsdk.PushClient;
import java.util.ArrayList;

public class PushControllerImp
implements PushController {
    public static final String TOPIC_IM = "/im";
    public static String clientId;
    public static String subTopic;
    private ArrayList<String> mTopics;
    private static final String TOPIC_MX = "/mxs";

    private PushControllerImp() {
    }

    public static PushControllerImp getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public void startPush(String appId, String userId, String key) {
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("ERROR: client id is null." + clientId);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("para is null");
        }
        subTopic = appId + "/" + userId + TOPIC_IM;
        this.subTopics(context, appId, userId);
    }

    @Override
    public boolean releasePush() {
        LogUtil.d("releaseProxy push...");
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Release push failed. context is null.");
            return false;
        }
        PushClient.unsubscribe((Context)context, this.mTopics);
        int release = PushClient.release((Context)context);
        return release == 0;
    }

    private void subTopics(@NonNull Context context, @NonNull String appId, @NonNull String userId) {
        this.mTopics = new ArrayList();
        this.mTopics.add(appId + "/" + userId + TOPIC_IM);
        this.mTopics.add(appId + "/" + userId + TOPIC_MX);
        PushClient.subTopic((Context)context, this.mTopics);
    }

    private static class SingletonInstance {
        private static final PushControllerImp mInstance = new PushControllerImp();

        private SingletonInstance() {
        }
    }
}

