/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl;

import android.text.TextUtils;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.repository.interf.SecurityRepository;
import com.xdja.im.uikit.utils.CXAESUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class SecurityImpl
implements SecurityRepository {
    public static final String SECURITY_CODE = "security_code";
    public static final String SECURITY_RESULT = "security_result";
    public static final int SECURITY_SUCCESS = 0;
    public static final int SECURITY_FAIL = 1;
    public static final int NO_DECRYPT = 2;
    private String key = "1234567890";
    private UserCache userCache;
    private static Map<String, Long> failCache = new HashMap<String, Long>();
    private static Map<String, Boolean> sGCache = new HashMap<String, Boolean>();

    @Inject
    public SecurityImpl(UserCache userCache) {
        this.userCache = userCache;
    }

    @Override
    public Map<String, Object> encryptText(String source, String to, boolean isGroup) {
        HashMap<String, Object> encryptMap = new HashMap<String, Object>();
        String result = null;
        try {
            result = CXAESUtil.encrypt(this.key, source);
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, result);
            encryptMap.put(SECURITY_CODE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, source);
            encryptMap.put(SECURITY_CODE, 1);
        }
        return encryptMap;
    }

    @Override
    public Map<String, Object> encryptAsync(String source, String dest, String to, boolean isGroup) {
        File destFile;
        HashMap<String, Object> encryptMap = new HashMap<String, Object>();
        if (TextUtils.isEmpty((CharSequence)dest)) {
            dest = source + ".dat";
        }
        if ((destFile = CXAESUtil.encryptFile(source, dest, this.key)) != null) {
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, dest);
            encryptMap.put(SECURITY_CODE, 0);
        } else {
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, source);
            encryptMap.put(SECURITY_CODE, 1);
        }
        return encryptMap;
    }

    @Override
    public Map<String, Object> decryptText(String source, long msgId, String from, String to, boolean isGroup) {
        HashMap<String, Object> encryptMap = new HashMap<String, Object>();
        String result = null;
        try {
            result = CXAESUtil.decrypt(this.key, source);
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, result);
            encryptMap.put(SECURITY_CODE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, source);
            encryptMap.put(SECURITY_CODE, 1);
        }
        return encryptMap;
    }

    @Override
    public Map<String, Object> decryptAsync(String source, String dest, String to, boolean isGroup) {
        File destFile;
        HashMap<String, Object> encryptMap = new HashMap<String, Object>();
        if (TextUtils.isEmpty((CharSequence)dest)) {
            dest = source.split(".dat")[0];
        }
        if ((destFile = CXAESUtil.decryptFile(source, dest, this.key)) != null) {
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, dest);
            encryptMap.put(SECURITY_CODE, 0);
        } else {
            encryptMap.remove(SECURITY_RESULT);
            encryptMap.put(SECURITY_RESULT, source);
            encryptMap.put(SECURITY_CODE, 1);
        }
        return encryptMap;
    }
}

