/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.utils;

import android.util.ArrayMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.regex.Pattern;

public class PingNet {
    private static final String ipRegex = "((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))";

    public static int pingIpAddress(String url) {
        int status = -1;
        try {
            String ipAddress = PingNet.getIPFromUrl(url);
            Process process = Runtime.getRuntime().exec("/system/bin/ping -c 1 -w 100 " + ipAddress);
            status = process.waitFor();
            return status;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String getIPFromUrl(String url) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return null;
        }
        if (PingNet.isMatch(ipRegex, domain)) {
            return domain;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(1, 100, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("from") + 5);
                return tempInfo.substring(0, tempInfo.indexOf("icmp_seq") - 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getMinRTT(String url) {
        return PingNet.getMinRTT(url, 1, 100);
    }

    public static int getAvgRTT(String url) {
        return PingNet.getAvgRTT(url, 1, 100);
    }

    public static int getMaxRTT(String url) {
        return PingNet.getMaxRTT(url, 1, 100);
    }

    public static int getMdevRTT(String url) {
        return PingNet.getMdevRTT(url, 1, 100);
    }

    public static int getMinRTT(String url, int count, int timeout) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return -1;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(count, timeout, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("min/avg/max/mdev") + 19);
                String[] temps = tempInfo.split("/");
                return Math.round(Float.valueOf(temps[0]).floatValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static int getAvgRTT(String url, int count, int timeout) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return -1;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(count, timeout, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("min/avg/max/mdev") + 19);
                String[] temps = tempInfo.split("/");
                return Math.round(Float.valueOf(temps[1]).floatValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static int getMaxRTT(String url, int count, int timeout) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return -1;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(count, timeout, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("min/avg/max/mdev") + 19);
                String[] temps = tempInfo.split("/");
                return Math.round(Float.valueOf(temps[2]).floatValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static int getMdevRTT(String url, int count, int timeout) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return -1;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(count, timeout, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("min/avg/max/mdev") + 19);
                String[] temps = tempInfo.split("/");
                return Math.round(Float.valueOf(temps[3].replace(" ms", "")).floatValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static float getPacketLossFloat(String url) {
        String packetLossInfo = PingNet.getPacketLoss(url);
        if (null != packetLossInfo) {
            try {
                return Float.valueOf(packetLossInfo.replace("%", "")).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1.0f;
    }

    public static float getPacketLossFloat(String url, int count, int timeout) {
        String packetLossInfo = PingNet.getPacketLoss(url, count, timeout);
        if (null != packetLossInfo) {
            try {
                return Float.valueOf(packetLossInfo.replace("%", "")).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1.0f;
    }

    public static String getPacketLoss(String url) {
        return PingNet.getPacketLoss(url, 1, 100);
    }

    public static String getPacketLoss(String url, int count, int timeout) {
        String domain = PingNet.getDomain(url);
        if (null == domain) {
            return null;
        }
        String pingString = PingNet.ping(PingNet.createSimplePingCommand(count, timeout, domain));
        if (null != pingString) {
            try {
                String tempInfo = pingString.substring(pingString.indexOf("received,"));
                return tempInfo.substring(9, tempInfo.indexOf("packet"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getDomain(String url) {
        String domain = null;
        try {
            domain = URI.create(url).getHost();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domain;
    }

    private static boolean isMatch(String regex, String string2) {
        return Pattern.matches(regex, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ping(String command) {
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while (null != (line = reader.readLine())) {
                sb.append(line);
                sb.append("\n");
            }
            reader.close();
            is.close();
            String string2 = sb.toString();
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
        return null;
    }

    private static String createSimplePingCommand(int count, int timeout, String domain) {
        return "/system/bin/ping -c " + count + " -w " + timeout + " " + domain;
    }

    private static String createPingCommand(ArrayMap<String, String> map, String domain) {
        String command = "/system/bin/ping";
        int len = map.size();
        for (int i = 0; i < len; ++i) {
            command = command.concat(" " + (String)map.keyAt(i) + " " + (String)map.get(map.keyAt(i)));
        }
        command = command.concat(" " + domain);
        return command;
    }
}

