/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action.uitls;

import android.content.Context;
import com.xdja.im.lib.action.bean.OptionBean;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OptionParser {
    public static final String OPTION_PATH = "options/chatOptions.xml";
    public static final String TAG_OPTION = "option";
    public static final String TAG_PARAM = "param";
    public static final String TAG_NAME = "name";
    public static final String TAG_ID = "id";
    public static final String TAG_TYPE = "type";
    public static final String TAG_PACKAGE = "package";
    public static final String TAG_CLASS = "class";
    public static final String TAG_CODE = "code";
    public static final String TAG_LABEL = "label";
    public static final String TAG_ICON = "icon";

    public static List<OptionBean> getOptions(Context context) throws Exception {
        InputStream inputStream = context.getAssets().open(OPTION_PATH);
        return OptionParser.parse(inputStream);
    }

    public static List<OptionBean> parse(InputStream inputStream) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        XMLReader reader = saxParser.getXMLReader();
        ParseHandler parseHandler = new ParseHandler();
        reader.setContentHandler(parseHandler);
        reader.parse(new InputSource(inputStream));
        return parseHandler.getOptionList();
    }

    public static class ParseHandler
    extends DefaultHandler {
        private List<OptionBean> options;
        private OptionBean optionBean;
        private String curTagName = null;

        public List<OptionBean> getOptionList() {
            return this.options;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.options = new ArrayList<OptionBean>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (OptionParser.TAG_OPTION.equals(localName)) {
                this.optionBean = new OptionBean();
                int size = attributes.getLength();
                for (int i = 0; i < size; ++i) {
                    String attribute = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    if (OptionParser.TAG_NAME.equals(attribute)) {
                        this.optionBean.setOption(value);
                        continue;
                    }
                    if (OptionParser.TAG_ID.equals(attribute)) {
                        this.optionBean.setId(Integer.parseInt(value));
                        continue;
                    }
                    if (!OptionParser.TAG_TYPE.equals(attribute)) continue;
                    this.optionBean.setType(Integer.parseInt(value));
                }
            } else if (OptionParser.TAG_PARAM.equals(localName)) {
                HashMap<String, String> param = new HashMap<String, String>();
                int size = attributes.getLength();
                for (int i = 0; i < size; ++i) {
                    String attribute = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    param.put(attribute, value);
                }
                this.optionBean.setParam(param);
            }
            this.curTagName = localName;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String value = new String(ch, start, length).trim();
            if (value != null && !"".equals(value) && !"\n".equals(value)) {
                switch (this.curTagName) {
                    case "package": {
                        this.optionBean.setPkgName(value);
                        break;
                    }
                    case "class": {
                        this.optionBean.setClsName(value);
                        break;
                    }
                    case "code": {
                        this.optionBean.setRequestCode(Integer.parseInt(value));
                        break;
                    }
                    case "label": {
                        this.optionBean.setLabel(value);
                        break;
                    }
                    case "icon": {
                        this.optionBean.setIcon(value);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (OptionParser.TAG_OPTION.equals(localName)) {
                this.options.add(this.optionBean);
                this.optionBean = null;
            }
            this.curTagName = null;
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }
    }
}

