/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.adapter;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Toast;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.lib.file.FileExplorerManager;
import com.xdja.im.lib.file.bean.FileCollections;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileItemNode;
import com.xdja.im.lib.file.utils.NodeUtils;
import com.xdja.im.lib.file.widget.recyclerview.BaseMultiItemTypeAdapter;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonRecyclerAdapter
extends BaseMultiItemTypeAdapter<FileItemNode>
implements BaseMultiItemTypeAdapter.OnItemClickListener {
    private long lastClickTime = 0L;
    private RecyclerView recyclerView;
    private Map<String, List<FileItem>> dataMaps;
    private CommonSpanSizeLookup spanSizeLookup;

    public CommonRecyclerAdapter(Context context, List<FileItemNode> dataSources, Map<String, List<FileItem>> dataMaps) {
        super(context, dataSources);
        this.dataMaps = dataMaps;
        this.dataSources = NodeUtils.convertData(dataMaps);
        this.setOnItemClickListener(this);
    }

    public void updateAllItems() {
        this.dataSources = NodeUtils.convertData(this.dataMaps);
        this.notifyDataSetChanged();
    }

    @Override
    public void onItemClick(View view, ViewHolder holder, int position) {
        switch (this.getItemViewType(position)) {
            case 0: {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime <= 500L) break;
                this.lastClickTime = currentTime;
                this.collapseOrExpand(position);
                break;
            }
            default: {
                this.clickChildLeaf(holder, position);
            }
        }
    }

    protected void collapseOrExpand(int position) {
        FileItemNode bean = (FileItemNode)this.dataSources.get(position);
        String title = (String)bean.getValue();
        List<FileItem> childLists = bean.getChildList();
        List<FileItem> originChilds = this.dataMaps.get(title);
        if (bean.isExpand()) {
            for (FileItem fInfo : childLists) {
                FileItemNode<FileItem> deleteBean = new FileItemNode<FileItem>();
                deleteBean.setValue(fInfo);
                this.dataSources.remove(deleteBean);
            }
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeRemoved(position + 1, childLists.size());
        } else {
            ArrayList addChildItem = new ArrayList();
            for (FileItem fInfo : originChilds) {
                FileItemNode<FileItem> addBean = new FileItemNode<FileItem>();
                addBean.setValue(fInfo);
                addBean.setChildList(null);
                addChildItem.add(addBean);
            }
            this.dataSources.addAll(position + 1, addChildItem);
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeInserted(position + 1, addChildItem.size());
        }
        this.notifyItemChanged(position);
    }

    protected void clickChildLeaf(ViewHolder holder, int position) {
        FileItem fileInfo = (FileItem)((FileItemNode)this.dataSources.get(position)).getValue();
        if (fileInfo != null) {
            if (!fileInfo.isSelected() && FileCollections.getInstance().getSelectedFileCount() >= 9) {
                CommonTool.showToast(String.format(this.context.getString(R.string.im_uikit_select_file_hint), 9));
                return;
            }
            fileInfo.setSelected(!fileInfo.isSelected());
            if (fileInfo.isSelected()) {
                FileCollections.getInstance().putFileToSelectedCache(fileInfo.getFilePath() + fileInfo.getModifiedDate(), fileInfo);
            } else {
                FileCollections.getInstance().removeToSelectedCache(fileInfo.getFilePath() + fileInfo.getModifiedDate());
            }
            IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(fileInfo);
            BusProvider.getInstance().post(event);
            holder.setChecked(R.id.chx_file_fragment_select, fileInfo.isSelected());
        }
    }

    @Override
    public boolean onItemLongClick(View view, ViewHolder holder, int position) {
        switch (this.getItemViewType(position)) {
            case 0: {
                break;
            }
            default: {
                Toast.makeText((Context)this.context, (CharSequence)("click long leaf position=" + position), (int)0).show();
            }
        }
        return false;
    }

    @Override
    public int getItemViewType(int position) {
        if (position < this.dataSources.size() && ((FileItemNode)this.dataSources.get(position)).isLeaf()) {
            FileItem fileInfo = (FileItem)((FileItemNode)this.dataSources.get(position)).getValue();
            int photoStyle = FileExplorerManager.getInstance().getConfig().getPhotoStyle();
            if (fileInfo.getFileType() == 3 && photoStyle == 2) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public void setLayoutManager(int col) {
        GridLayoutManager layoutManager = new GridLayoutManager(this.context, col);
        layoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.getSpanSizeLookup());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    private CommonSpanSizeLookup getSpanSizeLookup() {
        if (this.spanSizeLookup == null) {
            this.spanSizeLookup = new CommonSpanSizeLookup();
        }
        return this.spanSizeLookup;
    }

    private class CommonSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private CommonSpanSizeLookup() {
        }

        public int getSpanSize(int position) {
            int viewType = CommonRecyclerAdapter.this.getItemViewType(position);
            if (viewType == 0 || viewType == 3) {
                return 3;
            }
            return 1;
        }
    }
}

