/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.view;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.file.ui.presenter.FileListFragmentPresenter;
import com.xdja.im.lib.file.ui.view.vu.FileListVu;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;

public class ViewFileList
extends FragmentSuperBaseView<FileListFragmentPresenter>
implements FileListVu {
    private LinearLayout emptyLayout;
    private RecyclerView recyclerView;
    private LinearLayout localFileLayout;
    private ViewPager viewPager;
    private ViewPagerIndicator indicator;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_file_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (view != null) {
            this.emptyLayout = (LinearLayout)view.findViewById(R.id.fragment_file_empty_layout);
            this.recyclerView = (RecyclerView)view.findViewById(R.id.file_recent_rv);
            this.localFileLayout = (LinearLayout)view.findViewById(R.id.file_local_tab_layout);
            this.viewPager = (ViewPager)view.findViewById(R.id.file_child_vp);
            this.indicator = (ViewPagerIndicator)view.findViewById(R.id.file_child_indicator);
            this.initView();
        }
    }

    private void initView() {
        this.showEmptyView(false);
    }

    @Override
    public void showEmptyView(boolean isShow) {
        this.emptyLayout.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    @Override
    public void setRecyclerViewAdapter(RecyclerView.Adapter<ViewHolder> adapter) {
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.setAdapter(adapter);
    }

    @Override
    public void showViewWithType(int type) {
        this.recyclerView.setVisibility(type != FileListType.LOCAL.getType() ? 0 : 8);
        this.localFileLayout.setVisibility(type != FileListType.LOCAL.getType() ? 8 : 0);
    }

    @Override
    public void setFragmentAdapter(FragmentPagerAdapter adapter) {
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.indicator.setViewPager(this.viewPager);
    }

    @Override
    public <A extends Fragment> void setFragment(A fragment) {
    }
}

