/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.ViewHolder;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ImageLoader;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.R;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class FileListViewHolder
extends ViewHolder<FileItem> {
    private final Context context;
    private ImageView mFileIconImg;
    private TextView mFileTitleTv;
    private TextView mFileSizeTv;
    private TextView mFileDateTv;
    private CheckBox mSelectChx;

    public FileListViewHolder(Context context, View itemView) {
        super(itemView);
        this.context = context;
    }

    @Override
    protected void bindViews(View itemView) {
        this.mFileIconImg = (ImageView)itemView.findViewById(R.id.img_file_icon);
        this.mFileTitleTv = (TextView)itemView.findViewById(R.id.tv_file_title);
        this.mFileSizeTv = (TextView)itemView.findViewById(R.id.tv_file_size);
        this.mFileDateTv = (TextView)itemView.findViewById(R.id.tv_file_date);
        this.mSelectChx = (CheckBox)itemView.findViewById(R.id.chx_select);
    }

    @Override
    public void bindData(FileItem dataSource) {
        if (dataSource != null) {
            this.mFileTitleTv.setText((CharSequence)dataSource.getFileName());
            this.mFileSizeTv.setText((CharSequence)FileSizeUtils.FormetFileSize(dataSource.getFileSize()));
            this.mFileDateTv.setText((CharSequence)DateUtils.convertFileModifyDate(dataSource.getModifiedDate()));
            this.mSelectChx.setChecked(dataSource.isSelected());
            if (dataSource.getFileType() == 3) {
                ImageLoader.getInstance().crateBuilder().load(dataSource.getFilePath()).preLoad(360, 360).error(R.drawable.im_uikit_ic_jpg).centerCrop().into(this.mFileIconImg).build();
            } else if (dataSource.getFileType() == 0) {
                this.getIconResIdByPath(dataSource.getFilePath(), dataSource.getFileSize());
            } else {
                this.mFileIconImg.setImageResource(this.getFileIconResId(dataSource.getFileType()));
            }
        }
    }

    private int getFileIconResId(int fileType) {
        int resId;
        switch (fileType) {
            case 1: {
                resId = R.drawable.im_uikit_ic_music;
                break;
            }
            case 2: {
                resId = R.drawable.im_uikit_ic_video;
                break;
            }
            case 3: {
                resId = R.drawable.im_uikit_ic_jpg;
                break;
            }
            case 6: {
                resId = R.drawable.im_uikit_ic_doc;
                break;
            }
            case 5: {
                resId = R.drawable.im_uikit_ic_text;
                break;
            }
            case 8: {
                resId = R.drawable.im_uikit_ic_excel;
                break;
            }
            case 9: {
                resId = R.drawable.im_uikit_ic_pdf;
                break;
            }
            case 7: {
                resId = R.drawable.im_uikit_ic_ppt;
                break;
            }
            case 4: {
                resId = R.drawable.im_uikit_ic_apk;
                break;
            }
            case 10: {
                resId = UniversalUtil.getThemeStyle(this.context) == 0 ? R.drawable.im_uikit_ic_others : R.drawable.im_uikit_ic_others_light;
                break;
            }
            default: {
                resId = UniversalUtil.getThemeStyle(this.context) == 0 ? R.drawable.im_uikit_ic_others : R.drawable.im_uikit_ic_others_light;
            }
        }
        return resId;
    }

    private void getIconResIdByPath(final String filePath, long fileSize) {
        Observable.just((Object)filePath).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String path) {
                return Observable.just((Object)IMFileUtils.getFileTypeFromFilepath(path));
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Integer>(){

            public void call(Integer integer) {
                if (integer == 3) {
                    ImageLoader.getInstance().crateBuilder().load(filePath).preLoad(360, 360).error(R.drawable.im_uikit_ic_jpg).centerCrop().into(FileListViewHolder.this.mFileIconImg).build();
                } else {
                    FileListViewHolder.this.mFileIconImg.setImageResource(FileListViewHolder.this.getFileIconResId(integer));
                }
            }
        });
    }
}

