/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ApkDetector {
    public static final String CKMS_COMMON_PKG_NAME = "com.xdja.safekeyservice";
    public static final String CKMS_TELCOM_PKG_NAME = "com.xdja.safekeyservice.zjtel";

    public static int getInstalledApkVersion(Context context, String pkgName) {
        PackageManager manager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = manager.getPackageInfo(pkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -1;
        }
        return packageInfo.versionCode;
    }

    public static boolean installApk(Context context, String fileName) {
        try {
            String path = context.getExternalFilesDir(null) + File.separator + fileName;
            Runtime.getRuntime().exec("chmod 644" + path);
            File f = new File(path);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setDataAndType(Uri.fromFile((File)new File(path)), "application/vnd.android.package-archive");
            context.startActivity(intent);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            LogUtil.e("", e.getMessage());
            return Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyArchive(Context context, String fileName) {
        block18: {
            InputStream in = null;
            FileOutputStream out = null;
            File f = new File(context.getExternalFilesDir(null) + File.separator + fileName);
            if (f.exists()) {
                f.delete();
            }
            in = context.getResources().getAssets().open(fileName);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                break block18;
            }
            catch (IOException e) {
                LogUtil.e("", e.getMessage());
            }
            break block18;
            catch (Exception ioe) {
                try {
                    LogUtil.e("", ioe.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtil.e("", e.getMessage());
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    LogUtil.e("", e.getMessage());
                }
                return;
            }
        }
    }

    public static boolean judgeIsInstall(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean judgeSafeKeyServiceCommonIsInstall(Context context) {
        return ApkDetector.judgeIsInstall(context, CKMS_COMMON_PKG_NAME);
    }

    public static boolean judgeSafeKeyServiceTelcomIsInstall(Context context) {
        return ApkDetector.judgeIsInstall(context, CKMS_TELCOM_PKG_NAME);
    }

    public static int startUpdateActivity(Context context) {
        if (ApkDetector.judgeSafeKeyServiceCommonIsInstall(context)) {
            Intent intent = new Intent();
            String pkgName = CKMS_COMMON_PKG_NAME;
            String className = "com.xdja.scservice.presenter.activity.UpdatePresener";
            intent.setComponent(new ComponentName(pkgName, className));
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            return 0;
        }
        return -1;
    }
}

