/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.widget.Toast;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.MimeUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;

public class HistoryFileUtils {
    public static boolean isFileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static boolean isFileExist(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();
        FileInfo fileExtraInfo = null;
        if (fileInfo instanceof ImageFileInfo) {
            if (((ImageFileInfo)fileInfo).isOriginal()) {
                fileExtraInfo = ((ImageFileInfo)fileInfo).getRawFileInfo();
                return HistoryFileUtils.fileIsExist(fileExtraInfo);
            }
            fileExtraInfo = ((ImageFileInfo)fileInfo).getHdFileInfo();
            return HistoryFileUtils.fileIsExist(fileExtraInfo);
        }
        if (fileInfo instanceof VideoFileInfo) {
            fileExtraInfo = ((VideoFileInfo)fileInfo).getRawFileInfo();
            return HistoryFileUtils.fileIsExist(fileExtraInfo);
        }
        if (fileInfo instanceof FileInfo) {
            return HistoryFileUtils.fileIsExist(fileInfo);
        }
        return false;
    }

    private static boolean fileIsExist(FileInfo fileInfo) {
        return FileUtils.isFileExists(fileInfo.getFilePath()) && fileInfo.getFileState() != 5 && fileInfo.getFileState() != 4 && fileInfo.getFileState() != 1 && fileInfo.getFileState() != 3;
    }

    public static boolean isForwardFileExist(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();
        FileInfo fileExtraInfo = null;
        if (fileInfo instanceof ImageFileInfo) {
            if (((ImageFileInfo)fileInfo).isOriginal()) {
                fileExtraInfo = ((ImageFileInfo)fileInfo).getRawFileInfo();
                return !TextUtils.isEmpty((CharSequence)fileExtraInfo.getFilePath()) && new File(fileExtraInfo.getFilePath()).exists();
            }
            return !TextUtils.isEmpty((CharSequence)((ImageFileInfo)fileInfo).getHdFileInfo().getFilePath()) && new File(((ImageFileInfo)fileInfo).getHdFileInfo().getFilePath()).exists();
        }
        if (fileInfo instanceof VideoFileInfo) {
            fileExtraInfo = ((VideoFileInfo)fileInfo).getRawFileInfo();
            return !TextUtils.isEmpty((CharSequence)fileExtraInfo.getFilePath()) && new File(fileExtraInfo.getFilePath()).exists();
        }
        if (fileInfo instanceof FileInfo) {
            return !TextUtils.isEmpty((CharSequence)fileInfo.getFilePath()) && new File(fileInfo.getFilePath()).exists();
        }
        return false;
    }

    public static boolean isSendReadReceipt(TalkMessageBean bean) {
        boolean isSend = false;
        FileInfo fileInfo = bean.getFileInfo();
        if (bean.getMessageState() >= 4 || bean.isMine() || bean.isBomb() || fileInfo == null) {
            return isSend;
        }
        if (fileInfo instanceof ImageFileInfo) {
            isSend = true;
        } else if (fileInfo instanceof ImageFileInfo) {
            isSend = true;
        } else if (fileInfo instanceof VideoFileInfo) {
            isSend = ((VideoFileInfo)fileInfo).getRawFileInfo().getFileState() == 2;
        } else if (fileInfo instanceof FileInfo) {
            isSend = fileInfo.getFileState() == 2;
        }
        return isSend;
    }

    private static boolean isFileType(String suffix, String[] args) {
        for (String arg : args) {
            if (!arg.equals("." + suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPicture() {
        return false;
    }

    public static int getIconWithSuffix(TalkMessageBean talkMessageBean) {
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo == null) {
            return R.drawable.im_uikit_ic_others;
        }
        String suffix = fileInfo.getSuffix();
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            return R.drawable.im_uikit_ic_others;
        }
        int resId = HistoryFileUtils.isFileType(suffix = suffix.toLowerCase(), new String[]{".pdf"}) ? R.drawable.im_uikit_ic_pdf : (HistoryFileUtils.isFileType(suffix, new String[]{".doc", ".docx"}) ? R.drawable.im_uikit_ic_doc : (HistoryFileUtils.isFileType(suffix, new String[]{".xls", ".xlsx"}) ? R.drawable.im_uikit_ic_excel : (HistoryFileUtils.isFileType(suffix, new String[]{".ppt", ".pptx"}) ? R.drawable.im_uikit_ic_ppt : (HistoryFileUtils.isFileType(suffix, new String[]{".txt"}) ? R.drawable.im_uikit_ic_text : (HistoryFileUtils.isFileType(suffix, IMFileUtils.mVideoSuffix) ? R.drawable.im_uikit_ic_video : (HistoryFileUtils.isFileType(suffix, IMFileUtils.mVoiceSuffix) ? R.drawable.im_uikit_ic_music : (HistoryFileUtils.isFileType(suffix, IMFileUtils.mImageSuffix) ? R.drawable.im_uikit_ic_jpg : (HistoryFileUtils.isFileType(suffix, IMFileUtils.mDocSuffix) ? R.drawable.im_uikit_ic_doc : (HistoryFileUtils.isFileType(suffix, IMFileUtils.mApkSuffix) ? R.drawable.im_uikit_ic_apk : R.drawable.im_uikit_ic_others)))))))));
        return resId;
    }

    public static void intentBuilder(Activity activity, String filePath, String suffix) {
        String type;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.im_uikit_history_send_file_not_exist), (int)0).show();
            return;
        }
        boolean isCiphert = UniversalUtil.isCiphert((Context)activity);
        if (isCiphert) {
            new XToast((Context)activity).display(activity.getString(R.string.im_uikit_ciphert_mode));
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            type = "*/*";
        } else {
            type = MimeUtils.getMimeTypeWithExtension(suffix.toLowerCase());
            if (TextUtils.isEmpty((CharSequence)type)) {
                type = "*/*";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)type) && !"*/*".equals(type)) {
            try {
                if (Build.VERSION.SDK_INT >= 24) {
                    intent.setFlags(3);
                    Uri uri = FileProvider.getUriForFile((Context)activity, (String)(activity.getApplicationContext().getPackageName() + ".fileprovider"), (File)new File(filePath));
                    intent.setDataAndType(uri, type);
                } else {
                    intent.setDataAndType(Uri.fromFile((File)new File(filePath)), type);
                }
                activity.startActivity(intent);
            }
            catch (Exception e) {
                LogUtil.d("", "Not found exception;");
                Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.im_uikit_history_file_none_tool), (int)0).show();
            }
        } else if ("*/*".equals(type)) {
            Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.im_uikit_history_file_none_tool), (int)0).show();
        }
    }
}

