/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.commend.ILastPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ViewLastBaseItem;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.image.BitmapUtils;

public class ViewLastVideoItem
extends ViewLastBaseItem {
    private CheckBox isSelect;
    private ImageView imgView;
    private TextView videoTime;
    private int style;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.style = UniversalUtil.getThemeStyle(this.getContext());
        if (view != null) {
            this.isSelect = (CheckBox)view.findViewById(R.id.chx_video_file_select);
            this.imgView = (ImageView)view.findViewById(R.id.history_file_video_img);
            this.videoTime = (TextView)view.findViewById(R.id.history_file_video_time);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean)dataSource.getValue();
        final VideoFileInfo fileInfo = (VideoFileInfo)dataTalk.getFileInfo();
        this.isSelect.setVisibility(0);
        this.isSelect.setChecked(dataTalk.isChecked());
        this.isSelect.setClickable(false);
        this.isSelect.setButtonDrawable(dataTalk.isChecked() ? (this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
        this.isSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);
                ViewLastVideoItem.this.isSelect.setButtonDrawable(isChecked ? (ViewLastVideoItem.this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
                FileItem localFileInfo = new FileItem(fileInfo.getRawFileInfo().getFileName(), fileInfo.getRawFileInfo().getFilePath(), fileInfo.getRawFileInfo().getFileSize(), 0L, fileInfo.getRawFileInfo().getFileType());
                if (isChecked) {
                    FileInfoCollection.getInstance().putFileToSelectedCache(fileInfo.getRawFileInfo().getFilePath() + dataTalk.getId(), localFileInfo);
                } else {
                    FileInfoCollection.getInstance().removeToSelectedCache(fileInfo.getRawFileInfo().getFilePath() + dataTalk.getId());
                }
                ((ILastPhotoAndVideoAdapterCommand)ViewLastVideoItem.this.getCommand()).toRefreshSelectHint(localFileInfo);
            }
        });
        if (fileInfo != null) {
            if (HistoryFileUtils.isFileExist(fileInfo.getFilePath())) {
                this.loadImage(fileInfo.getFilePath());
            } else {
                this.loadImage(null);
            }
            this.videoTime.setText((CharSequence)UnitUtil.getVideoDuration(IMFileUtils.getVideoDuration(fileInfo.getRawFileInfo().getFilePath()) / 1000));
        }
    }

    private void loadImage(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            this.imgView.setImageResource(R.drawable.im_uikit_pic_failed);
        } else {
            this.imgView.setImageBitmap(BitmapUtils.getZoomedDrawable(filePath, 1));
        }
    }
}

