/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.util;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceFilter {
    public static List<TalkMessageBean> getCheckedDataSource(Map<HistoryFileCategory, List<TalkMessageBean>> dataSource) {
        ArrayList<TalkMessageBean> beans = new ArrayList<TalkMessageBean>();
        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataSource.entrySet()) {
            for (TalkMessageBean bean : entry.getValue()) {
                if (!bean.isChecked()) continue;
                beans.add(bean);
            }
        }
        return beans;
    }

    public static List<FileInfo> getWeeklyFileInfo(List<TalkMessageBean> beans) {
        ArrayList<FileInfo> downloadFiles = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : beans) {
            if (DateUtils.isOverdue(bean.getShowTime())) continue;
            downloadFiles.add(bean.getFileInfo());
        }
        return downloadFiles;
    }

    public static List<FileInfo> getDownloadedFileInfo(List<TalkMessageBean> beans) {
        ArrayList<FileInfo> downloadedFiles = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : beans) {
            if (DateUtils.isOverdue(bean.getShowTime()) || !HistoryFileUtils.isFileExist(bean.getFileInfo().getFilePath())) continue;
            downloadedFiles.add(bean.getFileInfo());
        }
        return downloadedFiles;
    }

    public static List<FileInfo> getReCallFileInfo(List<TalkMessageBean> beans) {
        ArrayList<FileInfo> reCallInfos = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : beans) {
            if (bean.getMessageState() != 7) continue;
            reCallInfos.add(bean.getFileInfo());
        }
        return reCallInfos;
    }

    public static TalkMessageBean updateSourceAfterRecall(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps, TalkMessageBean bean) {
        int index;
        List<TalkMessageBean> messageBeans;
        String categoryId = DateUtils.getCategoryIdWithTime(bean.getShowTime());
        HistoryFileCategory category = DataSourceFilter.findCategoryById(dataMaps, categoryId);
        if (category != null && (messageBeans = dataMaps.get(category)) != null && messageBeans.size() > 0 && (index = messageBeans.indexOf(bean)) >= 0) {
            TalkMessageBean oldMsg = messageBeans.get(index);
            oldMsg.setMessageState(bean.getMessageState());
            if (oldMsg.getFileInfo() != null && oldMsg.getFileInfo().getFileState() == 3) {
                oldMsg.getFileInfo().setFileState(4);
            }
            return oldMsg;
        }
        return null;
    }

    private static HistoryFileCategory findCategoryById(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps, String categoryId) {
        HistoryFileCategory category = null;
        Set<HistoryFileCategory> categorySets = dataMaps.keySet();
        if (categorySets.size() != 0) {
            ArrayList<HistoryFileCategory> cateLists = new ArrayList<HistoryFileCategory>(categorySets);
            HistoryFileCategory tempCate = new HistoryFileCategory();
            tempCate.setCategoryId(categoryId);
            int index = cateLists.indexOf(tempCate);
            if (index >= 0) {
                category = (HistoryFileCategory)cateLists.get(index);
            }
        }
        return category;
    }

    public static TalkMessageBean findMessageBeanWithId(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps, long msgId) {
        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataMaps.entrySet()) {
            List<TalkMessageBean> beans = entry.getValue();
            for (TalkMessageBean bean : beans) {
                if (bean.getId() != msgId) continue;
                return bean;
            }
        }
        return null;
    }

    public static TalkMessageBean getTalkMessageBeanWithId(List<GridItemBean> dataSources, long msgId) {
        for (GridItemBean gridItemBean : dataSources) {
            TalkMessageBean bean;
            if (!gridItemBean.isLeaf() || (bean = (TalkMessageBean)gridItemBean.getValue()).getId() != msgId) continue;
            return bean;
        }
        return null;
    }
}

