/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share.view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.ColorRes;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.share.adapter.ShareSessionListAdapter;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.lib.share.util.BeanUtils;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.lib.share.view.ShareDialog;
import com.xdja.im.lib.share.view.vu.ShareViewSessionListVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import java.util.List;
import rx.Subscriber;

public class ShareViewSessionList
extends ImFragmentSuperView<ShareSessionListPresenter>
implements ShareViewSessionListVu {
    private RelativeLayout shareSearchLayout;
    private EditText shareSearch;
    private RelativeLayout shareCreateNewSession;
    private RelativeLayout shareLoadMoreContact;
    private RecyclerView shareSessionList;
    private ProgressBar shareSessionLoading;
    private TextView shareSessionEmpty;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_share_view_session_list_layout;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        this.supportActionBar(visibility == 0);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        this.setToolBarAddVisible(visibility == 0);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.shareSessionLoading.setVisibility(visibility);
    }

    @Override
    public void setShareSessionEmptyVisibility(int visibility) {
        this.shareSessionEmpty.setVisibility(visibility);
    }

    @Override
    public void setTitle(String title) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitle(title);
        }
    }

    @Override
    public void setTitleColor(@ColorRes int id2) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitleColor(id2);
        }
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.shareSearchLayout = (RelativeLayout)this.findViewById(R.id.share_search_layout);
        this.shareSearch = (EditText)this.findViewById(R.id.share_search);
        this.shareCreateNewSession = (RelativeLayout)this.findViewById(R.id.share_create_new_session);
        this.shareLoadMoreContact = (RelativeLayout)this.findViewById(R.id.share_load_more_contact);
        this.shareSessionList = (RecyclerView)this.findViewById(R.id.share_session_list);
        this.shareSessionLoading = (ProgressBar)this.findViewById(R.id.share_session_loading);
        this.shareSessionEmpty = (TextView)this.findViewById(R.id.share_session_empty);
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.addSearchListener();
        this.setNavigateCallback(new ImFragmentSuperView.onNavigateCallback(){

            @Override
            public void onBackClick() {
            }

            @Override
            public void onAddClick() {
            }
        });
        this.shareCreateNewSession.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onCreateSessionClick();
            }
        });
        this.shareLoadMoreContact.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onSelectGroup();
            }
        });
    }

    private void addSearchListener() {
        this.shareSearch.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String str = ShareViewSessionList.this.shareSearch.getText().toString();
                if (!TextUtils.isEmpty((CharSequence)str)) {
                    ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onSearchChanged(str);
                }
            }
        });
    }

    @Override
    public void setAdapter(ShareSessionListAdapter adapter) {
        this.shareSessionList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.shareSessionList.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    public void showDialog(final Intent intent, final TalkSessionBean talkSessionBean) {
        String account = talkSessionBean.getTalkerAccount();
        IMUiKitProxyImpl.getInstance().getAccount(account, talkSessionBean.getTalkType(), new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(AccountBean accountBean) {
                ShareBean shareBean = BeanUtils.convertAccountBean(accountBean, talkSessionBean.getTalkType());
                String action = intent.getAction();
                if (action.equals("android.intent.action.FORWARD")) {
                    new ShareDialog((Context)ShareViewSessionList.this.getActivity(), 0, (ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).showForwardDialog(shareBean, intent);
                } else {
                    IntentBean intentBean = ShareUtils.getIntentBean(intent);
                    new ShareDialog((Context)ShareViewSessionList.this.getActivity(), 0, (ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).showSingleDialog(shareBean, intentBean);
                }
            }
        });
    }

    @Override
    public void showMultiContactDialog(Intent intent, List<ShareBean> list) {
        IntentBean intentBean = ShareUtils.getIntentBean(intent);
        String action = intent.getAction();
        if (list != null) {
            if (list.size() == 1) {
                if (action.equals("android.intent.action.FORWARD")) {
                    new ShareDialog((Context)this.getActivity(), 0, (ShareSessionListPresenter)this.getPresenter()).showForwardDialog(list.get(0), intent);
                } else {
                    new ShareDialog((Context)this.getActivity(), 0, (ShareSessionListPresenter)this.getPresenter()).showSingleDialog(list.get(0), intentBean);
                }
            } else if (action.equals("android.intent.action.FORWARD")) {
                new ShareDialog((Context)this.getActivity(), 0, (ShareSessionListPresenter)this.getPresenter()).showMulitForwardDialog(list, intent);
            } else {
                new ShareDialog((Context)this.getActivity(), 1, (ShareSessionListPresenter)this.getPresenter()).showMulitDialog(list, intentBean);
            }
        }
    }

    @Override
    public void showSimpleDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_title));
        builder.setMessage((CharSequence)(this.getResources().getString(R.string.im_uikit_share_over_msg) + this.getResources().getString(R.string.app_name) + this.getResources().getString(R.string.im_uikit_share_over_msg_t)));
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_send), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onTipsDialogTrueClick();
                dialog.cancel();
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onTipsDialogClick();
                dialog.cancel();
            }
        });
        builder.create().show();
    }

    @Override
    public void showFwordSimpleDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_title));
        builder.setMessage((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_forward_msg));
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.im_uikit_share_over_send), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ((ShareSessionListPresenter)ShareViewSessionList.this.getPresenter()).onTipsDialogClick();
                dialog.cancel();
            }
        });
        builder.create().show();
    }

    @Override
    public void clearShareSearch() {
        if (this.shareSearch != null) {
            this.shareSearch.setText((CharSequence)"");
        }
    }
}

