/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.palyer;

import android.media.MediaPlayer;
import android.text.TextUtils;
import android.view.SurfaceHolder;
import com.xdja.im.lib.video.palyer.IVideoPlayCallback;
import com.xdja.im.lib.video.palyer.VideoPlayState;
import com.xdja.im.lib.video.palyer.VideoPlayer;
import com.xdja.im.lib.video.palyer.onStateChangedListener;
import com.xdja.im.lib.video.utils.AudioFunctions;
import com.xdja.im.uikit.utils.log.LogUtil;

public class VideoPlayerHelper
implements VideoPlayer,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
SurfaceHolder.Callback,
MediaPlayer.OnSeekCompleteListener {
    private SurfaceHolder mHolder;
    private MediaPlayer mMediaPlayer;
    private VideoPlayState mPlayState = VideoPlayState.DEFAULT;
    private onStateChangedListener mStateChangedListener;
    private boolean isRepeat;
    private IVideoPlayCallback mPlayCallback;
    private String filePath;

    public void setOnStateChangedListener(onStateChangedListener listener) {
        this.mStateChangedListener = listener;
    }

    public void setmPlayCallback(IVideoPlayCallback mPlayCallback) {
        this.mPlayCallback = mPlayCallback;
    }

    public VideoPlayerHelper(SurfaceHolder holder) {
        this.mHolder = holder;
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.createMediaPlayer();
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
    }

    @Override
    public void play(String filePath, boolean isRepeat) {
        this.isRepeat = isRepeat;
        this.filePath = filePath;
        if (this.mHolder == null || this.mHolder.getSurface() == null || !this.mHolder.getSurface().isValid()) {
            LogUtil.e("Start to play, but surface is not valid.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            LogUtil.e("Error:start play video, but filePath is null.");
            return;
        }
        if (this.mMediaPlayer == null) {
            this.createMediaPlayer();
        }
        try {
            this.reset();
            AudioFunctions.muteAudioFocus(true);
            this.mMediaPlayer.setDisplay(this.mHolder);
            this.mMediaPlayer.setDataSource(filePath);
            this.mMediaPlayer.prepareAsync();
            this.mPlayState = VideoPlayState.OPEN;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reset();
            this.mPlayState = VideoPlayState.EXCEPTION;
            if (this.mStateChangedListener != null) {
                this.mStateChangedListener.onStateChanged(this.mPlayState);
            }
            AudioFunctions.muteAudioFocus(false);
        }
    }

    @Override
    public void pause() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
            this.mPlayState = VideoPlayState.PAUSE;
            AudioFunctions.muteAudioFocus(false);
        }
    }

    @Override
    public void resume() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
            this.mPlayState = VideoPlayState.PLAY;
            AudioFunctions.muteAudioFocus(true);
        }
    }

    @Override
    public void stop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mPlayState = VideoPlayState.STOP;
        }
    }

    @Override
    public void destroy() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mPlayState = VideoPlayState.DEFAULT;
        }
    }

    @Override
    public void reset() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mPlayState = VideoPlayState.DEFAULT;
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public VideoPlayState getPlayState() {
        return this.mPlayState;
    }

    @Override
    public int getCurrentPosition() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.isRepeat) {
            this.play(this.filePath, this.isRepeat);
        } else {
            this.mPlayState = VideoPlayState.COMPLETION;
            if (this.mStateChangedListener != null) {
                this.mStateChangedListener.onStateChanged(this.mPlayState);
            }
            AudioFunctions.muteAudioFocus(false);
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.mPlayState = VideoPlayState.ERROR;
        if (this.mStateChangedListener != null) {
            this.mStateChangedListener.onStateChanged(this.mPlayState);
        }
        AudioFunctions.muteAudioFocus(false);
        return false;
    }

    public void onPrepared(MediaPlayer mp) {
        mp.start();
        this.mPlayState = VideoPlayState.PLAY;
        if (this.mPlayCallback != null) {
            this.mPlayCallback.surfacePrepareCallback();
        }
    }

    public void onSeekComplete(MediaPlayer mp) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDisplay(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }
}

