/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.Property;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

public class CircularProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator SWEEP_INTERPOLATOR = new LinearInterpolator();
    private static final int SWEEP_ANIMATOR_DURATION = 10000;
    private static final int SWEEP_ANGLE_INIT = -90;
    private final RectF fBounds = new RectF();
    private ObjectAnimator mObjectAnimatorSweep;
    private final Paint mPaint;
    private float mCurrentSweepAngle;
    private final float mBorderWidth;
    private boolean mRunning;
    private final Property<CircularProgressDrawable, Float> mSweepProperty = new Property<CircularProgressDrawable, Float>(Float.class, "arc"){

        public Float get(CircularProgressDrawable object) {
            return Float.valueOf(object.getCurrentSweepAngle());
        }

        public void set(CircularProgressDrawable object, Float value) {
            object.setCurrentSweepAngle(value.floatValue());
        }
    };

    public CircularProgressDrawable(int color2, float borderWidth) {
        this.mBorderWidth = borderWidth;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(borderWidth);
        this.mPaint.setColor(color2);
        this.setupAnimations();
    }

    public void draw(@NonNull Canvas canvas) {
        float startAngle = -90.0f;
        float sweepAngle = this.mCurrentSweepAngle;
        canvas.drawArc(this.fBounds, startAngle, sweepAngle, false, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.fBounds.left = this.mBorderWidth / 2.0f + 1.5f;
        this.fBounds.top = this.mBorderWidth / 2.0f + 1.5f;
        this.fBounds.right = (float)bounds.right - this.mBorderWidth / 2.0f - 1.5f;
        this.fBounds.bottom = (float)bounds.bottom - this.mBorderWidth / 2.0f - 1.5f;
    }

    private void setupAnimations() {
        this.mObjectAnimatorSweep = ObjectAnimator.ofFloat((Object)((Object)this), this.mSweepProperty, (float[])new float[]{360.0f});
        this.mObjectAnimatorSweep.setInterpolator((TimeInterpolator)SWEEP_INTERPOLATOR);
        this.mObjectAnimatorSweep.setDuration(10000L);
        this.mObjectAnimatorSweep.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.mRunning = true;
        this.mObjectAnimatorSweep.start();
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.mObjectAnimatorSweep.cancel();
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void setCurrentSweepAngle(float currentSweepAngle) {
        this.mCurrentSweepAngle = currentSweepAngle;
        this.invalidateSelf();
    }

    private float getCurrentSweepAngle() {
        return this.mCurrentSweepAngle;
    }
}

