/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.ViewTreeObserver;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseActivityPresenter;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;
import java.util.Locale;

public abstract class ShareImBaseActivity<P extends Presenter, V extends BaseView>
extends BaseActivityPresenter<P, V> {
    protected UserComponent mComponent;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.im_uikit_ImAppTheme);
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null && !TextUtils.isEmpty((CharSequence)intent.getAction()) && intent.getAction().equals("android.intent.action.MAIN")) {
            try {
                Intent intent2 = this.getPackageManager().getLaunchIntentForPackage(this.getContext().getPackageName());
                this.startActivity(intent2);
                this.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null && ImUiKit.getInstance().isMainTabExist()) {
            this.mComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        } else {
            try {
                Intent intent = this.getPackageManager().getLaunchIntentForPackage(this.getContext().getPackageName());
                this.startActivity(intent);
                this.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            this.finish();
        }
        this.getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                ShareImBaseActivity.this.onActivityFocusChanged(hasFocus);
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.fontScale != 1.0f) {
            this.getResources();
        }
        super.onConfigurationChanged(newConfig);
    }

    public Resources getResources() {
        boolean isChangeFontScale = CommonTool.isChangeFontScale();
        if (isChangeFontScale) {
            return super.getResources();
        }
        Resources resources = super.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.setLocale(Locale.CHINA);
        configuration.fontScale = 1.0f;
        try {
            resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resources;
    }

    protected void showMissingPermissionDialog() {
        new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    ShareImBaseActivity.this.startAppSettings();
                } else {
                    ShareImBaseActivity.this.finish();
                }
            }
        }).setDialogTitle(R.string.im_uikit_hint).setDialogContent(R.string.im_uikit_permission_hint).setPositiveButton(R.string.im_uikit_setting).setNegativeButton(R.string.im_uikit_btn_cancel).show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    protected void checkNetType(final OnNetCheckCallback result) {
        boolean isMobileConnected = NetworkUtil.isConnectByMobile(this.getContext());
        if (isMobileConnected) {
            new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    result.onResult(!confirm);
                }
            }).setDialogTitle(result.getTitle()).setDialogContent(result.getContent()).setPositiveButton(result.getPositiveButton()).setNegativeButton(result.getNegativeButton()).show();
        } else {
            result.onResult(false);
        }
    }

    protected Context getContext() {
        return this;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onActivityFocusChanged(boolean hasFocus) {
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }

    public abstract class OnNetCheckCallback {
        public abstract void onResult(boolean var1);

        protected String getContent() {
            return "";
        }

        protected String getTitle() {
            return ShareImBaseActivity.this.getString(R.string.im_uikit_hint);
        }

        protected String getPositiveButton() {
            return ShareImBaseActivity.this.getString(R.string.im_uikit_btn_continue);
        }

        protected String getNegativeButton() {
            return ShareImBaseActivity.this.getString(R.string.im_uikit_btn_cancel);
        }
    }
}

